/*****************************************************************************
* File Name          : BC45_Board_Category.h
* Author             : CrystalSu
* Version            : V1.0.0.0
* Date               : Feb 14, 2020
* Description        : 
******************************************************************************/   

#ifndef BC45_BOARD_CATEGORY_H 
#define BC45_BOARD_CATEGORY_H

#include <stdint.h>

#define MAX_DEVICE_ID  				127 

//-------------------------------------------------------------------------//
//------------------------ BC45 Board Command ---------------------------//
//-------------------------------------------------------------------------//
// BC45_Board Cmd
#define BC45_BOARD_CMD_TYPE		0x00

#define Get_Device_ID				0x00
#define Write_Device_ID				0x01
#define Get_Last_Response			0x02												
#define Test_Communication			0x03
#define Get_Version				0x04

#define Get_Driver_Config			0x40
#define Write_Driver_Config			0x41

// Proprietary Cmd
#define Get_Handle_RFData_Fail		        0xE0												
#define Handle_RFData_Fail			0xE1												
#define Get_Last_Response_All		        0xE2												
#define Get_ASIC_Exe_Timeout_Val	        0xE3	
#define Write_ASIC_Exe_Timeout_Val	        0xE4												
#define Get_Board_Description		        0xE5
#define Enable_Continuous_Run		        0xE6												
#define Disable_Continuous_Run		        0xE7												
#define Set_Delay_Time_ms			0xE8												
#define Get_Delay_Time_ms			0xE9	
#define On_Magnetic_Buzzer		        0xEA	

//-------------------------------------------------------------------------//
//------------------------ Define BC45 Board ---------------------------//
//-------------------------------------------------------------------------//
// Define Type of Product
#define  MODULE  			0x01 

#define  PI_READER_8CM_2LOOP    0x11
#define  Board_Type         MODULE   

#define  CUSTOMER  			0x00 
#define  FW_DETAIL     		CUSTOMER

#define  VERSION			1
#define  SUB_VERSION_1		5
#define  SUB_VERSION_2		0
#define  SUB_VERSION_3		0

typedef struct struct_tPRIOR_Resp_Package
{
	uint8_t   Sequence_Number ;		
	uint8_t   Device_ID ;			
	uint8_t   Cmd_Type ;  	
	uint8_t   Cmd ;
	uint8_t   Resp ;
	uint16_t  LenData_Resp ;
	uint16_t  LenData_Resp_All ;
	
} tPRIOR_Resp_Package ;

tPRIOR_Resp_Package* get_PRIOR_Resp_Package(void);
uint8_t get_FLAG_RETURN_RF_DATA_FAIL(void);
uint8_t BC45_Board_Command( uint8_t Command, uint8_t *Param, uint16_t LenParam, uint8_t *Data_Resp, uint16_t *LenData_Resp ) ;

uint8_t BC45_Board_Get_Device_ID( uint8_t *Device_ID, uint16_t *LenDevice_ID ) ;
uint8_t BC45_Board_Get_Driver_Config( uint8_t *Driver_Config, uint16_t *LenDriver_Config ) ;
uint8_t BC45_Board_Get_ASIC_Exe_Timeout_Val( uint8_t *Timeout_Val, uint16_t *LenTimeout_Val ) ;

uint8_t BC45_Board_GetLastResponse( uint8_t *Data_Resp, uint16_t *LenData_Resp ) ;
uint8_t BC45_Board_GetLastResponse_All( uint8_t *Data_Resp, uint16_t *LenData_Resp ) ;
uint8_t BC45_Board_TestCommunication( uint8_t *Data_LoopBack, uint16_t LenData_LoopBack, uint8_t *Data_Resp, uint16_t *LenData_Resp ) ;

uint8_t BC45_Board_Handle_RFDataFail( uint8_t Mode  ) ;
uint8_t BC45_Board_GetHandle_RFDataFail( uint8_t *Mode , uint16_t *LenMode ) ;

uint8_t BC45_Board_GetVersion( uint8_t *Version , uint16_t *LenVersion ) ;

uint8_t BC45_Board_Enable_Continuous_Run( void ) ;
uint8_t BC45_Board_Disable_Continuous_Run( void ) ;

uint8_t BC45_Board_Set_Delay_Time_ms( uint8_t *Delay_Time_ms ) ;
uint8_t BC45_Board_Get_Delay_Time_ms( uint8_t *Delay_Time_ms, uint16_t *Len_Delay_Time_ms ) ;

uint8_t BC45_Board_Get_Board_Description( uint8_t *Board_Description, uint16_t *Len_Board_Description ) ;
void ON_MAGNETIC_BUZZER_ms  ( uint8_t Freq_in , uint16_t ON_Time_ms );

#endif
