/*****************************************************************************
* File Name          : htk_uart.h
* Author             : CrystalSu
* Version            : V1.0.0.0
* Date               : Feb 11,2020
* Description        : 
******************************************************************************/  

#ifndef HTK_UART_H_
#define HTK_UART_H_

#include "ht32.h"
#include "htk_buffer.h"

typedef enum
{
  HAL_UART_STATE_RESET             = 0x00U,    /*!< Peripheral is not yet Initialized 
                                                   Value is allowed for gState and RxState */
  HAL_UART_STATE_READY             = 0x20U,    /*!< Peripheral Initialized and ready for use
                                                   Value is allowed for gState and RxState */
  HAL_UART_STATE_BUSY              = 0x24U,    /*!< an internal process is ongoing
                                                   Value is allowed for gState only */
  HAL_UART_STATE_BUSY_TX           = 0x21U,    /*!< Data Transmission process is ongoing 
                                                   Value is allowed for gState only */
  HAL_UART_STATE_BUSY_RX           = 0x22U,    /*!< Data Reception process is ongoing
                                                   Value is allowed for RxState only */
  HAL_UART_STATE_BUSY_TX_RX        = 0x23U,    /*!< Data Transmission and Reception process is ongoing 
                                                   Not to be used for neither gState nor RxState.
                                                   Value is result of combination (Or) between gState and RxState values */
  HAL_UART_STATE_TIMEOUT           = 0xA0U,    /*!< Timeout state    
                                                   Value is allowed for gState only */
  HAL_UART_STATE_ERROR             = 0xE0U     /*!< Error   
                                                   Value is allowed for gState only */
}UART_StateTypeDef;

typedef struct
{
  HT_USART_TypeDef               *Instance;        /*!< UART registers base address        */
  //UART_InitTypeDef              Init;             /*!< UART communication parameters      */
  uint8_t                       *pTxBuffPtr;      /*!< Pointer to UART Tx transfer Buffer */
  uint16_t                      TxXferSize;       /*!< UART Tx Transfer size              */
  __IO uint16_t                 TxXferCount;      /*!< UART Tx Transfer Counter           */
  uint8_t                       *pRxBuffPtr;      /*!< Pointer to UART Rx transfer Buffer */
  uint16_t                      RxXferSize;       /*!< UART Rx Transfer size              */
  __IO uint16_t                 RxXferCount;			/*!< UART Rx Transfer Counter           */

	#if 0
  DMA_HandleTypeDef             *hdmatx;          /*!< UART Tx DMA Handle parameters      */
  DMA_HandleTypeDef             *hdmarx;          /*!< UART Rx DMA Handle parameters      */
  HAL_LockTypeDef               Lock;             /*!< Locking object                     */
  __IO HAL_UART_StateTypeDef    gState;           /*!< UART state information related to global Handle management 
                                                       and also related to Tx operations.
                                                       This parameter can be a value of @ref HAL_UART_StateTypeDef */  
	#endif
  __IO UART_StateTypeDef    		RxState;          /*!< UART state information related to Rx operations.
                                                       This parameter can be a value of @ref HAL_UART_StateTypeDef */
  __IO uint32_t                 ErrorCode;        /*!< UART Error code                    */
	
}UART_HandleTypeDef;

#define HTK_UART_BUFFER_SIZE 128

extern __IO serial_RB_t rxFIFO;

void htk_UART_Init(HT_USART_TypeDef *huart, uint8_t *pCMDline);
void htk_UART_Transmit(uint8_t * pData, uint16_t size);
uint8_t toAsciiHex(uint8_t data);
void dataToHex(uint8_t * dataOut, uint8_t dataIn);

uint8_t customStrLen(uint8_t * str);
void customToLower(uint8_t * dataStr, uint8_t dataStrLen);
void data_to_dec(uint8_t * dataOut, uint8_t dataIn);
uint8_t customParseHEX(uint8_t * s, uint8_t sLen, uint8_t * valHEX);

void USART1_IRQHandler(void);

#endif /* HTK_UART_H_ */
