INCLUDE HT66F40.INC

#DEFINE 	SCLC		PDC5
#DEFINE 	SCL			PD5
#DEFINE 	SDAC		PDC4
#DEFINE 	SDA			PD4
;========================================================================================
DS	.SECTION	'DATA'
;========================================================================================
DEL1  		DB      ?                   ;DELAY LOOP COUNT 1
DEVICE_FLAG	DBIT						;FOUND I2C DEVICE FLAG
COUNT		DB		?					;ROW COUNTER USED IN READ_KEY
DEVICE_ID	DB		?
BYTE_COUNT	DB		?
I2C_DATA	DB		?					;I2C BYTE R/W DATA BUFFER
;========================================================================================

CS	.SECTION	AT  000H	'CODE'
	ORG		00H
	JMP		MAIN
	ORG		004H
	RETI
	ORG		008H
	RETI
	ORG		00CH
	RETI
	ORG		010H
	RETI
	ORG		014H
	RETI
	ORG		018H
	RETI
	ORG		01CH
	RETI
	ORG		020H
	RETI
	ORG		024H
	RETI
	ORG		028H
	RETI
	ORG		02CH
	RETI


MAIN:
	SNZ	HTO
	JMP MAIN
	SNZ LTO
	JMP	MAIN
	CALL INI_WDT			;INITIALIZE WDT 	
	MOV	A,4CH				;7M21x6 I2C ADDRESS IS 4CH		
	RL	ACC					
	MOV	DEVICE_ID,A			;SET I2C ADDRESS
	
LOOP:
	CLR WDT	
	CALL I2C_START			;START CONDITION
	CALL I2C_DEV_SEL_W		;I2C DATA WRITE COMMAND
	
	MOV	A,02H				
	CALL WRITE_BYTE			;WRITE LUMI REGISTER
	CALL CHECK_ACK			;CHECK ACK	
		
	MOV	A,3FH		
	CALL WRITE_BYTE			;WRITE CONFIG DATA
	CALL CHECK_ACK			;CHECK ACK	
	
	CALL I2C_STOP			;STOP I2C
	
	JMP LOOP
	
;========================================================================================
; PROC	: INI_WDT
; FUNC	: INITIALIZE WDT
;========================================================================================
INI_WDT			PROC	
		MOV	A,01111010B
		MOV	WDTC,A
		RET
INI_WDT			ENDP
;========================================================================================
; PROC	: I2C_START
; FUNC	: GENERATE I2C START CONDITION
; CALL	: DELAY10
;========================================================================================
I2C_START		PROC	
		CLR     SCL					;SET SCL=0
		CLR     SDA					;SET SDA=0							
		CLR		SCLC				;CONFIG SLC AS OUTPUT MODE
		CLR		SDAC				;CONFIG SDA AS OUTPUT MODE
        CALL    DELAY_10			;DELAY
        SET     SCL					;SET SCL=1
        SET    	SDA					;SET SDA=1
        CALL    DELAY_10			;DELAY
        CLR    	SDA					;SET SDA=0
        CALL    DELAY_10			;DELAY
        CLR    	SCL 				;SET SCL=0
        CALL    DELAY_10			;DELAY
        RET  
I2C_START		ENDP
;********************************************************************
;             SEND I2C DEVICE SELECT CODE (R/W) TO DEVICE        
;********************************************************************
I2C_DEV_SEL_W	PROC				;WRITE MODE								
		MOV		A,DEVICE_ID			;LOAD A WITH DEVICE SELECT CODE
		CLR		ACC.0				;SET SRW T0 0 FOR WRITING TO I2C
		JMP		DEV_SEL
I2C_DEV_SEL_R:						;READ MODE
		MOV		A,DEVICE_ID			;LOAD A WITH DEVICE SELECT CODE
		SET		ACC.0				;SET SRW T0 1 FOR READING FROM I2C		
DEV_SEL:CALL	WRITE_BYTE			;SEND OUT 1 BYTE DATA IN ACC
		CALL	CHECK_ACK			;WAIT FOR DEVICE ACK SIGNAL
	    RET
I2C_DEV_SEL_W	ENDP	
;========================================================================================
; PROC	: I2C_STOP
; FUNC	: GENERATE I2C STOP CONDITION 
; CALL	: DELAY10
;========================================================================================
I2C_STOP		PROC
		CLR     SCL					;SET SCL=0
		CLR     SDA					;SET SDA=0
		CLR		SDAC				;CONFIG SDA AS OUTPUT MODE
        CALL    DELAY_10			;DELAY
        SET     SCL					;SET SCL=1
        CALL    DELAY_10			;DELAY	
        CLR    	SDA 				;SET SDA=0
        CALL    DELAY_10			;DELAY
        SET    	SDA					;SET SDA=1
        RET
I2C_STOP		ENDP		
;========================================================================================
; PROC	: WRITE_BYTE
; FUNC	: SERIAL OUT DATA IN ACC VIA SDA & SCL
; PARA	: ACC : DATA TO BE WRITTEN
; REG	: I2C_DATA, BYTE_COUNT
; CALL	: DELAY10
;========================================================================================
WRITE_BYTE		PROC
		CLR     SCL					;SET SCL=0
		CLR		SDAC				;CONFIG SDA AS OUTPUT MODE
		MOV		I2C_DATA,A			;RESERVED DATA IN TX BUFFER
		MOV		A,8					;SET 8 BIT COUNTER
		MOV		BYTE_COUNT,A
WRITE_0:CLR		SDA					;SET SDA=0
		SZ     	I2C_DATA.7			;IS DATA BIT = 0?
		SET     SDA					;NO, SET SDA=1		
		CALL    DELAY_10			;DELAY
	    SET     SCL      			;SET SCL=1
        CALL 	DELAY_10			;DELAY
   		CLR		SCL					;SET SCL=0
		CALL    DELAY_10			;DELAY
		RL     	I2C_DATA			;SHIFT TX BUFFER
        SDZ     BYTE_COUNT   		;BYTE_COUNT-1 = 0?
		JMP		WRITE_0				;NO, WRITE NEXT BIT
		RET							;YES, RETURN.
WRITE_BYTE	ENDP
;========================================================================================
; PROC	: CHECK_ACK 
; FUNC	: CHECK ACK SIGNAL FROM I2C DEVICE
; REG	: DEL1
; CALL	: DELAY10
; RETN	: DEVICE_FLAG (0/1 FOR ACK/NO_ACK
;========================================================================================
CHECK_ACK	PROC
		SET		SDAC				;CONFIG	SDA AS INPUT MODE
  		CALL    DELAY_10			;DELAY
        SET		SCL					;SET SCL=1
        CALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLALLAL