#include "HT66F40.h"

#define	SCLC		_pdc5							//DEFINE SCL CONTROL BIT,PAC5
#define	SDAC		_pdc4							//DEFINE SDA CONTROL BIT,PAC4
#define	SCL			_pd5							//DEFINE SCL SIGNAL PIN,PA5
#define	SDA			_pd4							//DEFINE SCL SIGNAL PIN,PA4
 
void Ini_WDT(void);
void I2C_START(void);
void I2C_STOP(void);
void WriteByte(unsigned short);
void CheckACK(void);
void _delay(void);

unsigned char DeviceFlag,i2c_address,write_buf;

void main()
{
	Ini_WDT();										//initialize WDT 
	i2c_address=0x4C;								//SET i2c_address 
	while(1)
	{
		_clrwdt();
		I2C_START();								//start condition
		
		WriteByte(i2c_address<<1 & 0xFE);			//i2c data write command
		CheckACK();									//check ack
		
		WriteByte(0x02);							//write lumi register
		CheckACK();									//check ack
		
		WriteByte(0x3f);							//write config data						
		CheckACK();									//check ack
			
		I2C_STOP();									//stop i2c									
	}
	
}

void Ini_WDT(void)								   //initialize WDT 
{
	_wdtc=0x7a;
}

void I2C_START(void)
{	SCL=0; SDA=0;								   	//Set SCL=0, SDA=0
	SCLC=0;SDAC=0;								   	//SCL/SDA as Output Mode
	_delay();
	SCL=1; SDA=1; _delay();							//SCL=1, SDA=1, Delay 
	SDA=0; _delay();								//SDA=0, Delay 	
	SCL=0; _delay();								//SCL=0, Delay 	
}
void I2C_STOP(void)
{	SCL=0; SDA=0;									   //Set SCL=0, SDA=0
	SDAC=0;										   	//SDA as Output Mode
	_delay();
	SCL=1; _delay();								//SCL=1, Delay 
	SDA=0; _delay();								//SDA=0, Delay 
	SDA=1; _delay();								//SDA=1, Delay 	
}
void WriteByte(unsigned short I2CData)
{	unsigned short temp=0b10000000;
	SCL=0; SDAC=0;									   //SCL=0, SDAC as Output
	do
	{	
		write_buf=I2CData & temp;
		if(write_buf==0) 							  //Set SDA State 
		SDA=0;
		else
		SDA=1;
		_delay();	       							//delay 
		//delay 
		//deeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee{	unsigned short temp=0b10000000;
{	unsigned short temp=0b1000000mp=0b1000000mp=0b1000000mp=0b1000000000000000000000000000000000000rite_buf==0) 							  //Set SDA S(write_buf==0) 							  //Set SDA	  //Set SDA	  //Set SDA	  //Set                                  eeeeeeeeeeeeeeeeeeeeeee{	unsignedeeeeeeeeeeeeeeeeeeeeeeeee{	unsigneeee{	unsigneeee{	unsigneeee{	unssssssssssssssssssssssssssssssssss00000000000000000000000rite_buf==0000000000000000000000000rite_buf0000rite_buf0000rite_buf0000rite