/*************************************************
File:         readGasValue.ino
Description:  Module driven stepper motor
Note:         Module M1A, M1B, M2A, and M2B pins are connected to BMduino UNO pins 0, 1, 2, and 3, respectively
**************************************************/
#include "BM22D1221_1421.h"

BM22D1221_1421 MyStepper(HALF4WIRE);          //Create an object and set it as a half step drive
void setup()
{
  MyStepper.begin();                          //Object initialization
  MyStepper.setStepperMaxSpeed(1600);         //Set the maximum speed of the stepper motor to 1600 steps/s
  MyStepper.setStepperAcceleration(400);      //Set the acceleration of the stepper motor to 400 steps/s²
}

void loop() 
{
  MyStepper.stepperMove(800, 1600);           //The stepper motor runs 800 steps at a speed of 1600 steps/s
  delay (1000);                               //Wait for 1 second
  MyStepper.stepperMoveTo(0);                 //Stepper motor at 400 steps/s ² Run the acceleration to zero position
  delay (1000);                               //Wait for 1 second
}
