/**
 * *************************************************************************************************************
 * @file ATM.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for ATM firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _ATM_H_
#define _ATM_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH67F2472.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! timer Counter Clock selection enum */
typedef enum {
    ATM_CLOCK_FSYS_4   = (0x00 << 4),
    ATM_CLOCK_FSYS     = (0x01 << 4),
    ATM_CLOCK_FH_16    = (0x02 << 4),
    ATM_CLOCK_FH_64    = (0x03 << 4),
    ATM_CLOCK_FSUB     = (0x04 << 4),
    ATM_CLOCK_PIN_RISE = (0x06 << 4),
    ATM_CLOCK_PIN_FALL = (0x07 << 4),
} ATM_Clock_e;

/*! ATM count clear mode enum */
typedef enum {
    ATM_COUNT_CLEAR_P_MATCH,
    ATM_COUNT_CLEAR_A_MATCH,
} ATM_CountClear_e;

/*! compare match output mode enum */
typedef enum {
    ATM_COMPAREMATCH_KEEP_L               = (0x00 << 3),
    ATM_COMPAREMATCH_KEEP_H               = (0x01 << 3),
    ATM_COMPAREMATCH_INIT_H_OUTPUT_L      = (0x03 << 3),
    ATM_COMPAREMATCH_INIT_L_OUTPUT_H      = (0x04 << 3),
    ATM_COMPAREMATCH_INIT_L_OUTPUT_TOGGLE = (0x06 << 3),
    ATM_COMPAREMATCH_INIT_H_OUTPUT_TOGGLE = (0x07 << 3),
} ATM_CompareMatch_Output_e;

/*! compare match output configuration */
typedef struct {
    uint8_t clockSource;    //!< RW @see ATM_Clock_e
    uint8_t outputMode;     //!< RW @see ATM_CompareMatch_Output_e
    uint8_t countClear;     //!< RW @see ATM_CountClear_e
    bool pinInvert;
    uint16_t count;
} ATM_Cfg_CompareMatchOutputMode_t;

/*! pwm output mode enum */
typedef enum {
    ATM_PWM_OUTPUT_KEEP_H       = (0x00 << 3),
    ATM_PWM_OUTPUT_KEEP_L       = (0x01 << 3),
    ATM_PWM_OUTPUT_PWM_ACTIVE_L = (0x04 << 3),
    ATM_PWM_OUTPUT_PWM_ACTIVE_H = (0x05 << 3),
} ATM_PWM_Output_e;

/*! PWM output Duty period enum */
typedef enum {
    ATM_PWM_DUTY_CCRA_PERIOD_CCRP,
    ATM_PWM_DUTY_CCRP_PERIOD_CCRA,
} STM_PWM_DutyPeriod_e;

/*! PWM output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see ATM_Clock_e
    uint8_t outputMode;     //!< R/W @see ATM_PWM_Output_e
    uint8_t dutyPeriod;     //!< R/W @see ATM_PWM_DutyPeriod_e
    bool pinInvert;
    uint16_t ccraData;
    uint16_t ccrpData;
} ATM_Cfg_PWM_t;

/*! TimerCount configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see ATM_Clock_e
    uint8_t countClear;     //!< R/W @see ATM_CountClear_e
    uint16_t count;
} ATM_Cfg_TimerCounter_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void ATM_Cfg_CompareMatchOutput(ATM_Cfg_CompareMatchOutputMode_t *cfg);
void ATM_Cfg_TimerCounter(ATM_Cfg_TimerCounter_t *cfg);
void ATM_Cfg_PWM(ATM_Cfg_PWM_t *cfg);
#define ATM_Enable()           { _atpau = 0;  _aton = 1;}
#define ATM_Disable()          { _aton = 0;}
#define ATMA_Isr_Enable()      { _atmaf = 0; _atmae =1; _mf2e = 1;}
#define ATMA_Isr_Disable()     { _atmae = 0;}
#define ATMP_Isr_Enable()      { _atmpf = 0; _atmpe =1; _mf2e  = 1;}
#define ATMP_Isr_Disable()     { _atmpe = 0;}

// clang-format on
#endif