/**
 * *************************************************************************************************************
 * @file Adc12.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Adc12 firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.1

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include <stdint.h>
#include "stdbool.h"
#include "ADC12.h"
#include "Oscillators.h"

#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 8000000    //!< 設置系統頻率，目前支援設置為 4000000,8000000,12000000
#endif

// clang-format off
#define SET_ADC_START_CONVERT()		{ _start = 0; _start = 1; _start = 0;}
#define SET_ADC_DATA_4_15()			{ _adrfs = 0; }
#define SET_ADC_DATA_0_11()			{ _adrfs = 1; }

#if SYS_CLOCK_FREQ == 4000000
    #define SET_ADC_CLOCK_SYS_2()	{ _sacks2 = 0; _sacks1 = 0; _sacks0 = 1;}
    #define SET_ADC_CLOCK_SYS_4()	{ _sacks2 = 0; _sacks1 = 1; _sacks0 = 0;}
    #define SET_ADC_CLOCK_SYS_8()	{ _sacks2 = 0; _sacks1 = 1; _sacks0 = 1;}
    #define SET_ADC_CLOCK_SYS_16()	{ _sacks2 = 1; _sacks1 = 0; _sacks0 = 0;}
    #define SET_ADC_CLOCK_SYS_32()	{ _sacks2 = 1; _sacks1 = 0; _sacks0 = 1;}
#endif
#if SYS_CLOCK_FREQ == 8000000
    #define SET_ADC_CLOCK_SYS_4()	{ _sacks2 = 0; _sacks1 = 1; _sacks0 = 0;}
    #define SET_ADC_CLOCK_SYS_8()	{ _sacks2 = 0; _sacks1 = 1; _sacks0 = 1;}
    #define SET_ADC_CLOCK_SYS_16()	{ _sacks2 = 1; _sacks1 = 0; _sacks0 = 0;}
    #define SET_ADC_CLOCK_SYS_32()	{ _sacks2 = 1; _sacks1 = 0; _sacks0 = 1;}
    #define SET_ADC_CLOCK_SYS_64()	{ _sacks2 = 1; _sacks1 = 1; _sacks0 = 0;}
#endif
#if SYS_CLOCK_FREQ == 12000000
    #define SET_ADC_CLOCK_SYS_8()	{ _sacks2 = 0; _sacks1 = 1; _sacks0 = 1;}
    #define SET_ADC_CLOCK_SYS_16()	{ _sacks2 = 1; _sacks1 = 0; _sacks0 = 0;}
    #define SET_ADC_CLOCK_SYS_32()	{ _sacks2 = 1; _sacks1 = 0; _sacks0 = 1;}
    #define SET_ADC_CLOCK_SYS_64()	{ _sacks2 = 1; _sacks1 = 1; _sacks0 = 0;}
#endif
// clang-format on

void Adc12_Cfg(Adc12_Cfg_t *cfg)
{
    _sadc1 = cfg->channel & 0xF0;
    _sadc1 += cfg->reference;
    _sadc0 = cfg->channel & 0x0F;
    SET_ADC_CLOCK_SYS_16();
    SET_ADC_DATA_0_11();
}

/**
 * @brief 採樣 avgCnt 數據去除最大最小值並返回平均值
 *
 * @param avgCnt 採樣率筆數
 * @return uint16_t 去掉最大最小後的平均值
 */
uint16_t Adc12_Sampling(uint8_t avgCnt)
{
    uint16_t adcData;
    uint16_t adcDataMax = 0;
    uint16_t adcDataMin = UINT16_MAX;
    Adc12_Enable();
    uint8_t i;
    uint16_t sum = 0;
    for (i = 0; i < avgCnt; i++)
    {
        SET_ADC_START_CONVERT();
        while (_adbz)
            ;
        adcData = _sadol;
        adcData += _sadoh * 256;
        sum += adcData;
        if (adcData > adcDataMax)
        {
            adcDataMax = adcData;
        }
        if (adcData < adcDataMin)
        {
            adcDataMin = adcData;
        }
    }
    Adc12_Disable();
    adcData = (sum - adcDataMax - adcDataMin) / (avgCnt - 2);
    return adcData;
}