/**
 * *************************************************************************************************************
 * @file Lcd.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Lcd firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "lcd.h"

/**
 * @brief config Lcd C type
 *
 * @param lcdCfg lcd C type config
 */
void LcdCtype_Cfg(const Lcd_CType_Cfg_t *lcdCfg)
{
    _lcdc0 = lcdCfg->waveform + lcdCfg->power;
    _lcdc2 = lcdCfg->pumpClock + lcdCfg->duty;
}

/**
 * @brief Lcd all on
 */
void Lcd_AllOn()
{
    _mp1h = 4;
    _mp1l = 0x00;
    for (_tblp = 0x00; _tblp <= 36; _tblp++)
    {
        _iar1 = 0xFF;
        _mp1l++;
    }
}

/**
 * @brief Lcd all off
 */
void Lcd_AllOff()
{
    _mp1h = 4;
    _mp1l = 0x00;
    for (_tblp = 0x00; _tblp <= 36; _tblp++)
    {
        _iar1 = 0x00;
        _mp1l++;
    }
}