/**
 * *************************************************************************************************************
 * @file Oscillators.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Oscillators firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0
 * # 主要功能
 *  * 系统频率使用fH
 *  * 若有LXT功能，Cpu关闭时默认开启，方便作为RTC计时
 *  * 对于有HXT、LXT的MCU，若使能了HXT、LXT，但硬件异常可能造成MCU WDT溢出
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "..\board\BoardCfg.h"
#include "Oscillators.h"
#include "BH67F2472.h"

#ifndef SYS_CLOCK_FREQ
    #define SYS_CLOCK_FREQ 8000000    //!< 設置系統頻率，目前支援設置為 4000000,8000000,12000000
#endif
#if (SYS_CLOCK_FREQ != FH_CLOCK_FREQ)
    #error "Please set the correct SYS_CLOCK_FREQ in boardCfg.h"
#endif

/**
 * @brief 配置系統頻率
 * @attention 部分IC LXT功能 需要在 LXT2 Pin 加上拉10M到 VDD，詳細參考規格書 LXT 描述
 * @warning 若電路 HXT 晶振和 LXT 異常會造成程序在此死循環
 */
void Oscillators_Cfg(void)
{
    // clang-format off
#ifdef _HXT_
    PIN_PD6_OSC1();
    PIN_PD7_OSC2();
    _fhs = 1;
    #if (SYS_CLOCK_FREQ <= 10000000)
    _hxtc = 0x01;    // HXTM = 0, HXT Frequency<=10MHz,HXT Oscillator Enable
    #elif (SYS_CLOCK_FREQ > 10000000)
    _hxtc = 0x05;    // HXTM = 1, HXT Frequency>10MHz,HXT Oscillator Enable
    #else
        #error "Please set the correct SYS_CLOCK_FREQ in boardCfg.h"
    #endif
    while (!_hxtf)
        ;    // Wait HXT Oscillator Stable
#endif
#ifndef _HXT_
    _fhs = 0;
    #if (SYS_CLOCK_FREQ == 4000000)
    _hircc = 0x01;
    #elif (SYS_CLOCK_FREQ == 8000000)
    _hircc = 0x05;
    #elif (SYS_CLOCK_FREQ == 12000000)
    _hircc = 0x09;
    #else
        #error "Please set the correct SYS_CLOCK_FREQ in boardCfg.h"
    #endif
    while (!_hircf)
        ;    // Wait HIRC Oscillator Stable
#endif
#ifdef _LXT_
    _fss    = 1;
    _fsiden = 1;
    PIN_PC3_XT1();
    PIN_PC4_XT2();
    _lxten = 1;
    while (!_lxtf)
        ;    // Wait LXT Oscillator Stable
#endif
#ifndef _LXT_
    _fss = 0;
#endif
}
