/**
 * *************************************************************************************************************
 * @file PTM.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for PTM firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "PTM.h"
#include "..\board\BoardCfg.h"

/*! timer work mode selection enum */
typedef enum {
    TIMER_COMPARE_MATCH_OUTPUT    = (0x00 << 6),
    TIMER_CAPTURE_INPUT           = (0x01 << 6),
    TIMER_PWM_SINGLE_PULSE_OUTPUT = (0x02 << 6),
    TIMER_TIMER_COUNTER           = (0x03 << 6),
} TimerModeCfg_t;

// clang-format off
// Timer
#define SET_TMn_CLOCK(n, type)          { _ptm##n##c0 &= 0x8F; _ptm##n##c0 |= type;}
#define SET_TMn_MODE(n, type)           { _ptm##n##c1 &= 0x3F; _ptm##n##c1 |= type;}
#define SET_TMn_CCRA(n,x)               { _ptm##n##al = x%256; _ptm##n##ah = x/256;}
#define SET_TMn_CCRP(n,x)               { _ptm##n##rpl = x%256; _ptm##n##rph = x/256;}
#define SET_TMn_OUTPUT_INVERT(n,type)   {_pt##n##pol = type;}
#define SET_TMn_COUNT_CLEAR(n,type)     {_pt##n##cclr = type;}
#define SET_TMn_OUTPUT_MODE(n,type)     {_ptm##n##c1 &= 0xC7; _ptm##n##c1 |= type;}

// Capture Input mode
#define SET_CAPTURE_INPUT_EDGE(n,type)  {_ptm##n##c1 &= 0xCF; _ptm##n##c1 |= type;}
#define SET_CAPTURE_INPUT_PIN(n, type)  {_pt##n##capts = type;}

// clang-format on

/**
 * @brief PTM0 compare match configuration
 *
 * @param Cfg @see PTM_Cfg_CompareMatchOutputMode_t
 */
void PTM0_Cfg_CompareMatchOutput(PTM_Cfg_CompareMatchOutputMode_t *cfg)
{
#if defined(PIN_PTCK0_PD2)
    PIN_PD2_PTCK0();
#endif
#if defined(PIN_PTP0_PB4)
    PIN_PB4_PTP0();
#endif
#if defined(PIN_PTP0_PD0)
    PIN_PD0_PTP0();
#endif
#if defined(PIN_PTP0B_PB5)
    PIN_PB5_PTP0B();
#endif
#if defined(PIN_PTP0B_PD1)
    PIN_PD1_PTP0B();
#endif
    SET_TMn_MODE(0, TIMER_COMPARE_MATCH_OUTPUT);
    SET_TMn_CLOCK(0, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(0, cfg->outputMode);
    SET_TMn_COUNT_CLEAR(0, cfg->countClear);
    SET_TMn_OUTPUT_INVERT(0, cfg->pinInvert);
    if (cfg->countClear == PTM_COUNT_CLEAR_A_MATCH)
    {
        SET_TMn_CCRA(0, cfg->count);
    }
    else
    {
        SET_TMn_CCRP(0, cfg->count);
    }
}

/**
 * @brief PTM0 pwm configuration
 *
 * @param Cfg @see PTM_Cfg_PWM_t
 */
void PTM0_Cfg_PWM(PTM_Cfg_PWM_t *cfg)
{
#if defined(PIN_PTCK0_PD2)
    PIN_PD2_PTCK0();
#endif
#if defined(PIN_PTP0_PB4)
    PIN_PB4_PTP0();
#endif
#if defined(PIN_PTP0_PD0)
    PIN_PD0_PTP0();
#endif
#if defined(PIN_PTP0B_PB5)
    PIN_PB5_PTP0B();
#endif
#if defined(PIN_PTP0B_PD1)
    PIN_PD1_PTP0B();
#endif
    SET_TMn_MODE(0, TIMER_PWM_SINGLE_PULSE_OUTPUT);
    SET_TMn_CLOCK(0, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(0, cfg->outputMode);
    SET_TMn_OUTPUT_INVERT(0, cfg->pinInvert);
    SET_TMn_CCRA(0, cfg->ccraData);
    SET_TMn_CCRP(0, cfg->ccrpData);
}

/**
 * @brief PTM0 Single pulse output configuration
 *
 * @param Cfg @see PTM_Cfg_SinglePulseOutput_t
 */
void PTM0_Cfg_SinglePulseOutput(PTM_Cfg_SinglePulseOutput_t *cfg)
{
#if defined(PIN_PTCK0_PD2)
    PIN_PD2_PTCK0();
#endif
#if defined(PIN_PTP0_PB4)
    PIN_PB4_PTP0();
#endif
#if defined(PIN_PTP0_PD0)
    PIN_PD0_PTP0();
#endif
#if defined(PIN_PTP0B_PB5)
    PIN_PB5_PTP0B();
#endif
#if defined(PIN_PTP0B_PD1)
    PIN_PD1_PTP0B();
#endif
    SET_TMn_MODE(0, TIMER_PWM_SINGLE_PULSE_OUTPUT);
    SET_TMn_CLOCK(0, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(0, cfg->outputMode);
    SET_TMn_OUTPUT_INVERT(0, cfg->pinInvert);
    SET_TMn_CCRA(0, cfg->ccraData);
}

/**
 * @brief PTM0 timer configuration
 *
 * @param Cfg @see PTM_Cfg_TimerCounter_t
 */
void PTM0_Cfg_TimerCounter(PTM_Cfg_TimerCounter_t *cfg)
{
#if defined(PIN_PTCK0_PD2)
    PIN_PD2_PTCK0();
#endif
    SET_TMn_COUNT_CLEAR(0, cfg->countClear);
    SET_TMn_MODE(0, TIMER_TIMER_COUNTER);
    SET_TMn_CLOCK(0, cfg->clockSource);
    if (cfg->countClear == PTM_COUNT_CLEAR_A_MATCH)
    {
        SET_TMn_CCRA(0, cfg->count);
    }
    else
    {
        SET_TMn_CCRP(0, cfg->count);
    }
}

/**
 * @brief PTM1 compare match configuration
 *
 * @param Cfg @see PTM_Cfg_CompareMatchOutputMode_t
 */
void PTM1_Cfg_CompareMatchOutput(PTM_Cfg_CompareMatchOutputMode_t *cfg)
{
#if defined(PIN_PTCK1_PE5)
    PIN_PE5_PTCK1();
#endif
#if defined(PIN_PTP1_PE3)
    PIN_PE3_PTP1();
#endif
#if defined(PIN_PTP1B_PE4)
    PIN_PE4_PTP1B();
#endif
    SET_TMn_MODE(1, TIMER_COMPARE_MATCH_OUTPUT);
    SET_TMn_CLOCK(1, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(1, cfg->outputMode);
    SET_TMn_COUNT_CLEAR(1, cfg->countClear);
    SET_TMn_OUTPUT_INVERT(1, cfg->pinInvert);
    if (cfg->countClear == PTM_COUNT_CLEAR_A_MATCH)
    {
        SET_TMn_CCRA(1, cfg->count);
    }
    else
    {
        SET_TMn_CCRP(1, cfg->count);
    }
}

/**
 * @brief PTM1 pwm configuration
 *
 * @param Cfg @see PTM_Cfg_PWM_t
 */
void PTM1_Cfg_PWM(PTM_Cfg_PWM_t *cfg)
{
#if defined(PIN_PTCK1_PE5)
    PIN_PE5_PTCK1();
#endif
#if defined(PIN_PTP1_PE3)
    PIN_PE3_PTP1();
#endif
#if defined(PIN_PTP1B_PE4)
    PIN_PE4_PTP1B();
#endif
    SET_TMn_MODE(1, TIMER_PWM_SINGLE_PULSE_OUTPUT);
    SET_TMn_CLOCK(1, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(1, cfg->outputMode);
    SET_TMn_OUTPUT_INVERT(1, cfg->pinInvert);
    SET_TMn_CCRA(1, cfg->ccraData);
    SET_TMn_CCRP(1, cfg->ccrpData);
}

/**
 * @brief PTM1 Single pulse output configuration
 *
 * @param Cfg @see PTM_Cfg_SinglePulseOutput_t
 */
void PTM1_Cfg_SinglePulseOutput(PTM_Cfg_SinglePulseOutput_t *cfg)
{
#if defined(PIN_PTCK1_PE5)
    PIN_PE5_PTCK1();
#endif
#if defined(PIN_PTP1_PE3)
    PIN_PE3_PTP1();
#endif
#if defined(PIN_PTP1B_PE4)
    PIN_PE4_PTP1B();
#endif
    SET_TMn_MODE(1, TIMER_PWM_SINGLE_PULSE_OUTPUT);
    SET_TMn_CLOCK(1, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(1, cfg->outputMode);
    SET_TMn_OUTPUT_INVERT(1, cfg->pinInvert);
    SET_TMn_CCRA(1, cfg->ccraData);
}

/**
 * @brief PTM1 timer configuration
 *
 * @param Cfg @see PTM_Cfg_TimerCounter_t
 */
void PTM1_Cfg_TimerCounter(PTM_Cfg_TimerCounter_t *cfg)
{
#if defined(PIN_PTCK1_PE5)
    PIN_PE5_PTCK1();
#endif
    SET_TMn_COUNT_CLEAR(1, cfg->countClear);
    SET_TMn_MODE(1, TIMER_TIMER_COUNTER);
    SET_TMn_CLOCK(1, cfg->clockSource);
    if (cfg->countClear == PTM_COUNT_CLEAR_A_MATCH)
    {
        SET_TMn_CCRA(1, cfg->count);
    }
    else
    {
        SET_TMn_CCRP(1, cfg->count);
    }
}
