/**
 * *************************************************************************************************************
 * @file STM.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for STM firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _STM_H_
#define _STM_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH67F2472.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! timer Counter Clock selection enum */
typedef enum {
    STM_CLOCK_FSYS_4   = (0x00 << 4),
    STM_CLOCK_FSYS     = (0x01 << 4),
    STM_CLOCK_FH_16    = (0x02 << 4),
    STM_CLOCK_FH_64    = (0x03 << 4),
    STM_CLOCK_FSUB     = (0x04 << 4),
    STM_CLOCK_PIN_RISE = (0x06 << 4),
    STM_CLOCK_PIN_FALL = (0x07 << 4),
} STM_Clock_e;

/*! STM count clear mode enum */
typedef enum {
    STM_COUNT_CLEAR_P_MATCH,
    STM_COUNT_CLEAR_A_MATCH,
} STM_CountClear_e;

/*! compare match output mode enum */
typedef enum {
    STM_COMPAREMATCH_KEEP_L               = (0x00 << 3),
    STM_COMPAREMATCH_KEEP_H               = (0x01 << 3),
    STM_COMPAREMATCH_INIT_H_OUTPUT_L      = (0x03 << 3),
    STM_COMPAREMATCH_INIT_L_OUTPUT_H      = (0x04 << 3),
    STM_COMPAREMATCH_INIT_L_OUTPUT_TOGGLE = (0x06 << 3),
    STM_COMPAREMATCH_INIT_H_OUTPUT_TOGGLE = (0x07 << 3),
} STM_CompareMatch_Output_e;

/*! compare match output configuration */
typedef struct {
    uint8_t clockSource;    //!< RW @see STM_Clock_e
    uint8_t outputMode;     //!< RW @see STM_CompareMatch_Output_e
    uint8_t countClear;     //!< RW @see STM_CountClear_e
    bool pinInvert;
    uint16_t count;
} STM_Cfg_CompareMatchOutputMode_t;

/*! Capture Input Mode output mode enum */
typedef enum {
    STM_CAPTURE_EDGE_RISE    = (0x00 << 4),
    STM_CAPTURE_EDGE_FALL    = (0x01 << 4),
    STM_CAPTURE_EDGE_DUAL    = (0x02 << 4),
    STM_CAPTURE_EDGE_DISABLE = (0x03 << 4),
} STM_CaptureInput_Edge_e;

/*! Capture input configuration */
typedef struct {
    uint8_t clockSource;    //!< RW @see STM_Clock_e
    uint8_t inputEdge;      //!< RW @see STM_CaptureInput_Edge_e
    uint8_t count;          //!< RW period = 1/STM_CLOCK * count * 256 (count = 0~255)
} STM_Cfg_CaptureInput_t;

/*! pwm output mode enum */
typedef enum {
    STM_PWM_OUTPUT_KEEP_H       = (0x00 << 3),
    STM_PWM_OUTPUT_KEEP_L       = (0x01 << 3),
    STM_PWM_OUTPUT_PWM_ACTIVE_L = (0x04 << 3),
    STM_PWM_OUTPUT_PWM_ACTIVE_H = (0x05 << 3),
} STM_PWM_Output_e;

/*! PWM output Duty period enum */
typedef enum {
    STM_PWM_DUTY_CCRA_PERIOD_CCRP,
    STM_PWM_DUTY_CCRP_PERIOD_CCRA,
} STM_PWM_DutyPeriod_e;

/*! PWM output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see STM_Clock_e
    uint8_t outputMode;     //!< R/W @see STM_PWM_Output_e
    uint8_t dutyPeriod;     //!< R/W @see STM_PWM_DutyPeriod_e
    bool pinInvert;
    uint16_t ccraData;
    uint8_t ccrpData;
} STM_Cfg_PWM_t;

/*! Single pulse output enum */
typedef enum {
    STM_SINGLE_PULSE_OUTPUT_ACTIVE_L = (0x06 << 3),
    STM_SINGLE_PULSE_OUTPUT_ACTIVE_H = (0x07 << 3),
} STM_SinglePulseOutput_e;

/*! Single pulse output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see STM_Clock_e
    uint8_t outputMode;     //!< R/W @see STM_SinglePulseOutput_e
    bool pinInvert;
    uint16_t ccraData;
} STM_Cfg_SinglePulseOutput_t;

/*! TimerCount configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see STM_Clock_e
    uint8_t countClear;     //!< R/W @see STM_CountClear_e
    uint16_t count;         //!< R/W period = 1/STM_CLOCK * Count
} STM_Cfg_TimerCounter_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void STM_Cfg_CompareMatchOutput(STM_Cfg_CompareMatchOutputMode_t *cfg);
void STM_Cfg_SinglePulseOutput(STM_Cfg_SinglePulseOutput_t *cfg);
void STM_Cfg_CaptureInput(STM_Cfg_CaptureInput_t *cfg);
void STM_Cfg_TimerCounter(STM_Cfg_TimerCounter_t *cfg);
void STM_Cfg_PWM(STM_Cfg_PWM_t *cfg);
#define STM_Enable()           { _stpau = 0;  _ston = 1;}
#define STM_Disable()          { _ston = 0;}
#define STMA_Isr_Enable()      { _stmaf = 0; _stmae =1; _mf1e = 1;}
#define STMA_Isr_Disable()     { _stmae = 0;}
#define STMP_Isr_Enable()      { _stmpf = 0; _stmpe =1; _mf1e = 1;}
#define STMP_Isr_Disable()     { _stmpe = 0;}

// clang-format on
#endif