/**
 * *************************************************************************************************************
 * @file Uart.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Uart firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.2
 * * USIM中 UART/I2C/SPI只能同时有一个工作
 * * Uart 初始化配置函數
 * * Uart 使能和除能
 * * Uart 發送16進制buf (使用中断的方式)
 * * Uart 發送char 字符串 (使用中断的方式)
 * * Uart 接收 (使用中断的方式)
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#include "Uart.h"
#include "..\board\BoardCfg.h"
#ifdef SUPPORT_ISP
    #include "..\application\Iap_Isp.h"
#endif

#ifndef FH_CLOCK_FREQ
    #define FH_CLOCK_FREQ 8000000    //!< 設置系統頻率，目前支援設置為4000000,8000000,12000000
#endif
#ifndef UART0_BAUD_RATE
    #define UART0_BAUD_RATE 9600    //!< 300(Only 4M),1200,2400,4800,9600,19200,38400(Only 8M),57600(Only 12M),250000
#endif
#ifndef UART1_BAUD_RATE
    #define UART1_BAUD_RATE 9600    //!< 300(Only 4M),1200,2400,4800,9600,19200,38400(Only 8M),57600(Only 12M),250000
#endif

// clang-format off
#define SET_UARTn_TX_INTERRUPT_DISABLE(n)   { _u##n##tiie = 0; _u##n##teie = 0;}
#define SET_UARTn_TX_INTERRUPT_ENABLE(n)    { _u##n##tiie = 1; _u##n##teie = 1;}
#define SET_UARTn_Format_D8_NONE_S1(n)      { _u##n##ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_EVEN_S1(n)      { _u##n##ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_ODD_S1(n)       { _u##n##ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D9_NONE_S1(n)      { _u##n##ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_EVEN_S1(n)      { _u##n##ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_ODD_S1(n)       { _u##n##ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)1bit-Stop
#define SET_UARTn_Format_D8_NONE_S2(n)      { _u##n##ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_EVEN_S2(n)      { _u##n##ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_ODD_S2(n)       { _u##n##ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D9_NONE_S2(n)      { _u##n##ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_EVEN_S2(n)      { _u##n##ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_ODD_S2(n)       { _u##n##ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)2bit-Stop

#if FH_CLOCK_FREQ == 4000000
    #define SET_UARTn_BAUDRATE_300(n)       { _u##n##brgh = 0; _u##n##brg = 207;}
    #define SET_UARTn_BAUDRATE_1200(n)      { _u##n##brgh = 1; _u##n##brg = 207;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _u##n##brgh = 1; _u##n##brg = 103;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _u##n##brgh = 1; _u##n##brg =  51;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _u##n##brgh = 1; _u##n##brg =  25;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _u##n##brgh = 1; _u##n##brg =  12;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _u##n##brgh = 1; _u##n##brg =   0;}
#endif
#if FH_CLOCK_FREQ == 8000000
    #define SET_UARTn_BAUDRATE_1200(n)      { _u##n##brgh = 0; _u##n##brg = 103;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _u##n##brgh = 1; _u##n##brg = 207;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _u##n##brgh = 1; _u##n##brg = 103;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _u##n##brgh = 1; _u##n##brg =  51;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _u##n##brgh = 1; _u##n##brg =  25;}
    #define SET_UARTn_BAUDRATE_38400(n)     { _u##n##brgh = 1; _u##n##brg =  12;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _u##n##brgh = 1; _u##n##brg =   1;}
#endif
#if FH_CLOCK_FREQ == 12000000
    #define SET_UARTn_BAUDRATE_1200(n)      { _u##n##brgh = 0; _u##n##brg = 155;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _u##n##brgh = 0; _u##n##brg =  77;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _u##n##brgh = 1; _u##n##brg = 155;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _u##n##brgh = 1; _u##n##brg =  77;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _u##n##brgh = 1; _u##n##brg =  38;}
    #define SET_UARTn_BAUDRATE_57600(n)     { _u##n##brgh = 1; _u##n##brg =  12;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _u##n##brgh = 1; _u##n##brg =   2;}
#endif
// clang-format on

volatile Uart_Status_t uart0Status;
volatile uint8_t *queue_in0;
volatile uint8_t *queue_out0;

/**
 * @brief configuration uart
 *
 * @param cfg_t
 */
void Uart0_Cfg(const Uart_Cfg_t *cfg_t)
{
#if defined(PIN_TX0_PC0)
    PIN_PC0_TX0();
#endif
#if defined(PIN_TX0_PC6)
    PIN_PC6_TX0();
#endif
#if defined(PIN_RX0_PC0)
    PIN_PC0_RX0();
#endif

    _u0md = 1;
    SET_UARTn_Format_D8_NONE_S1(0);    // 數據傳輸格式設定
    // 波特率設定
#if UART0_BAUD_RATE == 300 && FH_CLOCK_FREQ == 4000000
    SET_UARTn_BAUDRATE_300(0);
#elif UART0_BAUD_RATE == 1200
    SET_UARTn_BAUDRATE_1200(0);
#elif UART0_BAUD_RATE == 2400
    SET_UARTn_BAUDRATE_2400(0);
#elif UART0_BAUD_RATE == 4800
    SET_UARTn_BAUDRATE_4800(0);
#elif UART0_BAUD_RATE == 9600
    SET_UARTn_BAUDRATE_9600(0);
#elif UART0_BAUD_RATE == 19200
    SET_UARTn_BAUDRATE_19200(0);
#elif UART0_BAUD_RATE == 38400 && FH_CLOCK_FREQ == 8000000
    SET_UARTn_BAUDRATE_38400(0);
#elif UART0_BAUD_RATE == 57600 && FH_CLOCK_FREQ == 12000000
    SET_UARTn_BAUDRATE_57600(0);
#elif UART0_BAUD_RATE == 250000
    SET_UARTn_BAUDRATE_250000(0);
#else
    #error "Please set the correct UART_BAUD_RATE and FH_CLOCK_FREQ"
#endif

    _u0adden = cfg_t->flag.b.addr;
    _u0wake  = cfg_t->flag.b.wakeUp;
    _u0rie   = 1;    // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
    // _u0tiie   = 1;    // TIDLE(無數據傳輸)置位，可置中斷標誌位
    // _u0teie   = 1;    // TXIF(數據已加載到移位暫存器，TXR為空)置位時，可置中斷標誌位
    uart0Status.txLen              = 0;
    uart0Status.txOffset           = 0;
    queue_in0                      = (uint8_t *)uart0Status.rxBuf;
    queue_out0                     = (uint8_t *)uart0Status.rxBuf;
    uart0Status.flag.b.queueIsFull = false;
}

/**
 * @brief 發送16進制 buf
 *
 * @param buf 發送的buf
 * @param len 發送的長度
 * @note 使用的是中斷發送，若 uart0Status.txLen = 0則說明數據已經發送完成
 * @return true 發送成功
 * @return false 發送失敗，上一筆數據還未發送完成
 */
bool Uart0_TxByte_Interrupt(volatile uint8_t *buf, uint8_t len)
{
    if (uart0Status.txLen > 0)
    {
        return false;
    }
    else
    {
        // clang-format off
        uart0Status.txLen    = len - 1;
        uart0Status.txOffset = buf;
        _acc = _u0usr;
        _u0txr_rxr = *uart0Status.txOffset;
        uart0Status.flag.b.isBusy = true;
        SET_UARTn_TX_INTERRUPT_ENABLE(0);
        // clang-format on
        return true;
    }
}

/**
 * @brief 發送16進制 buf
 *
 * @param byte 發送的byte
 * @param len  byte len
 * @return true 發送成功
 * @return false 發送失敗
 */
void Uart0_TxByte_Polling(uint8_t *byte, uint8_t len)
{
    SET_UARTn_TX_INTERRUPT_DISABLE(0);
    uint8_t i;
    for (i = 0; i < len; i++)
    {
        // clang-format off
        _acc      = _u0usr;
        _u0txr_rxr = *byte;
        while (!_u0tidle)
            ;
        byte++;
        // clang-format on
    }
}

/**
 * @brief 讀取uart緩存數據
 * @param *byte 串口缓存中第一个可读字节，当没有可读数据时返回0，整数类型。
 * @return true 有可读字节
 * @return false 無可读字节
 */
bool Uart0_IsAvailable_ReadByte(uint8_t *byte)
{
    if ((queue_in0 != queue_out0) || uart0Status.flag.b.queueIsFull)
    {
        if (queue_out0 >= (uint8_t *)(uart0Status.rxBuf + uart0Status.rxBufLen))
        {
            queue_out0 = (uint8_t *)(uart0Status.rxBuf);
        }
        *byte = *queue_out0++;

        uart0Status.flag.b.queueIsFull = false;
        return true;
    }
    else
    {
        return false;
    }
}

#ifdef SUPPORT_ISP
// clang-format off
__attribute__((interrupt(0x2C), reg_acc(0x8A), isr_at(0x2C + PROM_AP_ADDRESS_START)))
void UART0_ISR_Routine()
// clang-format on
#else
DEFINE_ISR(UART0_ISR, 0x2C)
#endif
{
    // 噪声干扰错误 | 帧错误 | 溢出错误
    if (_u0nf | _u0ferr | _u0oerr)
    {
        _acc = _u0usr;
        _acc = _u0txr_rxr;
    }
    // 发送数据
    if (_u0txif)
    {
        if (uart0Status.txLen > 0)
        {
            uart0Status.txOffset++;
            _u0txr_rxr = *uart0Status.txOffset;
            uart0Status.txLen--;
        }
        else
        {
            if (_u0tidle)
            {
                uart0Status.flag.b.isBusy = false;
            }
        }
    }
    // 接收数据
    if (_u0rxif)
    {
        if ((queue_in0 > queue_out0) && ((queue_in0 - queue_out0) >= uart0Status.rxBufLen))
        {
            // Queue is full: in is first byte and out is last byte
        }
        else if (uart0Status.flag.b.queueIsFull)
        {
            // Queue is full: in++ == out
        }
        else
        {
            // Queue is not full
            if (queue_in0 >= (uint8_t *)(uart0Status.rxBuf + uart0Status.rxBufLen))
            {
                queue_in0 = (uint8_t *)(uart0Status.rxBuf);
            }
            *queue_in0++ = _u0txr_rxr;
            if (queue_in0 == queue_out0)
            {
                uart0Status.flag.b.queueIsFull = true;    // Queue is full: in++ == out
            }
        }
    }
}

volatile Uart_Status_t uart1Status;
volatile uint8_t *queue_in1;
volatile uint8_t *queue_out1;

/**
 * @brief configuration uart
 *
 * @param cfg_t
 */
void Uart1_Cfg(const Uart_Cfg_t *cfg_t)
{
#if defined(PIN_TX1_PC1)
    PIN_PC1_TX1();
#endif
#if defined(PIN_TX1_PC2)
    PIN_PC2_TX1();
#endif
#if defined(PIN_RX1_PC1)
    PIN_PC1_RX1();
#endif

    _u1md = 1;
    SET_UARTn_Format_D8_NONE_S1(1);    // 數據傳輸格式設定
    // 波特率設定
#if UART1_BAUD_RATE == 300 && FH_CLOCK_FREQ == 4000000
    SET_UARTn_BAUDRATE_300(1);
#elif UART1_BAUD_RATE == 1200
    SET_UARTn_BAUDRATE_1200(1);
#elif UART1_BAUD_RATE == 2400
    SET_UARTn_BAUDRATE_2400(1);
#elif UART1_BAUD_RATE == 4800
    SET_UARTn_BAUDRATE_4800(1);
#elif UART1_BAUD_RATE == 9600
    SET_UARTn_BAUDRATE_9600(1);
#elif UART1_BAUD_RATE == 19200
    SET_UARTn_BAUDRATE_19200(1);
#elif UART1_BAUD_RATE == 38400 && FH_CLOCK_FREQ == 8000000
    SET_UARTn_BAUDRATE_38400(1);
#elif UART1_BAUD_RATE == 57600 && FH_CLOCK_FREQ == 12000000
    SET_UARTn_BAUDRATE_57600(1);
#elif UART1_BAUD_RATE == 250000
    SET_UARTn_BAUDRATE_250000(1);
#else
    #error "Please set the correct UART_BAUD_RATE and FH_CLOCK_FREQ"
#endif

    _u1adden = cfg_t->flag.b.addr;
    _u1wake  = cfg_t->flag.b.wakeUp;
    _u1rie   = 1;    // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
    // _u1tiie   = 1;    // TIDLE(無數據傳輸)置位，可置中斷標誌位
    // _u1teie   = 1;    // TXIF(數據已加載到移位暫存器，TXR為空)置位時，可置中斷標誌位
    uart1Status.txLen              = 0;
    uart1Status.txOffset           = 0;
    queue_in1                      = (uint8_t *)uart1Status.rxBuf;
    queue_out1                     = (uint8_t *)uart1Status.rxBuf;
    uart1Status.flag.b.queueIsFull = false;
}

/**
 * @brief 發送16進制 buf
 *
 * @param buf 發送的buf
 * @param len 發送的長度
 * @note 使用的是中斷發送，若 uart1Status.txLen = 0則說明數據已經發送完成
 * @return true 發送成功
 * @return false 發送失敗，上一筆數據還未發送完成
 */
bool Uart1_TxByte_Interrupt(volatile uint8_t *buf, uint8_t len)
{
    if (uart1Status.txLen > 0)
    {
        return false;
    }
    else
    {
        // clang-format off
        uart1Status.txLen    = len - 1;
        uart1Status.txOffset = buf;
        _acc = _u1usr;
        _u1txr_rxr = *uart1Status.txOffset;
        uart1Status.flag.b.isBusy = true;
        SET_UARTn_TX_INTERRUPT_ENABLE(1);
        // clang-format on
        return true;
    }
}

/**
 * @brief 發送16進制 buf
 *
 * @param byte 發送的byte
 * @param len  byte len
 * @return true 發送成功
 * @return false 發送失敗
 */
void Uart1_TxByte_Polling(uint8_t *byte, uint8_t len)
{
    SET_UARTn_TX_INTERRUPT_DISABLE(1);
    uint8_t i;
    for (i = 0; i < len; i++)
    {
        // clang-format off
        _acc      = _u1usr;
        _u1txr_rxr = *byte;
        while (!_u1tidle)
            ;
        byte++;
        // clang-format on
    }
}

/**
 * @brief 讀取uart緩存數據
 * @param *byte 串口缓存中第一个可读字节，当没有可读数据时返回0，整数类型。
 * @return true 有可读字节
 * @return false 無可读字节
 */
bool Uart1_IsAvailable_ReadByte(uint8_t *byte)
{
    if ((queue_in1 != queue_out1) || uart1Status.flag.b.queueIsFull)
    {
        if (queue_out1 >= (uint8_t *)(uart1Status.rxBuf + uart1Status.rxBufLen))
        {
            queue_out1 = (uint8_t *)(uart1Status.rxBuf);
        }
        *byte = *queue_out1++;

        uart1Status.flag.b.queueIsFull = false;
        return true;
    }
    else
    {
        return false;
    }
}

#ifdef SUPPORT_ISP
// clang-format off
__attribute__((interrupt(0x30), reg_acc(0x8B), isr_at(0x30 + PROM_AP_ADDRESS_START)))
void UART1_ISR_Routine()
// clang-format on
#else
DEFINE_ISR(UART1_ISR, 0x30)
#endif
{
    // 噪声干扰错误 | 帧错误 | 溢出错误
    if (_u1nf | _u1ferr | _u1oerr)
    {
        _acc = _u1usr;
        _acc = _u1txr_rxr;
    }
    // 发送数据
    if (_u1txif)
    {
        if (uart1Status.txLen > 0)
        {
            uart1Status.txOffset++;
            _u1txr_rxr = *uart1Status.txOffset;
            uart1Status.txLen--;
        }
        else
        {
            if (_u1tidle)
            {
                uart1Status.flag.b.isBusy = false;
            }
        }
    }
    // 接收数据
    if (_u1rxif)
    {
        if ((queue_in1 > queue_out1) && ((queue_in1 - queue_out1) >= uart1Status.rxBufLen))
        {
            // Queue is full: in is first byte and out is last byte
        }
        else if (uart1Status.flag.b.queueIsFull)
        {
            // Queue is full: in++ == out
        }
        else
        {
            // Queue is not full
            if (queue_in1 >= (uint8_t *)(uart1Status.rxBuf + uart1Status.rxBufLen))
            {
                queue_in1 = (uint8_t *)(uart1Status.rxBuf);
            }
            *queue_in1++ = _u1txr_rxr;
            if (queue_in1 == queue_out1)
            {
                uart1Status.flag.b.queueIsFull = true;    // Queue is full: in++ == out
            }
        }
    }
}


/**
 * @brief 将数据转换为字符串
 *
 * @param value 待转换的数据
 * @param str 字符串地址
 * @param size 转换后的字符串长度(含符号位)，若长度不高则高位被丢弃
 */
void IntegerToString(int32_t value, uint8_t *str, uint8_t size)
{
    if (value < 0)
    {
        value = -value;
        str[0] = '-';
    }
    else
    {
    	str[0] = ' ';
    }
    volatile bit isNotFirst;
    isNotFirst = false;
    size--;
    do
    {
        str[size] = '0' + value % 10;
        if (isNotFirst && value == 0)
        {
            str[size] = ' ';
        }
        value /= 10;
        size--;
        isNotFirst = true;
    } while (size > 0);
}