/**
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include <stdint.h>
#include "..\..\..\driver\wdt.h"
#include "..\..\..\driver\Oscillators.h"
#include "..\..\..\driver\AfePower.h"
#include "..\..\..\driver\Adc12.h"
#include "..\..\..\driver\Gpio.h"

volatile uint16_t adcData;
volatile uint16_t vddMv;

void main()
{
    // 判斷是否為上電復位或者非正常情況下的復位, 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
    if (_to == 0 || _pdf == 0)
    {
        // config sys clock
        Oscillators_Cfg();
        // config AfePower
        Dac_vref_Cfg(DAC_REF_VIREF);
        Viref_Enable();
        // config Adc
        Adc12_Cfg_t Cfg;
        Cfg.channel   = ADC12_CH_VDD4;
        Cfg.reference = ADC12_REF_DACVREF;
        Adc12_Cfg(&Cfg);
        // enable emi
        _emi = 1;
        GCC_DELAY(10000);
    }
    else
    {
        // WDT溢出復位初始化
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
        adcData = Adc12_Sampling(10);
        // 1. How to calculate the input voltage of an ADC
        // LSB = VREF/2^K (K=adc bits) = VREF/2^12
        // InputVoltage = ( Adc × LSB)
        // VREF = dacvref
        // InputVoltage = Adc × 2000/2^12

        // 2. How to get the voltage of Vdd
        // InputVoltage  = VDD/4
        // VDD = InputVoltage*4= Adc × 2000 /2^12 * 4 = Adc x 2000 / 2^12 * 4;
        vddMv = (uint32_t)adcData * 2000 * 4 / 4096;
        Adc12_Disable();
        GCC_HALT();
    }
}