/**
 * *************************************************************************************************************
 * @file ATM.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for ATM firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "ATM.h"
#include "..\board\BoardCfg.h"

/*! timer work mode selection enum */
typedef enum {
    TIMER_COMPARE_MATCH_OUTPUT    = (0x00 << 6),
    TIMER_PWM_SINGLE_PULSE_OUTPUT = (0x02 << 6),
    TIMER_TIMER_COUNTER           = (0x03 << 6),
} TimerModeCfg_t;

// clang-format off
// Timer
#define SET_TMn_CLOCK(n, type)          { _atmc0 &= 0x8F; _atmc0 |= type;}
#define SET_TMn_MODE(n, type)           { _atmc1 &= 0x3F; _atmc1 |= type;}
#define SET_TMn_CCRA(n,x)               { _atmal = x%256; _atmah = x/256;}
#define SET_TMn_CCRP(n,x)               { _atmrp = x;}
#define SET_TMn_OUTPUT_INVERT(n,type)   {_atpol = type;}
#define SET_TMn_COUNT_CLEAR(n,type)     {_atcclr = type;}
#define SET_TMn_OUTPUT_MODE(n,type)     {_atmc1 &= 0xC7; _atmc1 |= type;}

#define SET_PWM_DUTY_PERIOD(n,type)     {_atdpx = type;}   // pwm mode

// clang-format on

/**
 * @brief ATM compare match configuration
 *
 * @param Cfg @see ATM_Cfg_CompareMatchOutputMode_t
 */
void ATM_Cfg_CompareMatchOutput(ATM_Cfg_CompareMatchOutputMode_t *cfg)
{
#if defined(PIN_ATCK_PC5)
    PIN_PC5_ATCK();
#endif
#if defined(PIN_ATP_PA5)
    PIN_PA5_ATP();
#endif
#if defined(PIN_ATP_PD4)
    PIN_PD4_ATP();
#endif
#if defined(PIN_ATPB_PA4)
    PIN_PA4_ATPB();
#endif
#if defined(PIN_ATPB_PD5)
    PIN_PD5_ATPB();
#endif
    SET_TMn_MODE(0, TIMER_COMPARE_MATCH_OUTPUT);
    SET_TMn_CLOCK(0, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(0, cfg->outputMode);
    SET_TMn_COUNT_CLEAR(0, cfg->countClear);
    SET_TMn_OUTPUT_INVERT(0, cfg->pinInvert);
    if (cfg->countClear == ATM_COUNT_CLEAR_A_MATCH)
    {
        SET_TMn_CCRA(0, cfg->count);
    }
    else
    {
        SET_TMn_CCRP(0, cfg->count);
    }
}

/**
 * @brief ATM pwm configuration
 *
 * @param Cfg @see ATM_Cfg_PWM_t
 */
void ATM_Cfg_PWM(ATM_Cfg_PWM_t *cfg)
{
#if defined(PIN_ATCK_PC5)
    PIN_PC5_ATCK();
#endif
#if defined(PIN_ATP_PA5)
    PIN_PA5_ATP();
#endif
#if defined(PIN_ATP_PD4)
    PIN_PD4_ATP();
#endif
#if defined(PIN_ATPB_PA4)
    PIN_PA4_ATPB();
#endif
#if defined(PIN_ATPB_PD5)
    PIN_PD5_ATPB();
#endif
    SET_TMn_MODE(0, TIMER_PWM_SINGLE_PULSE_OUTPUT);
    SET_TMn_CLOCK(0, cfg->clockSource);
    SET_TMn_OUTPUT_MODE(0, cfg->outputMode);
    SET_TMn_OUTPUT_INVERT(0, cfg->pinInvert);
    SET_PWM_DUTY_PERIOD(0, cfg->dutyPeriod);
    SET_TMn_CCRA(0, cfg->ccraData);
    SET_TMn_CCRP(0, cfg->ccrpData);
}

/**
 * @brief ATM timer configuration
 *
 * @param Cfg @see ATM_Cfg_TimerCounter_t
 */
void ATM_Cfg_TimerCounter(ATM_Cfg_TimerCounter_t *cfg)
{
#if defined(PIN_ATCK_PC5)
    PIN_PC5_ATCK();
#endif
    SET_TMn_COUNT_CLEAR(0, cfg->countClear);
    SET_TMn_MODE(0, TIMER_TIMER_COUNTER);
    SET_TMn_CLOCK(0, cfg->clockSource);
    if (cfg->countClear == ATM_COUNT_CLEAR_A_MATCH)
    {
        SET_TMn_CCRA(0, cfg->count);
    }
    else
    {
        SET_TMn_CCRP(0, cfg->count);
    }
}
