/**
 * *************************************************************************************************************
 * @file Gpio.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Gpio firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _GPIO_H_
#define _GPIO_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BH67F2472.h"

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
#define PIN_ModeOutput(p, n)        { _##p##c##n = 0;}
#define PIN_ModeInput(p, n)         { _##p##c##n = 1;}
#define PIN_OutputHigh(p, n)        { _##p####n = 1;}
#define PIN_OutputLow(p, n)         { _##p####n = 0;}
#define PIN_OutputInvert(p, n)      { _##p####n = ~_##p####n;}
#define PIN_PullHigh_Enable(p, n)   { _##p##pu##n = 1;}
#define PIN_PullHigh_Disable(p, n)  { _##p##pu##n = 0;}
#define PIN_WakeUp_Enable(p, n)     { _##p##wu##n = 1;}  //!< only pa port
#define PIN_WakeUp_Disable(p, n)    { _##p##wu##n = 0;}  //!< only pa port
#define PIN_IsHigh(p, n)              _##p####n == 1
#define PIN_IsLow(p, n)               _##p####n == 0
#define PIN_Data(p, n)                _##p####n

// clang-format on
// clang-format off
#define PIN_PA0_GPIO()      {}

#define PIN_PA1_GPIO()      { _pas03 = 0; _pas02 = 0;}
#define PIN_PA1_SCS0()      { _pas03 = 0; _pas02 = 1;}

#define PIN_PA2_GPIO()      {}

#define PIN_PA3_GPIO()      { _pas07 = 0; _pas06 = 0;}
#define PIN_PA3_SCK0()      { _pas07 = 0; _pas06 = 1;}
#define PIN_PA3_SCL0()      { _pas07 = 0; _pas06 = 1;}

#define PIN_PA4_GPIO()      { _pas11 = 0; _pas10 = 0;}
#define PIN_PA4_ATPB()      { _pas11 = 1; _pas10 = 1;}
#define PIN_PA4_ATP_PWM2()  { _pas11 = 1; _pas10 = 1;}

#define PIN_PA5_GPIO()      { _pas13 = 0; _pas12 = 0;}
#define PIN_PA5_ATP()       { _pas13 = 1; _pas12 = 1;}
#define PIN_PA5_ATP_PWM1()  { _pas13 = 1; _pas12 = 1;}

#define PIN_PA6_GPIO()      { _pas15 = 0; _pas14 = 0;}
#define PIN_PA6_INT0()      { _pas15 = 0; _pas14 = 0;}
#define PIN_PA6_VG()        { _pas15 = 0; _pas14 = 1;}

#define PIN_PA7_GPIO()      { _pas17 = 0; _pas16 = 0;}
#define PIN_PA7_INT1()      { _pas17 = 0; _pas16 = 0;}
#define PIN_PA7_OP2N()      { _pas17 = 0; _pas16 = 1;}

#define PIN_PB0_GPIO()      { _pbs01 = 0; _pbs00 = 0;}
#define PIN_PB0_OP2O()      { _pbs01 = 1; _pbs00 = 1;}

#define PIN_PB1_GPIO()      { _pbs03 = 0; _pbs02 = 0;}
#define PIN_PB1_OP1N()      { _pbs03 = 1; _pbs02 = 1;}

#define PIN_PB2_GPIO()      { _pbs05 = 0; _pbs04 = 0;}
#define PIN_PB2_AN0()       { _pbs05 = 1; _pbs04 = 1;}

#define PIN_PB3_GPIO()      { _pbs07 = 0; _pbs06 = 0;}
#define PIN_PB3_AN1()       { _pbs07 = 1; _pbs06 = 1;}

#define PIN_PB4_GPIO()      { _pbs11 = 0; _pbs10 = 0;}
#define PIN_PB4_PTP0()      { _pbs11 = 0; _pbs10 = 1;}
#define PIN_PB4_AN2()       { _pbs11 = 1; _pbs10 = 1;}

#define PIN_PB5_GPIO()      { _pbs13 = 0; _pbs12 = 0;}
#define PIN_PB5_PTP0B()     { _pbs13 = 0; _pbs12 = 1;}
#define PIN_PB5_AN3()       { _pbs13 = 1; _pbs12 = 1;}

#define PIN_PB6_GPIO()      { _pbs15 = 0; _pbs14 = 0;}
#define PIN_PB6_VDDIO()     { _pbs15 = 0; _pbs14 = 1;}
#define PIN_PB6_VREF()      { _pbs15 = 1; _pbs14 = 0;}
#define PIN_PB6_AN4()       { _pbs15 = 1; _pbs14 = 1;}

#define PIN_PB7_GPIO()      { _pbs17 = 0; _pbs16 = 0;}
#define PIN_PB7_SCL1()      { _pbs17 = 0; _pbs16 = 1;}
#define PIN_PB7_SCK1()      { _pbs17 = 0; _pbs16 = 1;}
#define PIN_PB7_AN5()       { _pbs17 = 1; _pbs16 = 1;}

#define PIN_PC0_GPIO()      { _pcs01 = 0; _pcs00 = 0;}
#define PIN_PC0_SDI0()      { _pcs01 = 0; _pcs00 = 1;}
#define PIN_PC0_SDA0()      { _pcs01 = 0; _pcs00 = 1;}
#define PIN_PC0_RX0()       { _pcs01 = 0; _pcs00 = 1;}
#define PIN_PC0_TX0()       { _pcs01 = 0; _pcs00 = 1;}

#define PIN_PC1_GPIO()      { _pcs03 = 0; _pcs02 = 0;}
#define PIN_PC1_INT3()      { _pcs03 = 0; _pcs02 = 0;}
#define PIN_PC1_SDI1()      { _pcs03 = 0; _pcs02 = 1;}
#define PIN_PC1_SDA1()      { _pcs03 = 0; _pcs02 = 1;}
#define PIN_PC1_RX1()       { _pcs03 = 0; _pcs02 = 1;}
#define PIN_PC1_TX1()       { _pcs03 = 0; _pcs02 = 1;}

#define PIN_PC2_GPIO()      { _pcs05 = 0; _pcs04 = 0;}
#define PIN_PC2_INT2()      { _pcs05 = 0; _pcs04 = 0;}
#define PIN_PC2_SDO1()      { _pcs05 = 0; _pcs04 = 1;}
#define PIN_PC2_TX1()       { _pcs05 = 0; _pcs04 = 1;}

#define PIN_PC3_GPIO()      { _pcs07 = 0; _pcs06 = 0;}
#define PIN_PC3_XT1()       { _pcs07 = 0; _pcs06 = 1;}

#define PIN_PC4_GPIO()      { _pcs11 = 0; _pcs10 = 0;}
#define PIN_PC4_XT2()       { _pcs11 = 0; _pcs10 = 1;}

#define PIN_PC5_GPIO()      { _pcs13 = 0; _pcs12 = 0;}
#define PIN_PC5_ATCK()      { _pcs13 = 0; _pcs12 = 0;}
#define PIN_PC5_SCS1()      { _pcs13 = 0; _pcs12 = 1;}

#define PIN_PC6_GPIO()      { _pcs15 = 0; _pcs14 = 0;}
#define PIN_PC6_SDO0()      { _pcs15 = 0; _pcs14 = 1;}
#define PIN_PC6_TX0()       { _pcs15 = 0; _pcs14 = 1;}

#define PIN_PD0_GPIO()      { _pds01 = 0; _pds00 = 0;}
#define PIN_PD0_SCKA()      { _pds01 = 0; _pds00 = 1;}
#define PIN_PD0_PTP0()      { _pds01 = 1; _pds00 = 0;}
#define PIN_PD0_SEG0()      { _pds01 = 1; _pds00 = 1;}

#define PIN_PD1_GPIO()      { _pds03 = 0; _pds02 = 0;}
#define PIN_PD1_SDIA()      { _pds03 = 0; _pds02 = 1;}
#define PIN_PD1_PTP0B()     { _pds03 = 1; _pds02 = 0;}
#define PIN_PD1_SEG1()      { _pds03 = 1; _pds02 = 1;}

#define PIN_PD2_GPIO()      { _pds05 = 0; _pds04 = 0;}
#define PIN_PD2_PTCK0()     { _pds05 = 0; _pds04 = 0;}
#define PIN_PD2_SDOA()      { _pds05 = 1; _pds04 = 0;}
#define PIN_PD2_SEG2()      { _pds05 = 1; _pds04 = 1;}

#define PIN_PD3_GPIO()      { _pds07 = 0; _pds06 = 0;}
#define PIN_PD3_SCSA()      { _pds07 = 1; _pds06 = 0;}
#define PIN_PD3_SEG3()      { _pds07 = 1; _pds06 = 1;}

#define PIN_PD4_GPIO()      { _pds11 = 0; _pds10 = 0;}
#define PIN_PD4_ATP()       { _pds11 = 1; _pds10 = 0;}
#define PIN_PD4_ATP_PWM1()  { _pds11 = 1; _pds10 = 0;}
#define PIN_PD4_SEG4()      { _pds11 = 1; _pds10 = 1;}

#define PIN_PD5_GPIO()      { _pds13 = 0; _pds12 = 0;}
#define PIN_PD5_ATPB()      { _pds13 = 1; _pds12 = 0;}
#define PIN_PD5_ATPB_PWM2() { _pds13 = 1; _pds12 = 0;}
#define PIN_PD5_SEG5()      { _pds13 = 1; _pds12 = 1;}

#define PIN_PD6_GPIO()      { _pds15 = 0; _pds14 = 0;}
#define PIN_PD6_OSC1()      { _pds15 = 0; _pds14 = 1;}
#define PIN_PD6_SEG6()      { _pds15 = 1; _pds14 = 1;}

#define PIN_PD7_GPIO()      { _pds17 = 0; _pds16 = 0;}
#define PIN_PD7_OSC2()      { _pds17 = 0; _pds16 = 1;}
#define PIN_PD7_SEG7()      { _pds17 = 1; _pds16 = 1;}

#define PIN_PE0_GPIO()      { _pes01 = 0; _pes00 = 0;}
#define PIN_PE0_STP()       { _pes01 = 1; _pes00 = 0;}
#define PIN_PE0_SEG8()      { _pes01 = 1; _pes00 = 1;}

#define PIN_PE1_GPIO()      { _pes03 = 0; _pes02 = 0;}
#define PIN_PE1_STPB()      { _pes03 = 1; _pes02 = 0;}
#define PIN_PE1_SEG9()      { _pes03 = 1; _pes02 = 1;}

#define PIN_PE2_GPIO()      { _pes05 = 0; _pes04 = 0;}
#define PIN_PE2_STCK()      { _pes05 = 0; _pes04 = 0;}
#define PIN_PE2_SEG10()     { _pes05 = 1; _pes04 = 1;}

#define PIN_PE3_GPIO()      { _pes07 = 0; _pes06 = 0;}
#define PIN_PE3_PTP1()      { _pes07 = 1; _pes06 = 0;}
#define PIN_PE3_SEG11()     { _pes07 = 1; _pes06 = 1;}

#define PIN_PE4_GPIO()      { _pes11 = 0; _pes10 = 0;}
#define PIN_PE4_PTP1B()     { _pes11 = 1; _pes10 = 0;}
#define PIN_PE4_SEG12()     { _pes11 = 1; _pes10 = 1;}

#define PIN_PE5_GPIO()      { _pes13 = 0; _pes12 = 0;}
#define PIN_PE5_PTCK1()     { _pes13 = 0; _pes12 = 0;}
#define PIN_PE5_SEG13()     { _pes13 = 1; _pes12 = 1;}

#define PIN_PE6_GPIO()      { _pes15 = 0; _pes14 = 0;}
#define PIN_PE6_SEG14()     { _pes15 = 1; _pes14 = 1;}

#define PIN_PE7_GPIO()      { _pes17 = 0; _pes16 = 0;}
#define PIN_PE7_SEG15()     { _pes17 = 1; _pes16 = 1;}

#define PIN_PF0_GPIO()      { _pfs01 = 0; _pfs00 = 0;}
#define PIN_PF0_SEG16()     { _pfs01 = 1; _pfs00 = 1;}

#define PIN_PF1_GPIO()      { _pfs03 = 0; _pfs02 = 0;}
#define PIN_PF1_SEG17()     { _pfs03 = 1; _pfs02 = 1;}

#define PIN_PF2_GPIO()      { _pfs05 = 0; _pfs04 = 0;}
#define PIN_PF2_SEG18()     { _pfs05 = 1; _pfs04 = 1;}

#define PIN_PF3_GPIO()      { _pfs07 = 0; _pfs06 = 0;}
#define PIN_PF3_SEG19()     { _pfs07 = 1; _pfs06 = 1;}

#define PIN_PF4_GPIO()      { _pfs11 = 0; _pfs10 = 0;}
#define PIN_PF4_SEG20()     { _pfs11 = 1; _pfs10 = 1;}

#define PIN_PF5_GPIO()      { _pfs13 = 0; _pfs12 = 0;}
#define PIN_PF5_SEG21()     { _pfs13 = 1; _pfs12 = 1;}

#define PIN_PF6_GPIO()      { _pfs15 = 0; _pfs14 = 0;}
#define PIN_PF6_SEG22()     { _pfs15 = 1; _pfs14 = 1;}

#define PIN_PF7_GPIO()      { _pfs17 = 0; _pfs16 = 0;}
#define PIN_PF7_SEG23()     { _pfs17 = 1; _pfs16 = 1;}

#define PIN_PG0_GPIO()      { _pgs01 = 0; _pgs00 = 0;}
#define PIN_PG0_SEG24()     { _pgs01 = 1; _pgs00 = 1;}

#define PIN_PG1_GPIO()      { _pgs03 = 0; _pgs02 = 0;}
#define PIN_PG1_SEG25()     { _pgs03 = 1; _pgs02 = 1;}

#define PIN_PG2_GPIO()      { _pgs05 = 0; _pgs04 = 0;}
#define PIN_PG2_SEG26()     { _pgs05 = 1; _pgs04 = 1;}

#define PIN_PG3_GPIO()      { _pgs07 = 0; _pgs06 = 0;}
#define PIN_PG3_SEG27()     { _pgs07 = 1; _pgs06 = 1;}

#define PIN_PG4_GPIO()      { _pgs11 = 0; _pgs10 = 0;}
#define PIN_PG4_COM7()      { _pgs11 = 1; _pgs10 = 0;}
#define PIN_PG4_SEG28()     { _pgs11 = 1; _pgs10 = 1;}

#define PIN_PG5_GPIO()      { _pgs13 = 0; _pgs12 = 0;}
#define PIN_PG5_COM6()      { _pgs13 = 1; _pgs12 = 0;}
#define PIN_PG5_SEG29()     { _pgs13 = 1; _pgs12 = 1;}

#define PIN_PH2_GPIO()      { _phs05 = 0; _phs04 = 0;}
#define PIN_PH2_CLO()       { _phs05 = 0; _phs04 = 1;}

#define PIN_PH3_GPIO()      { _phs07 = 0; _phs06 = 0;}
#define PIN_PH3_SEG32()     { _phs07 = 1; _phs06 = 1;}

#define PIN_PH4_GPIO()      { _phs11 = 0; _phs10 = 0;}
#define PIN_PH4_SEG33()     { _phs11 = 1; _phs10 = 1;}

#define PIN_PH5_GPIO()      { _phs13 = 0; _phs12 = 0;}
#define PIN_PH5_SEG34()     { _phs13 = 1; _phs12 = 1;}

#define PIN_PH6_GPIO()      { _phs15 = 0; _phs14 = 0;}
#define PIN_PH6_SEG35()     { _phs15 = 1; _phs14 = 1;}

#define PIN_COM5()          { _coms1 = 1;}
#define PIN_SEG30()         { _coms1 = 0;}
#define PIN_COM4()          { _coms0 = 1;}
#define PIN_SEG31()         { _coms0 = 0;}

#define PIN_PD0_3_POWER_VDD()       { _pmps0 = 0x00;}
#define PIN_PD0_3_POWER_VDDIO()     { _pmps0 = 0x02;}

// clang-format on

#endif