/**
 * *************************************************************************************************************
 * @file Rtc.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Rtc firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Rtc.h"
#include "TimeBase.h"
#include "BH67F2472.h"

#define xMINUTE 60          //!<* Seconds of 1 minute 1分的秒数
#define xHOUR   3600        //!<* Seconds of 1 hour   1小时的秒数
#define xDAY    86400       //!<* Seconds of 1 day    1天的秒数
#define xYEAR   31536000    //!<* Seconds of 1 year   1年的秒数

struct TimeInfor time;
/* 总天数 */
const uint32_t Month1[32] = {
    /*01月*/ xDAY * (0),
    /*02月*/ xDAY *(31),
    /*03月*/ xDAY *(31 + 28),
    /*04月*/ xDAY *(31 + 28 + 31),
    /*05月*/ xDAY *(31 + 28 + 31 + 30),
    /*06月*/ xDAY *(31 + 28 + 31 + 30 + 31),
    /*07月*/ xDAY *(31 + 28 + 31 + 30 + 31 + 30),
    /*08月*/ xDAY *(31 + 28 + 31 + 30 + 31 + 30 + 31),
    /*09月*/ xDAY *(31 + 28 + 31 + 30 + 31 + 30 + 31 + 31),
    /*10月*/ xDAY *(31 + 28 + 31 + 30 + 31 + 30 + 31 + 31 + 30),
    /*11月*/ xDAY *(31 + 28 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31),
    /*12月*/ xDAY *(31 + 28 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30)};

/* 每月的天数 */
const uint8_t Month2[12] = {
    /* 01月 */ 31,
    /* 02月 */ 28,
    /* 03月 */ 31,
    /* 04月 */ 30,
    /* 05月 */ 31,
    /* 06月 */ 30,
    /* 07月 */ 31,
    /* 08月 */ 31,
    /* 09月 */ 30,
    /* 10月 */ 31,
    /* 11月 */ 30,
    /* 12月 */ 31};

/**
 * @brief  Rtc 使能
 * @note need enable emi,use timeBase1
 * @retval None
 */
void Rtc_Enable(void)
{
    TimeBase1_Cfg(TIMEBASE_1000MS);
    TimeBase1_Enable();
    TimeBase1_Isr_Enable();
}

/**
 * @brief  Rtc 使能
 * @note use timeBase1
 * @retval None
 */
void Rtc_Disable(void)
{
    TimeBase1_Disable();
}

/**
 * @brief  Unix时间计时
 * @note
 * @retval None
 */
void Rtc_TimeUnixAddIsr(void)
{
    time.unix++;
}

/**
 * @brief  时间戳转北京时间（以1970年1月1日为起点）
 * @note   2700+ 周期
 * @param  *Time: 时间信息
 * @retval None
 */
void BeiJinTimeToUnix(struct TimeInfor *time)
{
    uint32_t i = 0, j = 0, year = 0, seconds = 0;

    year = time->year - 1970;

    /* N年的秒数 */
    for (i = 0; i < year; i++)
    {
        seconds += xYEAR;
    }

    /* 闰年多1天的秒数 */
    j = (year + 2) >> 2; /* 1968 开始算闰年 故+2 */
    for (i = 0; i < j; i++)
    {
        seconds += xDAY;
    }

    /* 本年月份的秒数 */
    seconds += Month1[time->month - 1];

    /* 本年为闰年且没过闰月，则减去一天 */
    if ((time->month < 3) && (((year + 2) % 4) == 0))
    {
        seconds -= xDAY;
    }

    /* 本天过去的秒数 */
    for (i = 0; i < time->date - 1; i++)
    {
        seconds += xDAY;
    }

    /* 本小时过去的秒数 */
    for (i = 0; i < time->hour; i++)
    {
        seconds += xHOUR;
    }

    /* 本分钟过去的秒数 */
    for (i = 0; i < time->min; i++)
    {
        seconds += xMINUTE;
    }

    /* 本分钟过去的秒数 */
    seconds += time->sec;

    /* 减去北京时间时区 */
    seconds -= 28800; /* 8*60*60 */

    time->unix = seconds;
}

/**
 * @brief  北京时间转时间戳（以1970年1月1日为起点）
 * @note   400+ 周期
 * @param  *Time: 时间信息
 * @retval None
 */
void UnixToBeiJinTime(struct TimeInfor *time)
{
    uint16_t days, leap_y_count;
    uint32_t Unix;

    Unix = time->unix;

    /* 获得秒 */
    time->sec = Unix % 60;

    /* 获得分 */
    Unix /= 60;
    time->min = Unix % 60;

    /* 时区矫正 转为UTC+8 bylzs */
    Unix += 8 * 60;

    /* 获得时 */
    Unix /= 60;
    time->hour = Unix % 24;

    /* 获得总天数 */
    days         = Unix / 24;
    leap_y_count = (days + 365) / 1461; /* 过去了多少个闰年(4年一闰) */
    if (((days + 366) % 1461) == 0)
    {                                      /* 闰年的最后1天 */
        time->year  = 1970 + (days / 366); /* 获得年 */
        time->month = 12;                  /* 调整月 */
        time->date  = 31;
        return;
    }

    days -= leap_y_count;
    time->year = 1970 + (days / 365); /* 获得年 */
    days %= 365;                      /* 今年的第几天 */
    days = 01 + days;                 /* 1日开始 */
    if ((time->year % 4) == 0)
    {
        if (days > 60)
            --days;    //闰年调整
        else
        {
            if (days == 60)
            {
                time->month = 2;
                time->date  = 29;
                return;
            }
        }
    }
    for (time->month = 0; Month2[time->month] < days; time->month++)
    {
        days -= Month2[time->month];
    }
    ++time->month;     /* 调整月 */
    time->date = days; /* 获得日 */
}