/**
 * *************************************************************************************************************
 * @file Spia.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Spia firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Spia.h"
#include "..\board\BoardCfg.h"

/**
 * @brief Spi config
 *
 * @param spiCfg @ref Spi_Cfg_t
 */
void Spia_Cfg(const Spia_Cfg_t *cfg)
{
#if defined(PIN_SCSA_PD3)
    PIN_PD3_SCSA();
#endif
#if defined(PIN_SCKA_PD0)
    PIN_PD0_SCKA();
#endif
#if defined(PIN_SDIA_PD1)
    PIN_PD1_SDIA();
#endif
#if defined(PIN_SDOA_PD2)
    PIN_PD2_SDOA();
#endif

    _spic0 = cfg->mode;
    _spic1 = cfg->csen + cfg->dataShift + cfg->sck_edge;
}

/**
 * @brief Spi 發送接收數據
 *
 * @param txData 發送的數據
 * @return uint8_t 接收的數據
 */
uint8_t Spia_TxRxByte(uint8_t txData)
{
    do
    {
        // clang-format off
        _spiwcol = 0;
        _spid  = txData;
        // clang-format on
    } while (_spiwcol);
    while (!_spitrf)
    {
        ;
    }
    _spitrf = 0;
    return _spid;
}

DEFINE_ISR(SPI_ISR, 0x34)
{
    GCC_NOP();
    GCC_NOP();
    GCC_NOP();
}
