/**
 * *************************************************************************************************************
 * @file Spia.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Spia firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _SPIA_H_
#define _SPIA_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "BH67F2472.h"

/** @defgroup SPI
 * @{
 */

/* Exported types ----------------------------------------------------------------------------------------*/
/**
 * @brief spi operating mode Selection enum
 *
 */
typedef enum {
    SPIA_MASTER_FSYS_4  = (0x00 << 5),    //*!<  master mode: clock is fsys/4
    SPIA_MASTER_FSYS_16 = (0x01 << 5),    //*!<  master mode: clock is fsys/16
    SPIA_MASTER_FSYS_64 = (0x02 << 5),    //*!<  master mode: clock is fsys/64
    SPIA_MASTER_FSUB    = (0x03 << 5),    //*!<  master mode: clock is fsub
    SPIA_SLAVE          = (0x05 << 5),    //*!<  slave mode
} Spia_Mode_e;

/**
 * @brief sck active edge type selection Selection enum
 *
 */
typedef enum {
    SPIA_SCK_HIGH_RISING  = (0x00 << 4),    //*!<  spia sck has high base level with data capture on spia sck rising edge
    SPIA_SCK_HIGH_FALLING = (0x01 << 4),    //*!<  spia sck has high base level with data capture on spia sck falling edge
    SPIA_SCK_LOW_RISING   = (0x02 << 4),    //*!<  spia sck has low base level with data capture on spia sck falling edge
    SPIA_SCK_LOW_FALLING  = (0x03 << 4),    //*!<  spia sck has low base level with data capture on spia sck rising edge
} Spia_SckEdge_e;

/**
 * @brief SPIA data shift order Selection enum
 *
 */
typedef enum {
    SPIA_LSB = (0x00 << 3),    //*!<  spia LSB first
    SPIA_MSB = (0x01 << 3),    //*!<  spia MSB first
} Spia_DataShift_e;

/**
 * @brief SPIA data shift order Selection enum
 *
 */
typedef enum {
    SPIA_CSEN_DISABLE = (0x00 << 2),
    SPIA_CSEN_ENABLE  = (0x01 << 2),
} Spia_Csen_e;

/**
 * @brief Spi cfg structure definition
 *
 */
typedef struct {
    uint8_t mode;         //*!< @ref Spia_Mode_e
    uint8_t sck_edge;     //*!< @ref Spia_SckEdge_e
    uint8_t dataShift;    //*!< @ref Spia_DataShift_e
    uint8_t csen;         //*!< @ref Spia_Csen_e
} Spia_Cfg_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void Spia_Cfg(const Spia_Cfg_t *cfg);
#define Spia_Enable()      { _spien = 1;}
#define Spia_Disable()     { _spien = 0;}
#define Spia_Isr_Enable()  { _spie = 1;}
#define Spia_Isr_Disable() { _spie = 0;}
uint8_t Spia_TxRxByte(uint8_t txData);
#define Spia_IsHaveData    _spitrf == 1

// clang-format on
/**
 * @}
 */

#endif