/**
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include <stdint.h>
#include "..\..\..\driver\stdbool.h"
#include "..\..\..\driver\wdt.h"
#include "..\..\..\driver\Oscillators.h"
#include "..\..\..\driver\Ram.h"
#include "..\..\..\driver\Lcd.h"
#include "..\..\..\driver\GPIO.h"

void ConfigComSegIo();

void main()
{
    // 判断是否为上电复位或者非正常情况下的复位, 如果是上电复位，执行上电复位初始化，反之执行WDT溢出初始化
    if (_to == 0 || _pdf == 0)
    {
        // config sys clock
        Oscillators_Cfg();
        Ram_Clear();
        // config IO
        ConfigComSegIo();
        // config Lcd
        Lcd_CType_Cfg_t lcdCfg;
        lcdCfg.waveform  = LCD_WAVEFORM_TYPE_B;
        lcdCfg.power     = LCD_CTYPE_POWER_VC;
        lcdCfg.pumpClock = LCD_CTYPE_Clock_8KHZ;
        lcdCfg.duty      = LCD_DUTY_4COM;
        LcdCtype_Cfg(&lcdCfg);
        Lcd_Enable();
    }
    else
    {
        // WDT溢出复位初始化
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
        Lcd_AllOn();
        GCC_DELAY(100000);
        Lcd_AllOff();
        GCC_DELAY(100000);
    }
}

void ConfigComSegIo()
{
    // 此处为Demo，设置每个IO口为对应的COM/SEG
    // 实际代码可对整个占存器操作以节省ROM
    PIN_PD0_SEG0();
    PIN_PD1_SEG1();
    PIN_PD2_SEG2();
    PIN_PD3_SEG3();
    PIN_PD4_SEG4();
    PIN_PD5_SEG5();
    PIN_PD6_SEG6();
    PIN_PD7_SEG7();
    PIN_PE0_SEG8();
    PIN_PE1_SEG9();
    PIN_PE2_SEG10();
    PIN_PE3_SEG11();
    PIN_PE4_SEG12();
    PIN_PE5_SEG13();
    PIN_PE6_SEG14();
    PIN_PE7_SEG15();
    PIN_PF0_SEG16();
    PIN_PF1_SEG17();
    PIN_PF2_SEG18();
    PIN_PF3_SEG19();
    PIN_PF4_SEG20();
    PIN_PF5_SEG21();
    PIN_PF6_SEG22();
    PIN_PF7_SEG23();
    PIN_PG0_SEG24();
    PIN_PG1_SEG25();
    PIN_PG2_SEG26();
    PIN_PG3_SEG27();
    PIN_PG4_SEG28();
    PIN_PG5_SEG29();
    PIN_PH3_SEG32();
    PIN_PH4_SEG33();
    PIN_PH5_SEG34();
    PIN_PH6_SEG35();
    PIN_SEG30();
    PIN_SEG31();
}