/**
 * *************************************************************************************************************
 * @file Isp_Iap.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Isp_Iap firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Includes ------------------------------------------------------------------------------------------------*/
#include "Iap_Isp.h"
#include <stdint.h>
#include <BH67F2472.h>
#include "..\driver\stdbool.h"

/* user defined---------------------------------------------------------------------------------------------*/
const uint8_t bootLoader_Ver[] = {'1','0','1'};
// MCU info  Cannot modify
#define PROM_WORD_SIZE       ((uint16_t)1024 * 32)
#define PAGE_WORD_SIZE       64    //!< 超出64word/128byte則固定為128byte (HT8架構限制最大數組為128byte)
#define PACKET_PROM_SIZE     16    //!< one packet Prom data size
#define PACKET_PROM_NUM_SIZE ((uint16_t)1024 * (32 - 1) * 2 / PACKET_PROM_SIZE)
#define PAGE_BREAK           (PAGE_WORD_SIZE * 2 / PACKET_PROM_SIZE)    // 單個page需要收的幀筆數

#define PROM_AP_ADDRESS_IapStart 0x0040    // !< 中断偏移地址不建议修改

#define WORD_LO(w) ((uint8_t)(w & 0xff))
#define WORD_HI(w) ((uint8_t)(w >> 8))

typedef union {
    struct {
        unsigned char byte0;
        unsigned char byte1;
    } byte;

    int s16;
    unsigned int u16;
} __16_type;

typedef enum {
    PACKET_REV_STATE_FOUND_NULL,
    PACKET_REV_STATE_FOUND_CMD,
    PACKET_REV_STATE_FOUND_IAP_ROM_DATA,
} packet_rev_state_type_e;

typedef struct
{
    uint8_t rxBuf[20];
    uint8_t packetRevState;
    uint8_t packetLen;
    uint8_t packetRxLen;
    uint8_t pageBreak;
    uint8_t workMode;
    uint16_t promNum;
    uint16_t pageAddress;
} Iap_Isp_PackData;

static volatile Iap_Isp_PackData iap __attribute__((at(0x180)));
static volatile uint8_t promWriteBuf[PAGE_WORD_SIZE * 2] __attribute__((at(0x280)));
static volatile uint8_t promReadBuf[PAGE_WORD_SIZE * 2] __attribute__((at(0x380)));

/* interrupt offset Please do not modify---------------------------------------------------------------------*/
// clang-format off
// new interrupt Vector address = interrupt Vector address + PROM_AP_ADDRESS_START
__attribute__((interrupt(0x04), reg_acc(0x80), redirect_at(0x04 + PROM_AP_ADDRESS_START))) void ISR_0x04_Routine(){}
__attribute__((interrupt(0x08), reg_acc(0x81), redirect_at(0x08 + PROM_AP_ADDRESS_START))) void ISR_0x08_Routine(){}
__attribute__((interrupt(0x0C), reg_acc(0x82), redirect_at(0x0C + PROM_AP_ADDRESS_START))) void ISR_0x0C_Routine(){}
__attribute__((interrupt(0x10), reg_acc(0x83), redirect_at(0x10 + PROM_AP_ADDRESS_START))) void ISR_0x10_Routine(){}
__attribute__((interrupt(0x14), reg_acc(0x84), redirect_at(0x14 + PROM_AP_ADDRESS_START))) void ISR_0x14_Routine(){}
__attribute__((interrupt(0x18), reg_acc(0x85), redirect_at(0x18 + PROM_AP_ADDRESS_START))) void ISR_0x18_Routine(){}
__attribute__((interrupt(0x1C), reg_acc(0x86), redirect_at(0x1C + PROM_AP_ADDRESS_START))) void ISR_0x1C_Routine(){}
__attribute__((interrupt(0x20), reg_acc(0x87), redirect_at(0x20 + PROM_AP_ADDRESS_START))) void ISR_0x20_Routine(){}
__attribute__((interrupt(0x24), reg_acc(0x88), redirect_at(0x24 + PROM_AP_ADDRESS_START))) void ISR_0x24_Routine(){}
__attribute__((interrupt(0x28), reg_acc(0x89), redirect_at(0x28 + PROM_AP_ADDRESS_START))) void ISR_0x28_Routine(){}
__attribute__((interrupt(0x2C), reg_acc(0x8A), redirect_at(0x2C + PROM_AP_ADDRESS_START))) void ISR_0x2C_Routine(){}
__attribute__((interrupt(0x30), reg_acc(0x8B), redirect_at(0x30 + PROM_AP_ADDRESS_START))) void ISR_0x30_Routine(){}
__attribute__((interrupt(0x34), reg_acc(0x8C), redirect_at(0x34 + PROM_AP_ADDRESS_START))) void ISR_0x34_Routine(){}
__attribute__((interrupt(0x38), reg_acc(0x8D), redirect_at(0x38 + PROM_AP_ADDRESS_START))) void ISR_0x38_Routine(){}
__attribute__((interrupt(0x3C), reg_acc(0x8E), redirect_at(0x3C + PROM_AP_ADDRESS_START))) void ISR_0x3C_Routine(){}

/* Reset defined--------------------------------------------------------------------------------------------*/
#define ResetMcu_IapReg()               { _fc1 = 0x55;}   //!< 软件控制 fc1 暂存器使 MCU 复位, 复位后会置位

/* Uart defined---------------------------------------------------------------------------------------------*/
// clang-format off
#define Uart0_Enable()                      { _ur0en = 1; _u0txen = 1; _u0rxen = 1;}
#define Uart0_Disable()                     { _ur0en = 0;}
#define Uart1_Enable()                      { _ur1en = 1; _u1txen = 1; _u1rxen = 1;}
#define Uart1_Disable()                     { _ur1en = 0;}
#define SET_UARTn_TX_INTERRUPT_DISABLE(n)   { _u##n##tiie = 0; _u##n##teie = 0;}
#define SET_UARTn_TX_INTERRUPT_ENABLE(n)    { _u##n##tiie = 1; _u##n##teie = 1;}
#define SET_UARTn_Format_D8_NONE_S1(n)      { _u##n##ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_EVEN_S1(n)      { _u##n##ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D7_ODD_S1(n)       { _u##n##ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D9_NONE_S1(n)      { _u##n##ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_EVEN_S1(n)      { _u##n##ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UARTn_Format_D8_ODD_S1(n)       { _u##n##ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)1bit-Stop
#define SET_UARTn_Format_D8_NONE_S2(n)      { _u##n##ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_EVEN_S2(n)      { _u##n##ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D7_ODD_S2(n)       { _u##n##ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D9_NONE_S2(n)      { _u##n##ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_EVEN_S2(n)      { _u##n##ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UARTn_Format_D8_ODD_S2(n)       { _u##n##ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)2bit-Stop

#if FH_CLOCK_FREQ == 4000000
    #define SET_UARTn_BAUDRATE_300(n)       { _u##n##brgh = 0; _u##n##brg = 207;}
    #define SET_UARTn_BAUDRATE_1200(n)      { _u##n##brgh = 1; _u##n##brg = 207;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _u##n##brgh = 1; _u##n##brg = 103;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _u##n##brgh = 1; _u##n##brg =  51;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _u##n##brgh = 1; _u##n##brg =  25;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _u##n##brgh = 1; _u##n##brg =  12;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _u##n##brgh = 1; _u##n##brg =   0;}
#endif
#if FH_CLOCK_FREQ == 8000000
    #define SET_UARTn_BAUDRATE_1200(n)      { _u##n##brgh = 0; _u##n##brg = 103;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _u##n##brgh = 1; _u##n##brg = 207;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _u##n##brgh = 1; _u##n##brg = 103;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _u##n##brgh = 1; _u##n##brg =  51;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _u##n##brgh = 1; _u##n##brg =  25;}
    #define SET_UARTn_BAUDRATE_38400(n)     { _u##n##brgh = 1; _u##n##brg =  12;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _u##n##brgh = 1; _u##n##brg =   1;}
#endif
#if FH_CLOCK_FREQ == 12000000
    #define SET_UARTn_BAUDRATE_1200(n)      { _u##n##brgh = 0; _u##n##brg = 155;}
    #define SET_UARTn_BAUDRATE_2400(n)      { _u##n##brgh = 0; _u##n##brg =  77;}
    #define SET_UARTn_BAUDRATE_4800(n)      { _u##n##brgh = 1; _u##n##brg = 155;}
    #define SET_UARTn_BAUDRATE_9600(n)      { _u##n##brgh = 1; _u##n##brg =  77;}
    #define SET_UARTn_BAUDRATE_19200(n)     { _u##n##brgh = 1; _u##n##brg =  38;}
    #define SET_UARTn_BAUDRATE_57600(n)     { _u##n##brgh = 1; _u##n##brg =  12;}
    #define SET_UARTn_BAUDRATE_250000(n)    { _u##n##brgh = 1; _u##n##brg =   2;}
#endif
// clang-format on

/**
 * @brief configuration uart
 *
 * @param Cfg_t
 */
static void Bl_Uart0_Cfg()
{
#if defined(PIN_TX0_PC0)
    PIN_PC0_TX0();
#elif defined(PIN_TX0_PC6)
    PIN_PC6_TX0();
#else
    #error "Please set the correct UART Tx Pin"
#endif
#if defined(PIN_RX0_PC0)
    PIN_PC0_RX0();
#else
    #error "Please set the correct UART Rx Pin"
#endif
    _u0md = 1;
    SET_UARTn_Format_D8_NONE_S1(0);    // 數據傳輸格式設定
    // 波特率設定
#if UART_BAUD_RATE == 300 && FH_CLOCK_FREQ == 4000000
    SET_UARTn_BAUDRATE_300(0);
#elif UART_BAUD_RATE == 1200
    SET_UARTn_BAUDRATE_1200(0);
#elif UART_BAUD_RATE == 2400
    SET_UARTn_BAUDRATE_2400(0);
#elif UART_BAUD_RATE == 4800
    SET_UARTn_BAUDRATE_4800(0);
#elif UART_BAUD_RATE == 9600
    SET_UARTn_BAUDRATE_9600(0);
#elif UART_BAUD_RATE == 19200
    SET_UARTn_BAUDRATE_19200(0);
#elif UART_BAUD_RATE == 38400 && FH_CLOCK_FREQ == 8000000
    SET_UARTn_BAUDRATE_38400(0);
#elif UART_BAUD_RATE == 57600 && FH_CLOCK_FREQ == 12000000
    SET_UARTn_BAUDRATE_57600(0);
#elif UART_BAUD_RATE == 250000
    SET_UARTn_BAUDRATE_250000(0);
#else
    #error "Please set the correct UART_BAUD_RATE and FH_CLOCK_FREQ"
#endif
    _u0rie = 1;    // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
}

/**
 * @brief 發送16進制 buf
 *
 * @param byte 發送的byte
 * @param len  byte len
 */
static void Bl_Uart0_TxByte_Polling(uint8_t *byte, uint8_t len)
{
    // SET_UARTn_TX_INTERRUPT_DISABLE(0);
    uint8_t i;
    for (i = 0; i < len; i++)
    {
        // clang-format off
        _acc = _u0usr;
        _u0txr_rxr = *byte;
        while(!_u0tidle);
        byte++;
        // clang-format on
    }
}

volatile bit checkTimeOut;
volatile bit isTimeOut;

/**
 * @brief 接收1byte數據
 *
 * @return uint8_t 接收1byte數據
 */
static void Bl_Uart0_RxByte_Polling(uint8_t *data)
{
    _acc = _u0usr;
    uint16_t timeOutCount;
    isTimeOut    = 0;
    timeOutCount = 0;
    while (!(_u0usr & 0x04))
    {
        if (checkTimeOut)
        {
            // clang-format off
            GCC_NOP();GCC_NOP();GCC_NOP();GCC_NOP();GCC_NOP();
            GCC_NOP();GCC_NOP();GCC_NOP();GCC_NOP();GCC_NOP();
            GCC_NOP();GCC_NOP();GCC_NOP();
            // clang-format on
            timeOutCount++;
            //接收超时
            if (timeOutCount > 65000)    // 1000ms
            {
                isTimeOut = 1;
                return;
            }
        }
        // GCC_CLRWDT();
    }
    *data = _u0txr_rxr;
}

/* Oscillator defined---------------------------------------------------------------------------------------*/
static void Bl_Oscillators_Cfg(void)
{
#ifdef _HXT_
    PIN_PD6_OSC1();
    PIN_PD7_OSC2();
    _fhs = 1;
    #if (SYS_CLOCK_FREQ <= 10000000)
    _hxtc = 0x01;    // HXTM = 0, HXT Frequency<=10MHz,HXT Oscillator Enable
    #elif (SYS_CLOCK_FREQ > 10000000)
    _hxtc = 0x05;    // HXTM = 1, HXT Frequency>10MHz,HXT Oscillator Enable
    #else
        #error "Please set the correct SYS_CLOCK_FREQ in boardCfg.h"
    #endif
    while (!_hxtf)
        ;    // Wait HXT Oscillator Stable
#endif
#ifndef _HXT_
    _fhs = 0;
    #if (SYS_CLOCK_FREQ == 4000000)
    _hircc = 0x01;
    #elif (SYS_CLOCK_FREQ == 8000000)
    _hircc = 0x05;
    #elif (SYS_CLOCK_FREQ == 12000000)
    _hircc = 0x09;
    #else
        #error "Please set the correct SYS_CLOCK_FREQ in boardCfg.h"
    #endif
    while (!_hircf)
        ;    // Wait HIRC Oscillator Stable
#endif
}

/* IAP defined--------------------------------------------------------------------------------------------*/
#define PAGE_ERASE_MODE  0x90    // 塊擦除模式
#define READ_FLASH_MODE  0x32    // 讀Flash模式
#define ENABLE_FWEN_MODE 0x68    // 寫功能使能模式
#define WRITE_FLASH_MODE 0x80    // 寫Flash模式

static bool Bl_IAP_EraseWrite_Enable(void)
{
    // bool EMIStatus;
    // EMIStatus = _emi;
    // _emi      = 0;
    // GCC_CLRWDT();
    _fc0  = ENABLE_FWEN_MODE;    // 寫功能使能模式,start a 300us counter
    _fd1l = 0x00;                // 按順序將固定模式數據序列寫入對應的暫存器
    _fd1h = 0x04;
    _fd2l = 0x0D;
    _fd2h = 0x09;
    _fd3l = 0xC3;
    _fd3h = 0x40;
    // _emi  = EMIStatus;
    while (_fwpen)
        ;    // 寫使能成功后此位硬件自動清零
    return _cfwen;
}

static bool Bl_IAP_Erase_Page(uint16_t address)
{
    if (!Bl_IAP_EraseWrite_Enable())
        return false;
    _farl = WORD_LO(address);
    _farh = WORD_HI(address);
    _fc0  = PAGE_ERASE_MODE;
    uint8_t i;
    for (i = 0; i < 64; i++)
    {
        _fd0h = 0x00;    // 標記地址
    }
    _fwt = 1;
    while (_fwt)
    {
        // GCC_CLRWDT();
    }
    // TODO: should use table read check data is 0x00
    _cfwen = 0;
    return true;
}

static void Bl_IAP_Read(uint16_t address)
{
    _emi = 0;
    // GCC_CLRWDT();
    _fc0  = READ_FLASH_MODE;
    _farl = WORD_LO(address);
    _farh = WORD_HI(address);
    uint8_t i;
    for (i = 0; i < PAGE_WORD_SIZE * 2; i++)
    {
        _frd = 1;    // 啟動讀入
        while (_frd)
            ;
        promReadBuf[i++] = _fd0l;
        promReadBuf[i]   = _fd0h;
        _farl++;
    }
    _frden = 0;
    _emi   = 1;
}

static bool Bl_IAP_Write_Page(uint16_t address)
{
    if (!Bl_IAP_EraseWrite_Enable())
        return false;

    _clwb = 1;                   // write Initiate clear write buffer process
    _fc0  = WRITE_FLASH_MODE;    // write mode
    _farl = WORD_LO(address);
    _farh = WORD_HI(address);

    uint8_t i;
    for (i = 0; i < PAGE_WORD_SIZE * 2; i++)
    {
        _fd0l = promWriteBuf[i++];
        _fd0h = promWriteBuf[i];    // L-->H
        // GCC_CLRWDT();
    }

    _fwt = 1;
    while (_fwt)
    {
        // GCC_CLRWDT();
    }
    // TODO table read check data is correct
    _cfwen = 0;
    return true;
}

static uint8_t Bl_GetCheckSum(uint8_t endN)
{
    uint8_t i, checkSum = 0;
    for (i = 0; i < endN; i++)
    {
        checkSum += iap.rxBuf[i];
    }
    return (~checkSum + 1);
}

static bool Bl_Packet_data_unpack(uint8_t data)
{
    if (iap.packetRevState == PACKET_REV_STATE_FOUND_NULL)    // 帧头
    {
        iap.packetLen                = 0;
        iap.packetRxLen              = 0;
        iap.rxBuf[iap.packetRxLen++] = data;
        if (data == 'B')
        {
            iap.packetRevState++;
        }
        if (data == 'D')
        {
            iap.packetRevState = PACKET_REV_STATE_FOUND_IAP_ROM_DATA;
        }
        return false;
    }
    else if (iap.packetRevState == PACKET_REV_STATE_FOUND_CMD)    // 命令 解析
    {
        iap.rxBuf[iap.packetRxLen++] = data;
        if (iap.packetRxLen == 3)
        {
            iap.packetRevState = PACKET_REV_STATE_FOUND_NULL;
            if (Bl_GetCheckSum(2) == iap.rxBuf[2])
            {
                return true;
            }
        }
    }
    else if (iap.packetRevState == PACKET_REV_STATE_FOUND_IAP_ROM_DATA)    // RomData 解析
    {
        iap.rxBuf[iap.packetRxLen++] = data;
        if (iap.packetRxLen == 20)
        {
            __16_type num;
            num.byte.byte1     = iap.rxBuf[1];
            num.byte.byte0     = iap.rxBuf[2];
            iap.packetRevState = PACKET_REV_STATE_FOUND_NULL;
            if (Bl_GetCheckSum(19) == iap.rxBuf[19] && iap.promNum == num.u16)
            {
                iap.promNum++;
                if (iap.promNum <= PACKET_PROM_NUM_SIZE)    // 加入保护机制，写入地址需在范围内，防止误写BL程序，从而导致宕机
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                // ’R' : prom verify error，上位机重发此 PACKET_PROM_SIZE bytes
                uint8_t txBuf[3] = {'D', 'R', 0x6A};    // 44 52 6A
                Bl_Uart0_TxByte_Polling(txBuf, 3);
                return false;
            }
        }
    }
    return false;
}

__attribute__((at(PROM_AP_ADDRESS_IapStart))) void BootLoader_Start(void)
{
    Bl_IAP_Erase_Page(PROM_AP_ADDRESS_START - PAGE_WORD_SIZE);
    ResetMcu_IapReg();
}

#define ERASE_PROM             0x00    // !< Erase Prom
#define REQUEST_START          0x01    // !< 请求Prom数据
#define UPDATE_PROM            0x02    // !< Program + Verify
#define WRITE_SIGNATURE_REBOOT 0x03    // !< Write Signature+Reboot

// BL 最后一个page 放置 signature
const uint16_t __attribute__((at(PROM_AP_ADDRESS_START - PAGE_WORD_SIZE))) signature[PAGE_WORD_SIZE] = {0xAA55};

void main_AP();

void main()
{
    // page read 不建议使用 若使用LXT 需要500ms LIRC 需要100us
    Bl_IAP_Read(PROM_AP_ADDRESS_START - PAGE_WORD_SIZE);
    if (promReadBuf[0] == 0x55 && promReadBuf[1] == 0xAA)
    {
        asm("call 0x440");    // Jmp to AP  !!!!ADDRESS shout be the same to main_AP
    }
    else
    {
        // Jmp to bootLoader
        _emi  = 0;       // disable all interrupt
        _wdtc = 0xA8;    // disable wdt
        Bl_Oscillators_Cfg();
        Bl_Uart0_Cfg();
        Uart0_Enable();
        uint16_t i;
        // 1. eraseProm
        for (i = PROM_AP_ADDRESS_START; i < PROM_WORD_SIZE; i += PAGE_WORD_SIZE)
        {
            Bl_IAP_Erase_Page(i);
        }
        iap.workMode = REQUEST_START;
        while (1)
        {
            if (iap.workMode == REQUEST_START)    // 2. request prom data command
            {
                uint8_t txBuf[3] = {'B', 'S', 0x6B};    // 42 53 6B
                Bl_Uart0_TxByte_Polling(txBuf, 3);
                iap.packetRevState = PACKET_REV_STATE_FOUND_NULL;
                // wait command ack
                uint8_t rxData = 0;
                iap.rxBuf[1]   = 0;
                do
                {
                    checkTimeOut = 1;
                    Bl_Uart0_RxByte_Polling(&rxData);
                    if (isTimeOut)
                    {
                        break;    // 接收超时，退出重发
                    }
                } while (!Bl_Packet_data_unpack(rxData));
                if (iap.rxBuf[1] == 'S')
                {
                    iap.workMode++;
                    iap.pageBreak = 0;
                    iap.promNum   = 0;
                }
            }
            if (iap.workMode == UPDATE_PROM)    // 3. receive prom data and verify update
            {
                // wait prom data packet
                iap.packetRevState = PACKET_REV_STATE_FOUND_NULL;
                uint8_t rxData;
                do
                {
                    checkTimeOut = 0;
                    Bl_Uart0_RxByte_Polling(&rxData);
                } while (!Bl_Packet_data_unpack(rxData));
                if (iap.rxBuf[0] == 'D')    // Program + Verify
                {
                    // restore prom data and check is receive one page data
                    uint8_t i;
                    for (i = 0; i < PACKET_PROM_SIZE; i++)
                    {
                        promWriteBuf[PACKET_PROM_SIZE * iap.pageBreak + i] = iap.rxBuf[i + 3];
                    }
                    iap.pageBreak++;
                    // receive one page data write prom data
                    bool isWriteOk;
                    isWriteOk = true;
                    if (iap.pageBreak >= PAGE_BREAK)
                    {
                        uint8_t reWriteCnt;
                        iap.pageBreak = 0x00;
                        reWriteCnt    = 0x00;
                        do
                        {
                            iap.pageAddress = PROM_AP_ADDRESS_START + (iap.promNum / PAGE_BREAK - 1) * PAGE_WORD_SIZE;
                            Bl_IAP_Write_Page(iap.pageAddress);
                            // read and check write data is Correct
                            Bl_IAP_Read(iap.pageAddress);
                            isWriteOk = true;
                            for (i = 0; i < (PAGE_WORD_SIZE * 2); i++)
                            {
                                if (promReadBuf[i] != promWriteBuf[i])
                                {
                                    isWriteOk = false;
                                    break;
                                }
                            }
                            if (isWriteOk)
                            {
                                break;
                            }
                            else
                            {
                                reWriteCnt++;
                            }

                        } while (reWriteCnt < 3);
                        if (!isWriteOk)
                        {
                            // 'E' : prom write error，上位机依次重发前8笔的 PACKET_PROM_SIZE bytes
                            iap.promNum -= (PAGE_BREAK - 1);
                            uint8_t txBuf[3] = {'B', 'E', 0x79};    // 42 45 79
                            Bl_Uart0_TxByte_Polling(txBuf, 3);
                        }
                    }
					if(isWriteOk)
					{
						// ‘O': prom verify and write success，上位机继续发后 PACKET_PROM_SIZE bytes
	                    uint8_t txBuf[3] = {'D', 'O', 0x6D};    // 44 4F 6D
	                    Bl_Uart0_TxByte_Polling(txBuf, 3);
					}
                }
                if (iap.rxBuf[0] == 'B' && iap.rxBuf[1] == 'W')    // Write Signature+Reboot
                {
                    iap.workMode++;
                }
            }
            if (iap.workMode == WRITE_SIGNATURE_REBOOT)
            {
                // 4. write signature
                promWriteBuf[0] = 0x55;
                promWriteBuf[1] = 0xAA;
                while (!Bl_IAP_Write_Page((PROM_AP_ADDRESS_START - PAGE_WORD_SIZE)))
                    ;

                // 5. reboot and enter ap
                uint8_t txBuf[3] = {'B', 'W', 0x67};    // 42 57 67
                Bl_Uart0_TxByte_Polling(txBuf, 3);
                ResetMcu_IapReg();
            }
        }
    }
}