/**
 * *************************************************************************************************************
 * @file Adc12.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Adc12 firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _ADC12_H_
#define _ADC12_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "BH67F2472.h"

/* Exported types ----------------------------------------------------------------------------------------*/
/*! Adc reference config */
typedef enum {
    ADC12_REF_VREF    = (0 << 3),
    ADC12_REF_AVDD    = (1 << 3),
    ADC12_REF_DACVREF = (2 << 3)
} Adc12_RefVoltage_e;

/*! Adc channel config */
typedef enum {
    ADC12_CH_AN0 = 0x00,
    ADC12_CH_AN1 = 0x10,
    ADC12_CH_AN2 = 0x20,
    ADC12_CH_AN3 = 0x30,
    ADC12_CH_AN4 = 0x40,
    ADC12_CH_AN5 = 0x50
} Adc12_Chanel_e;

/*! Adc config */
typedef struct
{
    uint8_t reference;    //!< R/W @see Adc12_RefVoltage_e
    uint8_t channel;      //!< R/W @see Adc12_Chanel_e
} Adc12_Cfg_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void Adc12_Cfg(Adc12_Cfg_t *cfg);
uint16_t Adc12_Sampling(uint8_t AvgCnt);
#define Adc12_Isr_Enable()   { _ade = 1;}
#define Adc12_Isr_Disable()  { _ade = 0;}
#define Adc12_Enable()       { _adcen = 1;}
#define Adc12_Disable()      { _adcen = 0;}
// clang-format on

#endif