/**
 * *************************************************************************************************************
 * @file I2c.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for I2c firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.1

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "I2c.h"
#include "..\board\BoardCfg.h"

static volatile uint8_t *regAddress0;
static volatile bit isAddress0;

/**
 * @brief config I2c0
 *
 * @param Cfg @ref I2c_Cfg_t
 * @note I2C time out time is equal to (timeOutPeriod+1)×(32/fsub)
 */
void I2c0_Cfg(const I2c_Cfg_t *Cfg)
{
#if defined(PIN_SDA0_PC0)
    PIN_PC0_SDA0();
#endif
#if defined(PIN_SCL0_PA3)
    PIN_PA3_SCL0();
#endif
    _sim0a  = Cfg->addr;
    _sim0c0 = 0xC0;    // config to I2c mode
    _sim0c0 &= 0xE3;
    _sim0c0 |= Cfg->debounce;
    _iamwu0   = Cfg->flag.b.wakeUp;
    _sim0toc  = Cfg->timeOutMs;
    _sim0toen = Cfg->flag.b.timeOut;
}

// @------------i2c 中斷入口函數---------------@
DEFINE_ISR(I2C0_ISR, 0x2C)
{
    // clang-format off
    if (_sim0tof)
    {
        _sim0tof  = 0;
        _sim0toen = 1;    // reset TimerOut
        _iamwu0   = 1;
    }
    else
    {
        if (_haas0 && _srw0)
        {
            // addres match and IIC tx mode
            _htx0  = 1;
            _sim0d = *regAddress0;
            regAddress0++;
        }
        else if (_haas0 && !_srw0)
        {
            // addres match and IIC rx mode
            _htx0      = 0;        // config SLAVE TO RX
            _txak0     = 0;        // SET ACK signal
            _acc      = _sim0d;    // Dummy read from SIMD to release SCL line
            isAddress0 = false;
        }
        else if (!_haas0 && _htx0)
        {
            // addres not match and IIC tx mode
            if (_rxak0)
            {
                _htx0  = 0;    // rxak=1:主機停止拒絕接收下個字節，發出停止信號
                _txak0 = 0;
                _acc  = _sim0d;    // Dummy read from SIMD to release SCL Line
            }
            else
            {
                _sim0d = *regAddress0;    // 發送數據
                regAddress0++;
            }
        }
        else if (!_haas0 && !_htx0)
        {
            if (!isAddress0)
            {
                isAddress0     = true;
                uint16_t temp = _sim0d;
                regAddress0    = (uint8_t *)temp;    // addres not match and IIC rx mode
            }
            else
            {
                *regAddress0 = _sim0d;    // addres not match and IIC rx mode
                regAddress0++;
            }
        }
    }
    // clang-format on
}

static volatile uint8_t *regAddress1;
static volatile bit isAddress1;

/**
 * @brief config I2c1
 *
 * @param Cfg @ref I2c_Cfg_t
 * @note I2C time out time is equal to (timeOutPeriod+1)×(32/fsub)
 */
void I2c1_Cfg(const I2c_Cfg_t *Cfg)
{
#if defined(PIN_SDA1_PC1)
    PIN_PC1_SDA1();
#endif
#if defined(PIN_SCL1_PB7)
    PIN_PB7_SCL1();
#endif
    _sim1a  = Cfg->addr;
    _sim1c0 = 0xC0;    // config to I2c mode
    _sim1c0 &= 0xE3;
    _sim1c0 |= Cfg->debounce;
    _iamwu1   = Cfg->flag.b.wakeUp;
    _sim1toc  = Cfg->timeOutMs;
    _sim1toen = Cfg->flag.b.timeOut;
}

// @------------i2c 中斷入口函數---------------@
DEFINE_ISR(I2C1_ISR, 0x30)
{
    // clang-format off
    if (_sim1tof)
    {
        _sim1tof  = 0;
        _sim1toen = 1;    // reset TimerOut
        _iamwu1   = 1;
    }
    else
    {
        if (_haas1 && _srw1)
        {
            // addres match and IIC tx mode
            _htx1  = 1;
            _sim1d = *regAddress1;
            regAddress1++;
        }
        else if (_haas1 && !_srw1)
        {
            // addres match and IIC rx mode
            _htx1      = 0;        // config SLAVE TO RX
            _txak1     = 0;        // SET ACK signal
            _acc      = _sim1d;    // Dummy read from SIMD to release SCL line
            isAddress1 = false;
        }
        else if (!_haas1 && _htx1)
        {
            // addres not match and IIC tx mode
            if (_rxak1)
            {
                _htx1  = 0;    // rxak=1:主機停止拒絕接收下個字節，發出停止信號
                _txak1 = 0;
                _acc  = _sim1d;    // Dummy read from SIMD to release SCL Line
            }
            else
            {
                _sim1d = *regAddress1;    // 發送數據
                regAddress1++;
            }
        }
        else if (!_haas1 && !_htx1)
        {
            if (!isAddress1)
            {
                isAddress1     = true;
                uint16_t temp = _sim1d;
                regAddress1    = (uint8_t *)temp;    // addres not match and IIC rx mode
            }
            else
            {
                *regAddress1 = _sim1d;    // addres not match and IIC rx mode
                regAddress1++;
            }
        }
    }
    // clang-format on
}
