/**
 * *************************************************************************************************************
 * @file Lcd.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Lcd firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _LCD_H_
#define _LCD_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH67F2472.h"

/** @defgroup LCD
 * @{
 */

/* Exported types ----------------------------------------------------------------------------------------*/
/*! Lcd Waveform Selection enum */
typedef enum {
    LCD_WAVEFORM_TYPE_A = (0x00 << 7),
    LCD_WAVEFORM_TYPE_B = (0x01 << 7),
} Lcd_WaveForm_e;

/*! Lcd duty Selection enum */
typedef enum {
    LCD_DUTY_4COM = (0x00 << 1),
    LCD_DUTY_6COM = (0x01 << 1),
    LCD_DUTY_8COM = (0x02 << 1),    //!< R type only
} Lcd_Duty_e;

/*! Lcd C type Power Selection enum */
typedef enum {
    LCD_CTYPE_POWER_PLCD_V1_V2 = (0x00 << 4),    //*!< power from: plcd or v1 or v2
    LCD_CTYPE_POWER_VC         = (0x01 << 4),    //*!< power from: Vc
    LCD_CTYPE_POWER_VB         = (0x02 << 4),    //*!< power from: Vb=3V
    LCD_CTYPE_POWER_VDD        = (0x03 << 4),    //*!< power from: Va=VDD
} Lcd_CType_Power_e;

/*! Lcd C type Pump Clock Selection enum */
typedef enum {
    LCD_CTYPE_Clock_250HZ = (0x00 << 5),
    LCD_CTYPE_Clock_500HZ = (0x01 << 5),
    LCD_CTYPE_Clock_1KHZ  = (0x02 << 5),
    LCD_CTYPE_Clock_2KHZ  = (0x03 << 5),
    LCD_CTYPE_Clock_4KHZ  = (0x04 << 5),
    LCD_CTYPE_Clock_8KHZ  = (0x05 << 5),
    LCD_CTYPE_Clock_16KHZ = (0x06 << 5),
} Lcd_Ctype_Clock_e;

/*! Lcd C type cfg structure definition */
typedef struct {
    uint8_t waveform;     //*!< @ref Lcd_WaveForm_e
    uint8_t power;        //*!< @ref Lcd_Ctype_Power_e
    uint8_t pumpClock;    //*!< @ref Lcd_Ctype_Clock_e
    uint8_t duty;         //*!< @ref Lcd_Duty_e
} Lcd_CType_Cfg_t;

/* Exported functions --------------------------------------------------------------------------------------*/
void LcdCtype_Cfg(const Lcd_CType_Cfg_t *lcdCfg);
void Lcd_AllOn();
void Lcd_AllOff();
// clang-format off
#define Lcd_Enable()      { _lcden = 0x01;}
#define Lcd_Disable()     { _lcden = 0x00;}
// clang-format on
/**
 * @}
 */

#endif