/**
 * *************************************************************************************************************
 * @file PTM.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for PTM firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _PTM_H_
#define _PTM_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH67F2472.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! timer Counter Clock selection enum */
typedef enum {
    PTM_CLOCK_FSYS_4   = (0x00 << 4),
    PTM_CLOCK_FSYS     = (0x01 << 4),
    PTM_CLOCK_FH_16    = (0x02 << 4),
    PTM_CLOCK_FH_64    = (0x03 << 4),
    PTM_CLOCK_FSUB     = (0x04 << 4),
    PTM_CLOCK_PIN_RISE = (0x06 << 4),
    PTM_CLOCK_PIN_FALL = (0x07 << 4),
} PTM_Clock_e;

/*! PTM count clear mode enum */
typedef enum {
    PTM_COUNT_CLEAR_P_MATCH,
    PTM_COUNT_CLEAR_A_MATCH,
} PTM_CountClear_e;

/*! compare match output mode enum */
typedef enum {
    PTM_COMPAREMATCH_KEEP_L               = (0x00 << 3),
    PTM_COMPAREMATCH_KEEP_H               = (0x01 << 3),
    PTM_COMPAREMATCH_INIT_H_OUTPUT_L      = (0x03 << 3),
    PTM_COMPAREMATCH_INIT_L_OUTPUT_H      = (0x04 << 3),
    PTM_COMPAREMATCH_INIT_L_OUTPUT_TOGGLE = (0x06 << 3),
    PTM_COMPAREMATCH_INIT_H_OUTPUT_TOGGLE = (0x07 << 3),
} PTM_CompareMatch_Output_e;

/*! compare match output configuration */
typedef struct {
    uint8_t clockSource;    //!< RW @see PTM_Clock_e
    uint8_t outputMode;     //!< RW @see PTM_CompareMatch_Output_e
    uint8_t countClear;     //!< RW @see PTM_CountClear_e
    bool pinInvert;
    uint16_t count;
} PTM_Cfg_CompareMatchOutputMode_t;

/*! pwm output mode enum */
typedef enum {
    PTM_PWM_OUTPUT_KEEP_H       = (0x00 << 3),
    PTM_PWM_OUTPUT_KEEP_L       = (0x01 << 3),
    PTM_PWM_OUTPUT_PWM_ACTIVE_L = (0x04 << 3),
    PTM_PWM_OUTPUT_PWM_ACTIVE_H = (0x05 << 3),
} PTM_PWM_Output_e;

/*! PWM output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see PTM_Clock_e
    uint8_t outputMode;     //!< R/W @see PTM_PWM_Output_e
    bool pinInvert;
    uint16_t ccraData;
    uint16_t ccrpData;
} PTM_Cfg_PWM_t;

/*! Single pulse output enum */
typedef enum {
    PTM_SINGLE_PULSE_OUTPUT_ACTIVE_L = (0x06 << 3),
    PTM_SINGLE_PULSE_OUTPUT_ACTIVE_H = (0x07 << 3),
} PTM_SinglePulseOutput_e;

/*! Single pulse output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see PTM_Clock_e
    uint8_t outputMode;     //!< R/W @see PTM_SinglePulseOutput_e
    bool pinInvert;
    uint16_t ccraData;
} PTM_Cfg_SinglePulseOutput_t;

/*! TimerCount configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see PTM_Clock_e
    uint8_t countClear;     //!< R/W @see PTM_CountClear_e
    uint16_t count;
} PTM_Cfg_TimerCounter_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void PTM0_Cfg_CompareMatchOutput(PTM_Cfg_CompareMatchOutputMode_t *cfg);
void PTM0_Cfg_SinglePulseOutput(PTM_Cfg_SinglePulseOutput_t *cfg);
void PTM0_Cfg_TimerCounter(PTM_Cfg_TimerCounter_t *cfg);
void PTM0_Cfg_PWM(PTM_Cfg_PWM_t *cfg);
#define PTM0_Enable()           { _pt0pau = 0;  _pt0on = 1;}
#define PTM0_Disable()          { _pt0on = 0;}
#define PTM0A_Isr_Enable()      { _ptm0af = 0; _ptm0ae =1; _mf0e = 1;}
#define PTM0A_Isr_Disable()     { _ptm0ae = 0;}
#define PTM0P_Isr_Enable()      { _ptm0pf = 0; _ptm0pe =1; _mf0e  = 1;}
#define PTM0P_Isr_Disable()     { _ptm0pe = 0;}

void PTM1_Cfg_CompareMatchOutput(PTM_Cfg_CompareMatchOutputMode_t *cfg);
void PTM1_Cfg_SinglePulseOutput(PTM_Cfg_SinglePulseOutput_t *cfg);
void PTM1_Cfg_TimerCounter(PTM_Cfg_TimerCounter_t *cfg);
void PTM1_Cfg_PWM(PTM_Cfg_PWM_t *cfg);
#define PTM1_Enable()           { _pt1pau = 0;  _pt1on = 1;}
#define PTM1_Disable()          { _pt1on = 0;}
#define PTM1A_Isr_Enable()      { _ptm1af = 0; _ptm1ae =1; _mf0e = 1;}
#define PTM1A_Isr_Disable()     { _ptm1ae = 0;}
#define PTM1P_Isr_Enable()      { _ptm1pf = 0; _ptm1pe =1; _mf0e  = 1;}
#define PTM1P_Isr_Disable()     { _ptm1pe = 0;}

// clang-format on
#endif