/**
 * *************************************************************************************************************
 * @file Spi.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Spi firmware library
 * MCU / CFG Ver. :BH67F2472/1.5
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Spi.h"
#include "..\board\BoardCfg.h"

/**
 * @brief spi0 config
 *
 * @param Cfg @ref Spi_Cfg_t
 */
void Spi0_Cfg(const Spi_Cfg_t *cfg)
{
#if defined(PIN_SCS0_PA1)
    PIN_PA1_SCS0();
#endif
#if defined(PIN_SCK0_PA3)
    PIN_PA3_SCK0();
#endif
#if defined(PIN_SDI0_PC0)
    PIN_PC0_SDI0();
#endif
#if defined(PIN_SDO0_PC6)
    PIN_PC6_SDO0();
#endif
    _sim0c0 = cfg->mode;
    _sim0c2 = cfg->csen + cfg->dataShift + cfg->sck_edge;
}

/**
 * @brief Spi0 發送接收數據
 *
 * @param txData 發送的數據
 * @return uint8_t 接收的數據
 */
uint8_t Spi0_TxRxByte(uint8_t txData)
{
    do
    {
        _wcol0 = 0x00;
        _sim0d = txData;
    } while (_wcol0);
    while (!_trf0)
    {
        ;
    }
    _trf0 = 0;
    return _sim0d;
}

DEFINE_ISR(SPI0_ISR, 0x2C)
{
    GCC_NOP();
    GCC_NOP();
    GCC_NOP();
}

/**
 * @brief spi1 config
 *
 * @param Cfg @ref Spi_Cfg_t
 */
void Spi1_Cfg(const Spi_Cfg_t *cfg)
{
#if defined(PIN_SCS1_PC5)
    PIN_PC5_SCS1();
#endif
#if defined(PIN_SCK1_PB7)
    PIN_PB7_SCK1();
#endif
#if defined(PIN_SDI1_PC1)
    PIN_PC1_SDI1();
#endif
#if defined(PIN_SDO1_PC2)
    PIN_PC2_SDO1();
#endif
    _sim1c0 = cfg->mode;
    _sim1c2 = cfg->csen + cfg->dataShift + cfg->sck_edge;
}

/**
 * @brief Spi1 發送接收數據
 *
 * @param txData 發送的數據
 * @return uint8_t 接收的數據
 */
uint8_t Spi1_TxRxByte(uint8_t txData)
{
    do
    {
        _wcol1 = 0x00;
        _sim1d = txData;
    } while (_wcol1);
    while (!_trf1)
    {
        ;
    }
    _trf1 = 0;
    return _sim1d;
}

DEFINE_ISR(SPI1_ISR, 0x30)
{
    GCC_NOP();
    GCC_NOP();
    GCC_NOP();
}
