/**
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include <stdint.h>
#include "..\..\..\driver\wdt.h"
#include "..\..\..\driver\Oscillators.h"
#include "..\..\..\driver\AfePower.h"
#include "..\..\..\driver\GPIO.h"
#include "..\..\..\driver\Adc12.h"

// R*100Ω 0.1℃  NTC_NO : MF52A503H3950
#define TABLE_TEMP_START (-10)
#define TABLE_TEMP_LEN   61
const uint16_t NTC_TABLE[TABLE_TEMP_LEN] = {
    2625, 2490, 2364, 2245, 2133, 2027, 1927, 1832, 1743, 1658,    // -10 ~ - 1
    1579, 1503, 1431, 1364, 1299, 1239, 1181, 1126, 1074, 1025,    // 0 ~  9
    980, 934, 892, 852, 814, 778, 744, 711, 680, 650,              // 10 ~ 19
    622, 595, 569, 545, 522, 500, 478, 458, 439, 421,              // 20 ~ 29
    403, 386, 370, 355, 341, 327, 313, 301, 289, 277,              // 30 ~ 39
    266, 255, 245, 236, 226, 217, 209, 201, 193, 185,              // 40 ~ 49
    179};
#define TEMP_LOWER  10001
#define TEMP_HIGHER 10002
#define TEMP_ERROR  20001

volatile uint16_t adcData;
volatile uint16_t Temp;
int16_t TsenTable(uint16_t ntc_r);

void main()
{
    // 判斷是否為上電復位或者非正常情況下的復位, 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
    if (_to == 0 || _pdf == 0)
    {
        // config sys clock
        Oscillators_Cfg();
        PIN_PB3_AN1();
        // config Adc reference
        Dac_vref_Cfg(DAC_REF_VIREF);
        Viref_Enable();
        // config Adc
        Adc12_Cfg_t Cfg;
        Cfg.reference = ADC12_REF_DACVREF;
        Cfg.channel   = ADC12_CH_AN1;
        Adc12_Cfg(&Cfg);
        // enable emi
        _emi = 1;
        GCC_DELAY(10000);
    }
    else
    {
        // WDT溢出復位初始化
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
        adcData = Adc12_Sampling(10);
        // 1. How to calculate the input voltage of an ADC
        // LSB = VREF/2^K (K=adc bits) = VREF/2^12
        // InputVoltage = ( Adc × LSB)
        // VREF = DACVREF
        // InputVoltage = Adc × DACVREF/2^12
        volatile uint16_t NtcMv = (uint32_t)adcData * 2000 / 4096;
        // 2. How to get the NTC R
        // NTC_R / 50K = DACVREF - InputVoltage / InputVoltage
        // NTC_R = 50K * ( DACVREF - InputVoltage) / (InputVoltage)
        volatile uint16_t NTC_R;
        NTC_R = (uint32_t)500 * (2000 - NtcMv) / (NtcMv);
        Temp  = TsenTable(NTC_R);
    }
}

int16_t TsenTable(uint16_t ntc_r)
{
    uint16_t temp;
    if (ntc_r > NTC_TABLE[0])
    {
        return TEMP_LOWER;
    }
    else if (ntc_r < NTC_TABLE[TABLE_TEMP_LEN - 1])
    {
        return TEMP_HIGHER;
    }
    else
    {
        uint8_t i;
        for (i = 0; i < TABLE_TEMP_LEN - 1; i++)
        {
            if (ntc_r <= NTC_TABLE[i] && ntc_r > NTC_TABLE[i + 1])
            {
                temp = 10 * (NTC_TABLE[i] - ntc_r) / (NTC_TABLE[i] - NTC_TABLE[i + 1]);
                temp += 10 * (i + TABLE_TEMP_START);
                return temp;
            }
        }
        return TEMP_ERROR;
    }
}