/**
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "BH67F2472.h"
#include "..\..\..\driver\Oscillators.h"
#include "..\..\..\driver\Uart.h"
#include "..\..\..\driver\Reset.h"
#include "..\..\..\driver\Ram.h"
#include "..\..\..\application\Iap_Isp.h"

volatile uint8_t uartQueueBuf[20];
static bool Packet_data_unpack(uint8_t data);
uint16_t ver;

typedef enum {
    PACKET_REV_STATE_FOUND_NULL,
    PACKET_REV_STATE_FOUND_HEAD,
    PACKET_REV_STATE_FOUND_LEN,
    PACKET_REV_STATE_FOUND_CMD,
} packet_rev_state_type_e;

static uint8_t packetRevState = PACKET_REV_STATE_FOUND_NULL;
static uint8_t packetLen      = 0;
static uint8_t packetRxLen    = 0;
static uint8_t rxBuf[20];    // Serial receive buffer
static uint8_t txBuf[6];     // Serial transmission buffer
static uint8_t GetCheckSum(uint8_t *buf, uint8_t startN, uint8_t endN);

//!< PROM (AP address + Interrupted vectors address)
__attribute__((at(PROM_AP_ADDRESS_START + 64)))
void main_AP()
{
    // 判断是否为上电复位或者非正常情况下的复位, 如果是上电复位，执行上电复位初始化，反之执行WDT溢出初始化
    if (_to == 0 || _pdf == 0)
    {
        // config sys clock
        Oscillators_Cfg();
        Ram_Clear();
        // config uart0
        uart0Status.rxBuf    = uartQueueBuf;            // 傳入緩存Buf地址
        uart0Status.rxBufLen = sizeof(uartQueueBuf);    // 傳入緩存Buf長度
        Uart_Cfg_t uartCfg;
        uartCfg.flag.b.addr   = false;
        uartCfg.flag.b.wakeUp = true;
        Uart0_Cfg(&uartCfg);
        Uart0_Enable();
        Uart0_Isr_Enable();
        // enable emi
        _emi = 1;
        ver  = 0x0001;
    }
    else
    {
        // WDT溢出复位初始化
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
        uint8_t data = 0;
        if (Uart0_IsAvailable_ReadByte(&data))
        {
            if (!Packet_data_unpack(data))
                continue;

            switch (rxBuf[2])
            {
                case 'I':    // 获取版本信息
                    txBuf[0] = 'U';
                    txBuf[1] = 0x06;
                    txBuf[2] = 'I';
                    txBuf[3] = ver;
                    txBuf[4] = ver >> 8;
                    txBuf[5] = GetCheckSum(txBuf, 0, 5);
                    Uart0_TxByte_Polling(txBuf, txBuf[1]);
                    break;
                case 'R':
                    txBuf[0] = 'U';
                    txBuf[1] = 0x04;
                    txBuf[2] = 'R';
                    txBuf[3] = GetCheckSum(txBuf, 0, 3);
                    Uart0_TxByte_Polling(txBuf, txBuf[1]);
                    BootLoader_Start();
                    break;
                default:
                    break;
            }
        }
    }
}

static uint8_t GetCheckSum(uint8_t *buf, uint8_t startN, uint8_t endN)
{
    volatile uint8_t i, checkSum;
    buf += startN;
    checkSum = 0;
    for (i = startN; i < endN; i++)
    {
        checkSum += *buf++;
    }
    checkSum = ~checkSum + 1;
    return checkSum;
}

static bool Packet_data_unpack(uint8_t data)
{
    switch (packetRevState)
    {
        case PACKET_REV_STATE_FOUND_NULL:
            if (data == 'U')
            {
                // memset(rxBuf, 0, sizeof(rxBuf));
                packetLen            = 0;
                packetRxLen          = 0;
                packetRevState       = PACKET_REV_STATE_FOUND_HEAD;    // 帧头
                rxBuf[packetRxLen++] = data;
            }
            break;
        case PACKET_REV_STATE_FOUND_HEAD:
            rxBuf[packetRxLen++] = data;
            packetLen            = data;
            packetRevState       = PACKET_REV_STATE_FOUND_LEN;    // 长度
            break;
        case PACKET_REV_STATE_FOUND_LEN:
            if (data == 'I' || data == 'R')
            {
                rxBuf[packetRxLen++] = data;
                packetRevState       = PACKET_REV_STATE_FOUND_CMD;    // 命令号
            }
            else
            {
                packetRevState = PACKET_REV_STATE_FOUND_NULL;
            }
            break;
        case PACKET_REV_STATE_FOUND_CMD:
            rxBuf[packetRxLen++] = data;
            if (packetRxLen == packetLen)
            {
                packetRevState = PACKET_REV_STATE_FOUND_NULL;
                if (GetCheckSum(rxBuf, 0x00, (packetLen - 1)) == rxBuf[packetLen - 1])
                    return true;
            }
            break;
        default:
            break;
    }
    return false;
}