/**
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include <stdint.h>
#include "..\..\..\driver\wdt.h"
#include "..\..\..\driver\Oscillators.h"
#include "..\..\..\driver\Ram.h"
#include "..\..\..\driver\Uart.h"
#include "..\..\..\driver\Rtc.h"

volatile bit isOneSec;
volatile uint8_t uartQueueBuf[20];    // 中断使用需要加 volatile

//!< Please enable LXT in boardCfg.h to get the accurate time.
void main()
{
    // 判斷是否為上電復位或者非正常情況下的復位, 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
    if (_to == 0 || _pdf == 0)
    {
        // config sys clock
        Oscillators_Cfg();
        //Ram_Clear();
        // config Rtc
        Rtc_Enable();

        time.unix = 1706157040;
        time.year = 2024;
        time.month = 01;
        time.date = 25;
        time.hour = 12;
        time.min = 30;
        time.sec = 40;

        BeiJinTimeToUnix(&time);
        isOneSec = 0;

        // config uart0 for debug info
        uart0Status.rxBuf    = uartQueueBuf;            // 傳入緩存Buf地址
        uart0Status.rxBufLen = sizeof(uartQueueBuf);    // 傳入緩存Buf長度
        Uart_Cfg_t uartCfg;
        uartCfg.flag.b.addr   = false;
        uartCfg.flag.b.wakeUp = true;
        Uart0_Cfg(&uartCfg);
        Uart0_Enable();
        Uart0_Isr_Enable();

        _emi = 1;
    }
    else
    {
        // WDT溢出復位初始化
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
        if (isOneSec)
        {
        	isOneSec = 0;
            UnixToBeiJinTime(&time);

        	uint8_t txCharYear[] = "year=    \r\n";
            IntegerToString(time.year, &txCharYear[4], 4);
        	Uart0_TxByte_Polling(txCharYear, sizeof(txCharYear));

        	uint8_t txCharMonth[] = "month=  \r\n";
            IntegerToString(time.month, &txCharMonth[5], 3);
        	Uart0_TxByte_Polling(txCharMonth, sizeof(txCharMonth));

        	uint8_t txCharDate[] = "date=  \r\n";
            IntegerToString(time.date, &txCharDate[4], 3);
        	Uart0_TxByte_Polling(txCharDate, sizeof(txCharDate));

        	uint8_t txCharHour[] = "hour=  \r\n";
            IntegerToString(time.hour, &txCharHour[4], 3);
        	Uart0_TxByte_Polling(txCharHour, sizeof(txCharHour));

        	uint8_t txCharMin[] = "min=  \r\n";
            IntegerToString(time.min, &txCharMin[3], 3);
        	Uart0_TxByte_Polling(txCharMin, sizeof(txCharMin));

        	uint8_t txCharSec[] = "sec=  \r\n";
            IntegerToString(time.sec, &txCharSec[3], 3);
        	Uart0_TxByte_Polling(txCharSec, sizeof(txCharSec));

        	uint8_t txCharUnix[] = "unix=          \r\n";
            IntegerToString(time.unix, &txCharUnix[4], 11);// 数字的最大位数为10，再加上字符串结束符 '\0'
        	Uart0_TxByte_Polling(txCharUnix, sizeof(txCharUnix));
        }
    }
}

//@----------Timebase1 中斷入口函數-----------@
DEFINE_ISR(Timebase1_ISR, 0x28)
{
	isOneSec = 1;
    Rtc_TimeUnixAddIsr();
}