/*********************************************************************************************************//**
 * @file    BMK52T016_HT32/src/BMK52T016.h
 * @version V1.0.1
 * @date    2024-08-06
 * @brief   The header file of BMK52T016 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BMK52T016_H
#define __BMK52T016_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BMK52T016_SUCCESS,
  BMK52T016_FAILURE
} BMK52T016_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BMK52T016_MASTERADDR     0x70
#define BMK52T016_CLKFREQ        100000

#define   BMK52T016_R_SUCCESS      0
#define   BMK52T016_R_FAIL         1
#define   BMK52T016_REQUESTLEN1        1
#define   BMK52T016_REQUESTLEN16       16
#define   BMK52T016_REQUESTLEN18       18 

/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BMK52T016_selStatus BMK52T016_selWire(uint32_t wire_number);
void BMK52T016_Init(void);

uint8_t BMK52T016_getINT(void);
uint16_t BMK52T016_readKeyValue(void);
void BMK52T016_getThreshold(uint8_t buff[]);
int BMK52T016_setThreshold(uint8_t buff[]);
int BMK52T016_setAllThresholdLevel(uint8_t level);
    
void BMK52T016_writeBytes(uint8_t wbuf[], uint8_t wlen);
void BMK52T016_readBytes(uint8_t rbuf[], uint8_t rlen);
void _BMK52T016_delay(vu32 count);

#ifdef __cplusplus
}
#endif

#endif

