/*********************************************************************************************************//**
 * @file    BM22S4221_1.h_HT32/example_readStatusPin/main.c
 * @version V1.0.1
 * @date    2024-09-23
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/

#include "BM22S4221_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/
#if defined(USE_BM53A367A_DVB)
/* communication interface----------------------------------------------------------------------------------*/
/* BM53A367A_D13--------------------------------------------------------------------------------------*/
#define   BM22S4221_1_LED_GPIO        STRCAT2(P,            C)
#define   BM22S4221_1_LED_GPIO_ID     STRCAT2(GPIO_P,       C)
#define   BM22S4221_1_LED_AFIO_PIN    STRCAT2(AFIO_PIN_,    11)
#define   BM22S4221_1_LED_GPIO_PORT   STRCAT2(HT_GPIO,      C)
#define   BM22S4221_1_LED_GPIO_PIN    STRCAT2(GPIO_PIN_,    11)
#endif



/*----------------------------------------------------------------------------------------------------------*/
/* USE_HT32F52352_SK                                                                                        */
/*----------------------------------------------------------------------------------------------------------*/
/* ESK32-30501_LED2--------------------------------------------------------------------------------------*/
#if defined(USE_HT32F52352_SK)
#define   BM22S4221_1_LED_GPIO        STRCAT2(P,            C)
#define   BM22S4221_1_LED_GPIO_ID     STRCAT2(GPIO_P,       C)
#define   BM22S4221_1_LED_AFIO_PIN    STRCAT2(AFIO_PIN_,    15)
#define   BM22S4221_1_LED_GPIO_PORT   STRCAT2(HT_GPIO,      C)
#define   BM22S4221_1_LED_GPIO_PIN    STRCAT2(GPIO_PIN_,    15)
#endif

/* Global variables ----------------------------------------------------------------------------------------*/

uint8_t flag;
uint8_t DATA[25];

/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
void _delay(vu32 count);
void BM22S4221_1_LED_Init(void);
void BM22S4221_1_LED_OUTPUT_HIGH(void);
void BM22S4221_1_LED_OUTPUT_LOW(void);
/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
	RETARGET_Configuration();           //Initialise the serial monitor with a baud rate of 115200
	BM22S4221_1_Init(); // Module initialization using UART communication.
	BM22S4221_1_LED_Init();
	while(1)
	{
if(BM22S4221_1_getSTATUS()==1&&flag!=1)
  { 
		printf("Alarm! an object passes by \r\n");
    flag=1;
   }
  if(flag!=0&&BM22S4221_1_getSTATUS()==0)
  {
    flag=0;
		printf("Module normal;no alarm\r\n");
  }
  switch(flag)
  {
    case 0:    
		BM22S4221_1_LED_OUTPUT_HIGH();
    _BM22S4221_1_delay(100);
		BM22S4221_1_LED_OUTPUT_LOW();
    _BM22S4221_1_delay(900);
    break;
    case 1:    
		BM22S4221_1_LED_OUTPUT_HIGH();
    _BM22S4221_1_delay(1000);
    break;
  }
	}
}

/*********************************************************************************************************//**
 * @brief  delay ms.
 * @param  count
 * @retval void
 ************************************************************************************************************/
void _delay(vu32 count)
{
  count = SystemCoreClock / 8000 * count;
  while(count--);
}
/*********************************************************************************************************//**
 * @brief  BM53A367A D13 Init
 * @param  void
 * @retval void
 ************************************************************************************************************/
void BM22S4221_1_LED_Init()
{
	//OUTPUT:D13
	{
	CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};
  CKCUClock.Bit.BM22S4221_1_LED_GPIO = 1;
  CKCUClock.Bit.AFIO       = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
	}
	AFIO_GPxConfig(BM22S4221_1_LED_GPIO_ID,BM22S4221_1_LED_AFIO_PIN, AFIO_FUN_GPIO);
	GPIO_DirectionConfig(BM22S4221_1_LED_GPIO_PORT, BM22S4221_1_LED_GPIO_PIN, GPIO_DIR_OUT);
	GPIO_WriteOutBits(BM22S4221_1_LED_GPIO_PORT, BM22S4221_1_LED_GPIO_PIN, SET);
}
/*********************************************************************************************************//**
 * @brief  Raise D13 and light up the LED
 * @param  void
 * @retval void
 ************************************************************************************************************/
void BM22S4221_1_LED_OUTPUT_HIGH(void)
{
		GPIO_WriteOutBits(BM22S4221_1_LED_GPIO_PORT, BM22S4221_1_LED_GPIO_PIN, SET);
}
/*********************************************************************************************************//**
 * @brief  Pull down D13, LED off
 * @param  void
 * @retval void
 ************************************************************************************************************/
void BM22S4221_1_LED_OUTPUT_LOW(void)
{
		GPIO_WriteOutBits(BM22S4221_1_LED_GPIO_PORT, BM22S4221_1_LED_GPIO_PIN, RESET);
}
