/*****************************************************************
File:         BML36K532_BM42S5321-1_demo.ino
******************************************************************/
#include "BM42S5321-1.h"
#include <BMD58T280.h>

//BM42S5321_1     BM42(22,&Wire1); //Please uncomment out this line of code if you use HW Wire1 on BMduino
BM42S5321_1     BM42(22,&Serial1); //Please uncomment out this line of code if you use HW Serial4 on BMduino

BMD58T280 tft;
BM_XPT2046 touchScreen;

uint16_t dataState;
uint16_t Distance;
uint16_t x;
uint16_t y;
char char_Distance[8];

void setup() 
{
  Serial.begin(9600);
  //BM42.begin();  //Module initialization 
  BM42.begin(BUARD_9600);  //Module initialization 
  BM42.setDistanceModeLong(); //Select a long distance measurement mode
  BM42.setThshold(200, 100);
  BM42.setMeasureMode(ContinuousRanging);//Select the ranging mode as continuous measurement
  BM42.startMeasure(); //Start ranging
  touchScreen.begin();
  tft.begin(); // Initialize module: BMD58T280*/
  tft.setRotation(1);
  tft.background(BM_ILI9341::BLACK);
  tft.stroke(BM_ILI9341::WHITE); 
  tft.setTextSize(4);
  tft.text("BM42S5321-1", 30, 5);
  tft.setTextSize(5);
  tft.text("D:", 30, 80, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
  tft.text("mm", 220, 80, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
  tft.setTextSize(2);
  tft.text("Continuous", 20, 220);
  tft.text("Single", 220, 220);
  tft.setTextSize(5);
  
  tft.stroke(BM_ILI9341::GREEN);
  tft.fill(0, 255, 0);
  tft.rect(50, 150, 50, 50, 5);
  tft.stroke(BM_ILI9341::LIGHTGREY);
  tft.fill(198, 195, 198);
  tft.rect(225, 150, 50, 50, 5);
}

void loop()
{
  
 if (touchScreen.touched())
 {
  BM_XPT2046::TS_Point p = touchScreen.getPoint();
  p.x = map(p.x,250,3800, 0, tft.height()); 
  if(p.x<0) 
  {
    p.x = 0;
  }
  p.y = map(p.y,250,3600, 0, tft.width()); 
  if(p.y<0)
  {
    p.y = 0;
  } 
  x = p.y;
  y = 239-p.x;
  Serial.print("x:");
  Serial.println(x);
  Serial.print("y:");
  Serial.println(y);
  if(50<x && x<100 && 150<y && y<200)
  {
   tft.stroke(BM_ILI9341::GREEN);
   tft.fill(0, 255, 0);
   tft.rect(50, 150, 50, 50, 5);
   tft.stroke(BM_ILI9341::LIGHTGREY);
   tft.fill(198, 195, 198);
   tft.rect(225, 150, 50, 50, 5);
   BM42.setMeasureMode(ContinuousRanging);//Select the ranging mode as continuous measurement
   BM42.startMeasure(); //Start ranging
   delay(100);
  }

  if(225<x && x<275 && 150<y && y<200)
  {
   tft.stroke(BM_ILI9341::LIGHTGREY);
   tft.fill(198, 195, 198);
   tft.rect(50, 150, 50, 50, 5);
   tft.stroke(BM_ILI9341::GREEN);
   tft.fill(0, 255, 0);
   tft.rect(225, 150, 50, 50, 5);
   BM42.setMeasureMode(SingleRanging);//Select the ranging mode as continuous measurement
   BM42.startMeasure(); //Start ranging
  }

 }

  if(BM42.getINT())
  {
   tft.noFill();
   Distance = BM42.readDistance(dataState); //Acquired detection range
   if(dataState == 0) //Determine whether the distance data is reliable
   {
   String tmp_data;
   tmp_data = String(Distance);
   tmp_data += " ";
   tmp_data.toCharArray(char_Distance, 5);
   tft.text(char_Distance, 90, 80, BM_ILI9341::GREEN, BM_ILI9341::BLACK);
   }
  }

  else
  {
   tft.noFill();
   Distance = BM42.readDistance(dataState); //Acquired detection range
   if(dataState == 0) //Determine whether the distance data is reliable
   {
    String tmp_data;
    tmp_data = String(Distance);
    tmp_data += " ";
    tmp_data.toCharArray(char_Distance, 5);
    tft.text(char_Distance, 90, 80, BM_ILI9341::RED, BM_ILI9341::BLACK);
   }
  }

}
