/*********************************************************************************************************//**
 * @file    BMD58T280_HT32/example_display/ht32_board_config.h
 * @version V1.0.1
 * @date    2025-07-18
 * @brief   The configuration file.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
// <<< Use Configuration Wizard in Context Menu >>>

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __HT32_BOARD_CONFIG_H
#define __HT32_BOARD_CONFIG_H

/* Includes ------------------------------------------------------------------------------------------------*/
#include "bmduino_board.h"

/* Settings ------------------------------------------------------------------------------------------------*/
#define LCD_MODE                         (0) //0:EBI   1:SPI

/* Constant */
#define LCD_EBI_MODE                     (0)
#define LCD_SPI_MODE                     (1)
/*----------------------------------------------------------------------------------------------------------*/
/* USE_BM53A367A_DVB                                                                                        */
/*----------------------------------------------------------------------------------------------------------*/
#if defined(USE_BM53A367A_DVB)
/* LCD Module Setting--------------------------------------------------------------------------------------*/
#define LCD_EBI                     (HT_EBI)

#define LCD_EBI_CS_GPIO_ID          (GPIO_PC)               // A3/D17
#define LCD_EBI_CS_AFIO_PIN         (AFIO_PIN_2)
#define LCD_EBI_CS_AFIO_MODE        (AFIO_FUN_EBI)

#define LCD_EBI_OE_GPIO_ID          (GPIO_PC)               // A0/D14
#define LCD_EBI_OE_AFIO_PIN         (AFIO_PIN_1)
#define LCD_EBI_OE_AFIO_MODE        (AFIO_FUN_EBI)

#define LCD_EBI_WE_GPIO_ID          (GPIO_PC)               // A1/D15
#define LCD_EBI_WE_AFIO_PIN         (AFIO_PIN_3)
#define LCD_EBI_WE_AFIO_MODE        (AFIO_FUN_EBI)

#define LCD_EBI_RS_GPIO_ID          (GPIO_PD)               // A2/D16
#define LCD_EBI_RS_AFIO_PIN         (AFIO_PIN_4)
#define LCD_EBI_RS_AFIO_MODE        (AFIO_FUN_EBI)
#define LCD_EBI_RS_ADDR_PIN         (2)

#define LCD_EBI_AD0_GPIO_ID         (GPIO_PA)               // D8
#define LCD_EBI_AD0_AFIO_PIN        (AFIO_PIN_14)
#define LCD_EBI_AD0_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD1_GPIO_ID         (GPIO_PA)               // D9
#define LCD_EBI_AD1_AFIO_PIN        (AFIO_PIN_15)
#define LCD_EBI_AD1_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD2_GPIO_ID         (GPIO_PB)               // D2
#define LCD_EBI_AD2_AFIO_PIN        (AFIO_PIN_0)
#define LCD_EBI_AD2_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD3_GPIO_ID         (GPIO_PB)               // D3
#define LCD_EBI_AD3_AFIO_PIN        (AFIO_PIN_1)
#define LCD_EBI_AD3_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD4_GPIO_ID         (GPIO_PB)               // D4
#define LCD_EBI_AD4_AFIO_PIN        (AFIO_PIN_2)
#define LCD_EBI_AD4_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD5_GPIO_ID         (GPIO_PB)               // D5
#define LCD_EBI_AD5_AFIO_PIN        (AFIO_PIN_3)
#define LCD_EBI_AD5_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD6_GPIO_ID         (GPIO_PB)               // D6
#define LCD_EBI_AD6_AFIO_PIN        (AFIO_PIN_4)
#define LCD_EBI_AD6_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD7_GPIO_ID         (GPIO_PB)               // D7
#define LCD_EBI_AD7_AFIO_PIN        (AFIO_PIN_5)
#define LCD_EBI_AD7_AFIO_MODE       (AFIO_FUN_EBI)

#if (LCD_MODE==LCD_SPI_MODE)
  
  #define LCD_SPI_BL_GPIO_PORT        (HT_GPIOC)
  #define LCD_SPI_BL_GPIO_ID          (GPIO_PC)               // A0/D14
  #define LCD_SPI_BL_GPIO_PIN         (GPIO_PIN_1)  
  #define LCD_SPI_BL_AFIO_PIN         (AFIO_PIN_1)
  #define LCD_SPI_BL_AFIO_MODE        (AFIO_FUN_EBI)

  #define LCD_SPI_DC_GPIO_PORT        (HT_GPIOC)
  #define LCD_SPI_DC_GPIO_ID          (GPIO_PC)               // A1/D15   DC
  #define LCD_SPI_DC_GPIO_PIN         (GPIO_PIN_3)  
  #define LCD_SPI_DC_AFIO_PIN         (AFIO_PIN_3)
  #define LCD_SPI_DC_AFIO_MODE        (AFIO_FUN_EBI)

#endif


/* USART Module Setting--------------------------------------------------------------------------------------*/
#define COM1_PORT                   (HT_USART0)
#define COM1_PORT_CLK               USART0
#define COM1_PORT_GPIO_CLK          PA

#define COM1_TX_GPIO_ID             (GPIO_PA)               
#define COM1_TX_AFIO_PIN            (AFIO_PIN_8)
#define COM1_TX_AFIO_MODE           (AFIO_FUN_USART_UART)
#define COM1_TX_GPIO_PORT           (HT_GPIOA)
#define COM1_TX_GPIO_PIN            (GPIO_PIN_8)

#define COM1_RX_GPIO_ID             (GPIO_PA)               
#define COM1_RX_AFIO_PIN            (AFIO_PIN_10)
#define COM1_RX_AFIO_MODE           (AFIO_FUN_USART_UART)
#define COM1_RX_GPIO_PORT           (HT_GPIOA)
#define COM1_RX_GPIO_PIN            (GPIO_PIN_10)


/* SPI Module Setting--------------------------------------------------------------------------------------*/
#define SPI_GPIO_CLK                PC

#define SPI_XPT2046_CS_GPIO_ID          (GPIO_PC)       // SDA/A4       
#define SPI_XPT2046_CS_GPIO_PIN         (GPIO_PIN_5)
#define SPI_XPT2046_CS_GPIO_PORT        (HT_GPIOC)

#define SPI_LCD_CS_GPIO_ID          (GPIO_PC)           // A3   
#define SPI_LCD_CS_GPIO_PIN         (GPIO_PIN_2)
#define SPI_LCD_CS_GPIO_PORT        (HT_GPIOC)

#define XPT2046_PEN_GPIO_ID         (GPIO_PC)           // SCL/A5
#define XPT2046_PEN_GPIO_PIN        (GPIO_PIN_4)
#define XPT2046_PEN_GPIO_PORT       (HT_GPIOC)

#define SPI_MISO_GPIO_ID        (GPIO_PC)               // D12
#define SPI_MISO_GPIO_PIN       (GPIO_PIN_9)
#define SPI_MISO_GPIO_PORT      (HT_GPIOC)
#define SPI_MISO_AFIO_PIN       (AFIO_PIN_9)

#define SPI_SCK_GPIO_ID         (GPIO_PC)               // D13
#define SPI_SCK_GPIO_PIN        (GPIO_PIN_11)
#define SPI_SCK_GPIO_PORT       (HT_GPIOC)
#define SPI_SCK_AFIO_PIN       (AFIO_PIN_11)

#define SPI_MOSI_GPIO_ID        (GPIO_PC)               // D11
#define SPI_MOSI_GPIO_PIN       (GPIO_PIN_8)
#define SPI_MOSI_GPIO_PORT      (HT_GPIOC)
#define SPI_MOSI_AFIO_PIN       (AFIO_PIN_8)


#endif


/*----------------------------------------------------------------------------------------------------------*/
/* USE_HT32F52352_SK                                                                                        */
/*----------------------------------------------------------------------------------------------------------*/
#if defined(USE_HT32F52352_SK)
/* LCD Module Setting--------------------------------------------------------------------------------------*/
#define LCD_EBI                     (HT_EBI)

#define LCD_EBI_CS_GPIO_ID          (GPIO_PC)               // A3/D17
#define LCD_EBI_CS_AFIO_PIN         (AFIO_PIN_2)
#define LCD_EBI_CS_AFIO_MODE        (AFIO_FUN_EBI)

#define LCD_EBI_OE_GPIO_ID          (GPIO_PC)               // A0/D14
#define LCD_EBI_OE_AFIO_PIN         (AFIO_PIN_1)
#define LCD_EBI_OE_AFIO_MODE        (AFIO_FUN_EBI)

#define LCD_EBI_WE_GPIO_ID          (GPIO_PC)               // A1/D15
#define LCD_EBI_WE_AFIO_PIN         (AFIO_PIN_3)
#define LCD_EBI_WE_AFIO_MODE        (AFIO_FUN_EBI)

#define LCD_EBI_RS_GPIO_ID          (GPIO_PA)               // A2/D16
#define LCD_EBI_RS_AFIO_PIN         (AFIO_PIN_11)
#define LCD_EBI_RS_AFIO_MODE        (AFIO_FUN_EBI)
#define LCD_EBI_RS_ADDR_PIN         (0)

#define LCD_EBI_AD0_GPIO_ID         (GPIO_PA)             // D8
#define LCD_EBI_AD0_AFIO_PIN        (AFIO_PIN_14)
#define LCD_EBI_AD0_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD1_GPIO_ID         (GPIO_PA)             // D9
#define LCD_EBI_AD1_AFIO_PIN        (AFIO_PIN_15)
#define LCD_EBI_AD1_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD2_GPIO_ID         (GPIO_PB)             // D2
#define LCD_EBI_AD2_AFIO_PIN        (AFIO_PIN_0)
#define LCD_EBI_AD2_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD3_GPIO_ID         (GPIO_PB)             // D3
#define LCD_EBI_AD3_AFIO_PIN        (AFIO_PIN_1)
#define LCD_EBI_AD3_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD4_GPIO_ID         (GPIO_PB)             // D4
#define LCD_EBI_AD4_AFIO_PIN        (AFIO_PIN_2)
#define LCD_EBI_AD4_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD5_GPIO_ID         (GPIO_PB)             // D5
#define LCD_EBI_AD5_AFIO_PIN        (AFIO_PIN_3)
#define LCD_EBI_AD5_AFIO_MODE       (AFIO_FUN_EBI)

#define LCD_EBI_AD6_GPIO_ID         (GPIO_PB)             // D6
#define LCD_EBI_AD6_AFIO_PIN        (AFIO_PIN_4) 
#define LCD_EBI_AD6_AFIO_MODE       (AFIO_FUN_EBI)
 
#define LCD_EBI_AD7_GPIO_ID         (GPIO_PB)            // D7
#define LCD_EBI_AD7_AFIO_PIN        (AFIO_PIN_5)
#define LCD_EBI_AD7_AFIO_MODE       (AFIO_FUN_EBI)

#if (LCD_MODE==LCD_SPI_MODE)
  
  #define LCD_SPI_BL_GPIO_PORT        (HT_GPIOC)
  #define LCD_SPI_BL_GPIO_ID          (GPIO_PC)               // A0/D14
  #define LCD_SPI_BL_GPIO_PIN         (GPIO_PIN_1)  
  #define LCD_SPI_BL_AFIO_PIN         (AFIO_PIN_1)
  #define LCD_SPI_BL_AFIO_MODE        (AFIO_FUN_EBI)

  #define LCD_SPI_DC_GPIO_PORT        (HT_GPIOC)
  #define LCD_SPI_DC_GPIO_ID          (GPIO_PC)               // A1/D15   DC
  #define LCD_SPI_DC_GPIO_PIN         (GPIO_PIN_3)  
  #define LCD_SPI_DC_AFIO_PIN         (AFIO_PIN_3)
  #define LCD_SPI_DC_AFIO_MODE        (AFIO_FUN_EBI)

#endif

/* USART Module Setting--------------------------------------------------------------------------------------*/
#define COM1_PORT                   (HT_USART1)
#define COM1_PORT_CLK               USART1
#define COM1_PORT_GPIO_CLK          PA

#define COM1_TX_GPIO_ID             (GPIO_PA)               
#define COM1_TX_AFIO_PIN            (AFIO_PIN_4)
#define COM1_TX_AFIO_MODE           (AFIO_FUN_USART_UART)
#define COM1_TX_GPIO_PORT           (HT_GPIOA)
#define COM1_TX_GPIO_PIN            (GPIO_PIN_4)

#define COM1_RX_GPIO_ID             (GPIO_PA)               
#define COM1_RX_AFIO_PIN            (AFIO_PIN_5)
#define COM1_RX_AFIO_MODE           (AFIO_FUN_USART_UART)
#define COM1_RX_GPIO_PORT           (HT_GPIOA)
#define COM1_RX_GPIO_PIN            (GPIO_PIN_5)

/* SPI Module Setting--------------------------------------------------------------------------------------*/
#define SPI_GPIO_CLK                PC

#define SPI_XPT2046_CS_GPIO_ID          (GPIO_PC)           // SDA/A4        
#define SPI_XPT2046_CS_GPIO_PIN         (GPIO_PIN_5)
#define SPI_XPT2046_CS_GPIO_PORT        (HT_GPIOC)

#define SPI_LCD_CS_GPIO_ID          (GPIO_PC)               // A3
#define SPI_LCD_CS_GPIO_PIN         (GPIO_PIN_2)
#define SPI_LCD_CS_GPIO_PORT        (HT_GPIOC)

#define XPT2046_PEN_GPIO_ID         (GPIO_PC)               // SCL/A5     
#define XPT2046_PEN_GPIO_PIN        (GPIO_PIN_4)
#define XPT2046_PEN_GPIO_PORT       (HT_GPIOC)

#define SPI_MISO_GPIO_ID        (GPIO_PC)                   // D12     
#define SPI_MISO_GPIO_PIN       (GPIO_PIN_9)
#define SPI_MISO_GPIO_PORT      (HT_GPIOC)
#define SPI_MISO_AFIO_PIN       (AFIO_PIN_9)

#define SPI_SCK_GPIO_ID         (GPIO_PC)                   // D13    
#define SPI_SCK_GPIO_PIN        (GPIO_PIN_11)
#define SPI_SCK_GPIO_PORT       (HT_GPIOC)
#define SPI_SCK_AFIO_PIN       (AFIO_PIN_11)

#define SPI_MOSI_GPIO_ID        (GPIO_PC)                  // D11
#define SPI_MOSI_GPIO_PIN       (GPIO_PIN_8)
#define SPI_MOSI_GPIO_PORT      (HT_GPIOC)
#define SPI_MOSI_AFIO_PIN       (AFIO_PIN_8)

#endif

#endif
