/*********************************************************************************************************//**
 * @file    font.h
 * @version $Rev:: 193          $
 * @date    $Date:: 2015-12-10 #$
 * @brief   This file contains the font information.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __FONT_H
#define __FONT_H

#ifdef __cplusplus
 extern "C" {
#endif

/** @addtogroup Utilities
  * @{
  */

/** @addtogroup Common
  * @{
  */

/** @addtogroup FONT Font
  * @brief This file contains the font information.
  * @{
  */


/* Settings ------------------------------------------------------------------------------------------------*/
/** @defgroup FONT_Settings Font settings
  * @{
  */
#define FONT_IN_FLASH           (1)

#if (FONT_IN_FLASH == 1)
  #define FONT_TYPE uc16
#else
  #define FONT_TYPE u16
#endif
/**
  * @}
  */

/* Exported constants --------------------------------------------------------------------------------------*/
/** @defgroup FONT_Exported_Constants Font exported constants
  * @{
  */
/* ASCII Table: each character is 16 column (16 dots large) and 24 raw (24 dots high)                       */
#define Font_Column             (16)
#define Font_Raw                (24)
/**
  * @}
  */

/* Exported variables --------------------------------------------------------------------------------------*/
/** @defgroup FONT_Exported_Variables Font exported variables
  * @{
  */

/* The font is different from Arduino Library Font2  */
FONT_TYPE ASCII_Font_Table2[] = {
        /* Space ' '                                                                                        */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '!'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x0080, 0x0080, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '"'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0770, 0x0770, 0x0770, 0x0770,
        0x0770, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '#'                                                                                              */
        0x0000, 0x0000, 0x3300, 0x3300,
        0x1980, 0x1980, 0x1980, 0x0CC0,
        0x7FFE, 0x7FFE, 0x0CC0, 0x0EE0,
        0x0660, 0x7FFE, 0x7FFE, 0x0660,
        0x0770, 0x0330, 0x0330, 0x0198,
        0x0198, 0x0000, 0x0000, 0x0000,
        /* '$'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0080,
        0x03E0, 0x07F0, 0x0EB8, 0x0EB8,
        0x00B8, 0x00F8, 0x01F0, 0x07E0,
        0x0F80, 0x0E80, 0x0E80, 0x0EB8,
        0x0EB8, 0x07F0, 0x03E0, 0x0080,
        0x0080, 0x0000, 0x0000, 0x0000,
        /* '%'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0C1E, 0x063E, 0x0633, 0x0633,
        0x0333, 0x0333, 0x01BE, 0x019E,
        0x3CC0, 0x7EC0, 0x6660, 0x6660,
        0x6660, 0x6630, 0x7E30, 0x3C18,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '&'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x07E0, 0x0E70, 0x0E70,
        0x0EF0, 0x07E0, 0x03E0, 0x03F0,
        0x33F8, 0x3F3C, 0x3F1C, 0x1E1C,
        0x3F3C, 0x7FF8, 0x23F0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '''                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '('                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0300, 0x0180, 0x0180, 0x01C0,
        0x01C0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00C0, 0x01C0, 0x01C0,
        0x0180, 0x0180, 0x0300, 0x0000,
        /* ')'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x00C0, 0x0180, 0x0180, 0x0380,
        0x0380, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0300, 0x0380, 0x0380,
        0x0180, 0x0180, 0x00C0, 0x0000,
        /* '*'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x05A0, 0x0DB0, 0x1FF8,
        0x07E0, 0x03C0, 0x0660, 0x0E70,
        0x0660, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '+'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x1FFC, 0x1FFC,
        0x1FFC, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* ','                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0100,
        0x0180, 0x00C0, 0x0000, 0x0000,
        /* '-'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0FF0, 0x0FF0, 0x0FF0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '.'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '/'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0C00,
        0x0C00, 0x0C00, 0x0600, 0x0600,
        0x0600, 0x0700, 0x0300, 0x0300,
        0x0300, 0x0180, 0x0180, 0x0180,
        0x0180, 0x00C0, 0x00C0, 0x0060,
        0x0060, 0x0060, 0x0000, 0x0000,
        /* '0'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0FF8, 0x0E38,
        0x0E38, 0x0E38, 0x0E38, 0x0E38,
        0x0E38, 0x0E38, 0x0E38, 0x0E38,
        0x0FF8, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '1'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0700, 0x0700, 0x0780, 0x07E0,
        0x07F0, 0x0770, 0x0710, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '2'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03F0, 0x07F8, 0x0E38, 0x0E3C,
        0x0E1C, 0x0E00, 0x0700, 0x0780,
        0x03C0, 0x01C0, 0x00E0, 0x00F0,
        0x0070, 0x0FF8, 0x0FF8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '3'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0E38,
        0x0E00, 0x0F00, 0x07C0, 0x07C0,
        0x0F00, 0x0E00, 0x0E00, 0x0E38,
        0x0E38, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '4'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0E00, 0x0F00, 0x0F00, 0x0F80,
        0x0F80, 0x0EC0, 0x0E60, 0x0E60,
        0x0E30, 0x0E18, 0x3FFC, 0x3FFC,
        0x0E00, 0x0E00, 0x0E00, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '5'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x07E0, 0x0070, 0x0070,
        0x0070, 0x03F0, 0x07F8, 0x0F38,
        0x0E00, 0x0E00, 0x0E00, 0x0E38,
        0x0778, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '6'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x07F0, 0x0F70, 0x0638,
        0x0038, 0x03B8, 0x07F8, 0x0F78,
        0x0E38, 0x0E38, 0x0E38, 0x0E38,
        0x0770, 0x07F0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '7'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0FF8, 0x0FF8, 0x0E00, 0x0700,
        0x0380, 0x0380, 0x01C0, 0x01C0,
        0x00E0, 0x00E0, 0x00E0, 0x0070,
        0x0070, 0x0070, 0x0070, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '8'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0E38,
        0x0E38, 0x0770, 0x03E0, 0x03E0,
        0x0770, 0x0E38, 0x0E38, 0x0E38,
        0x0F78, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '9'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0FE0, 0x0EE0, 0x1C70,
        0x1C70, 0x1C70, 0x1C70, 0x1EF0,
        0x1FE0, 0x1DC0, 0x1C00, 0x1C60,
        0x0EF0, 0x0FE0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* ':'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* ';'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0380, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0380, 0x0200,
        0x0300, 0x0180, 0x0000, 0x0000,
        /* '<'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x1000, 0x1C00,
        0x1F80, 0x07E0, 0x00F8, 0x003C,
        0x01F8, 0x0FE0, 0x1F80, 0x1C00,
        0x1000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '='                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3FFC, 0x3FFC, 0x3FFC, 0x0000,
        0x0000, 0x3FFC, 0x3FFC, 0x3FFC,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '>'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0008, 0x0038,
        0x01F8, 0x07E0, 0x1F00, 0x3C00,
        0x1F80, 0x07F0, 0x01F8, 0x0038,
        0x0008, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '?'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x0FF0, 0x1E78, 0x1C38,
        0x1C00, 0x1E00, 0x0F00, 0x0780,
        0x03C0, 0x01C0, 0x01C0, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '@'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0FC0, 0x3FF8, 0x703C, 0xE00E,
        0xDDC6, 0x8DE2, 0x8FF3, 0x8E71,
        0x8E39, 0x8E39, 0xC639, 0xC739,
        0x67F9, 0x3FF1, 0x1E61, 0x8007,
        0xC00E, 0xF03C, 0x7FF8, 0x1FE0,
        /* 'A'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x07C0, 0x07C0, 0x0EE0,
        0x0EE0, 0x0EE0, 0x1C60, 0x1C70,
        0x1C70, 0x1FF0, 0x3FF8, 0x3FF8,
        0x3838, 0x701C, 0x701E, 0xE006,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'B'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x1C1C, 0x1C1C, 0x0FFC, 0x0FFC,
        0x1FFC, 0x381C, 0x381C, 0x381C,
        0x3FFC, 0x1FFC, 0x0FFC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'C'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x1FF0, 0x1FF8, 0x3C38,
        0x183C, 0x001C, 0x001C, 0x001C,
        0x001C, 0x001C, 0x183C, 0x3C38,
        0x1FF8, 0x1FF0, 0x07C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'D'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x3C1C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x1C1C,
        0x1FFC, 0x0FFC, 0x03FC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'E'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1FFC, 0x1FFC, 0x1FFC, 0x001C,
        0x001C, 0x001C, 0x0FFC, 0x0FFC,
        0x0FFC, 0x001C, 0x001C, 0x001C,
        0x1FFC, 0x1FFC, 0x1FFC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'F'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1FF8, 0x1FF8, 0x1FF8, 0x0038,
        0x0038, 0x0038, 0x0FF8, 0x0FF8,
        0x0FF8, 0x0038, 0x0038, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'G'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x1FF0, 0x3FF8, 0x783C,
        0x301E, 0x000E, 0x000E, 0x7F0E,
        0x7F0E, 0x7F0E, 0x701C, 0x783C,
        0x7FF8, 0x3FF0, 0x07C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'H'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x381C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x3FFC, 0x3FFC,
        0x3FFC, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'I'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'J'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C00, 0x1C00, 0x1C00, 0x1C00,
        0x1C00, 0x1C00, 0x1C00, 0x1C00,
        0x1C00, 0x1C38, 0x1C38, 0x1C78,
        0x1FF0, 0x0FF0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'K'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3C1C, 0x1E1C, 0x0F1C, 0x071C,
        0x039C, 0x03DC, 0x03FC, 0x07FC,
        0x077C, 0x0E3C, 0x0E1C, 0x1C1C,
        0x1C1C, 0x381C, 0x381C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'L'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x3FF8, 0x3FF8, 0x3FF8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'M'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x7C1F, 0x7C1F, 0x7C1F, 0x7637,
        0x7637, 0x7637, 0x7777, 0x7777,
        0x7367, 0x7367, 0x73E7, 0x73E7,
        0x71C7, 0x71C7, 0x71C7, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'N'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x381C, 0x383C, 0x387C, 0x387C,
        0x38FC, 0x38DC, 0x39DC, 0x399C,
        0x3B9C, 0x3B1C, 0x3F1C, 0x3E1C,
        0x3E1C, 0x3C1C, 0x381C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'O'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x1FF8, 0x3FFC, 0x3C3C,
        0x781E, 0x700E, 0x700E, 0x700E,
        0x700E, 0x700E, 0x781E, 0x3C3C,
        0x3FFC, 0x1FF8, 0x07E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'P'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x1C1C, 0x1C1C, 0x1FFC, 0x0FFC,
        0x07FC, 0x001C, 0x001C, 0x001C,
        0x001C, 0x001C, 0x001C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'Q'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x1FF8, 0x3FFC, 0x3C3C,
        0x781E, 0x700E, 0x700E, 0x700E,
        0x700E, 0x710E, 0x7B9E, 0x3F3C,
        0x3FFC, 0x7FF8, 0xF7E0, 0x6000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'R'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x1C1C, 0x1C1C, 0x1FFC, 0x0FFC,
        0x03FC, 0x079C, 0x0F1C, 0x0E1C,
        0x1E1C, 0x1C1C, 0x3C1C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'S'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x0FF8, 0x0FF8, 0x1E3C,
        0x1C1C, 0x003C, 0x01F8, 0x0FF0,
        0x0FC0, 0x1E00, 0x1C1C, 0x1E3C,
        0x1FF8, 0x0FF8, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'T'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3FFC, 0x3FFC, 0x3FFC, 0x03C0,
        0x03C0, 0x03C0, 0x03C0, 0x03C0,
        0x03C0, 0x03C0, 0x03C0, 0x03C0,
        0x03C0, 0x03C0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'U'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x381C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x3C3C,
        0x1FF8, 0x1FF8, 0x07E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'V'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x600E,
        0x701E, 0x701C, 0x3838, 0x3838,
        0x3838, 0x1C70, 0x1C70, 0x1C70,
        0x0EE0, 0x0EE0, 0x0EE0, 0x07C0,
        0x07C0, 0x07C0, 0x0380, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'W'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x8383, 0x8383, 0xC7C7, 0xC7C7,
        0xC6C7, 0xC6C7, 0xEEEE, 0xEEEE,
        0xEC6E, 0xEC6E, 0xFC7C, 0x7C7C,
        0x7C7C, 0x783C, 0x783C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'X'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C1C, 0x1C1C, 0x0E38, 0x0770,
        0x0770, 0x03E0, 0x03E0, 0x01C0,
        0x03E0, 0x03E0, 0x0770, 0x0770,
        0x0E38, 0x1C1C, 0x1C1C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'Y'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x380E, 0x380E, 0x1C1C, 0x0E38,
        0x0E38, 0x0770, 0x03E0, 0x03E0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'Z'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3FFC, 0x3FFC, 0x3FFC, 0x1E00,
        0x0F00, 0x0780, 0x0380, 0x01C0,
        0x00E0, 0x00F0, 0x0078, 0x003C,
        0x3FFC, 0x3FFC, 0x3FFC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '['                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x03E0, 0x03E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x03E0, 0x03E0, 0x03E0, 0x0000,
        /* '\'                                                                                              */
        0x0000, 0x0030, 0x0030, 0x0060,
        0x0060, 0x0060, 0x00C0, 0x00C0,
        0x00C0, 0x00C0, 0x0180, 0x0180,
        0x0180, 0x0380, 0x0300, 0x0300,
        0x0300, 0x0600, 0x0600, 0x0600,
        0x0C00, 0x0C00, 0x0C00, 0x0000,
        /* ']'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x07C0, 0x07C0, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x07C0, 0x07C0, 0x07C0, 0x0000,
        /* '^'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x03C0, 0x03C0, 0x07E0,
        0x0660, 0x0E70, 0x0E70, 0x1C38,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '_'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x7FFE, 0x7FFE, 0x0000,
        /* '''                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0070,
        0x00E0, 0x00C0, 0x0180, 0x0100,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'a'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E18, 0x0E00,
        0x0FC0, 0x0FF0, 0x0E78, 0x0E38,
        0x0F38, 0x0FF8, 0x1CF0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'b'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x07B8, 0x0FF8, 0x0E78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x0E78, 0x0FF8, 0x07B8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'c'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x07F0, 0x0E70, 0x0438,
        0x0038, 0x0038, 0x0038, 0x0438,
        0x0E70, 0x07F0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'd'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C00, 0x1C00, 0x1C00, 0x1C00,
        0x1DE0, 0x1FF0, 0x1E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E70, 0x1FF0, 0x1DE0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'e'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0E38,
        0x0FF8, 0x0FF8, 0x0038, 0x0038,
        0x0E78, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'f'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0F80, 0x0FC0, 0x01C0, 0x01C0,
        0x07F0, 0x07F0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'g'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1DE0, 0x1FF0, 0x1E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E70, 0x1FF0, 0x1DE0, 0x1C00,
        0x1C38, 0x0FF8, 0x07E0, 0x0000,
        /* 'h'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x07B8, 0x0FF8, 0x1C78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'i'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'j'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x03B0, 0x03F0, 0x01E0, 0x0000,
        /* 'k'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0070, 0x0070, 0x0070, 0x0070,
        0x1C70, 0x0E70, 0x0770, 0x03F0,
        0x03F0, 0x07F0, 0x0770, 0x0E70,
        0x0E70, 0x1C70, 0x1C70, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'l'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'm'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x38EE, 0x7FFE, 0xE79E, 0xE38E,
        0xE38E, 0xE38E, 0xE38E, 0xE38E,
        0xE38E, 0xE38E, 0xE38E, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'n'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07B8, 0x0FF8, 0x1E78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'o'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x0FF0, 0x0E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x0E70, 0x0FF0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'p'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07B8, 0x0FF8, 0x0E78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x0E78, 0x0FF8, 0x07B8, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0000,
        /* 'q'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1DE0, 0x1FF0, 0x1E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E70, 0x1FF0, 0x1DE0, 0x1C00,
        0x1C00, 0x1C00, 0x1C00, 0x0000,
        /* 'r'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0F7C, 0x07F8, 0x00F0, 0x0070,
        0x0070, 0x0070, 0x0070, 0x0070,
        0x0070, 0x0070, 0x0070, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 's'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0038,
        0x01F8, 0x07F0, 0x0F80, 0x0E00,
        0x0E38, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 't'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x01C0, 0x01C0, 0x01C0,
        0x1FFC, 0x1FFC, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x11C0, 0x1FC0, 0x0F80, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'u'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E78, 0x1FF0, 0x1DE0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'v'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0E38, 0x0E38, 0x0E38, 0x0630,
        0x0770, 0x0770, 0x0360, 0x03E0,
        0x03E0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'w'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0xE38F, 0x638E, 0x638C, 0x77DC,
        0x76DC, 0x36D8, 0x36D8, 0x3EF8,
        0x3C78, 0x1C70, 0x1C70, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'x'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C70, 0x1C70, 0x0EE0, 0x07C0,
        0x07C0, 0x0380, 0x07C0, 0x07C0,
        0x0EE0, 0x1C70, 0x1C70, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'y'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C1C, 0x1C1C, 0x0E38, 0x0E38,
        0x0E38, 0x0770, 0x0770, 0x0360,
        0x03E0, 0x03E0, 0x01C0, 0x01C0,
        0x00E0, 0x00F8, 0x0078, 0x0000,
        /* 'z'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1FF8, 0x1FF8, 0x0E00, 0x0700,
        0x0380, 0x03C0, 0x01C0, 0x00E0,
        0x0070, 0x1FF8, 0x1FF8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '{'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0700, 0x0780, 0x07C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01E0, 0x00F0, 0x00F0, 0x01E0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x07C0, 0x07C0, 0x0780, 0x0000,
        /* '|'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0000,
        /* '}'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x00E0, 0x01E0, 0x03E0, 0x0380,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x0780, 0x0F00, 0x0F00, 0x0780,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x03E0, 0x03E0, 0x01E0, 0x0000,
        /* '~'                                                                                              */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x70F8, 0x3FFC,
        0x1FFE, 0x0F86, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
};


/* Same font as Arduino Library Font1 */
FONT_TYPE gFont[] = {
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x3E, 0x5B, 0x4F, 0x5B, 0x3E,
  0x3E, 0x6B, 0x4F, 0x6B, 0x3E,
  0x1C, 0x3E, 0x7C, 0x3E, 0x1C,
  0x18, 0x3C, 0x7E, 0x3C, 0x18,
  0x1C, 0x57, 0x7D, 0x57, 0x1C,
  0x1C, 0x5E, 0x7F, 0x5E, 0x1C,
  0x00, 0x18, 0x3C, 0x18, 0x00,
  0xFF, 0xE7, 0xC3, 0xE7, 0xFF,
  0x00, 0x18, 0x24, 0x18, 0x00,
  0xFF, 0xE7, 0xDB, 0xE7, 0xFF,
  0x30, 0x48, 0x3A, 0x06, 0x0E,
  0x26, 0x29, 0x79, 0x29, 0x26,
  0x40, 0x7F, 0x05, 0x05, 0x07,
  0x40, 0x7F, 0x05, 0x25, 0x3F,
  0x5A, 0x3C, 0xE7, 0x3C, 0x5A,
  0x7F, 0x3E, 0x1C, 0x1C, 0x08,
  0x08, 0x1C, 0x1C, 0x3E, 0x7F,
  0x14, 0x22, 0x7F, 0x22, 0x14,
  0x5F, 0x5F, 0x00, 0x5F, 0x5F,
  0x06, 0x09, 0x7F, 0x01, 0x7F,
  0x00, 0x66, 0x89, 0x95, 0x6A,
  0x60, 0x60, 0x60, 0x60, 0x60,
  0x94, 0xA2, 0xFF, 0xA2, 0x94,
  0x08, 0x04, 0x7E, 0x04, 0x08,
  0x10, 0x20, 0x7E, 0x20, 0x10,
  0x08, 0x08, 0x2A, 0x1C, 0x08,
  0x08, 0x1C, 0x2A, 0x08, 0x08,
  0x1E, 0x10, 0x10, 0x10, 0x10,
  0x0C, 0x1E, 0x0C, 0x1E, 0x0C,
  0x30, 0x38, 0x3E, 0x38, 0x30,
  0x06, 0x0E, 0x3E, 0x0E, 0x06,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0x00, 0x00,
  0x00, 0x07, 0x00, 0x07, 0x00,
  0x14, 0x7F, 0x14, 0x7F, 0x14,
  0x24, 0x2A, 0x7F, 0x2A, 0x12,
  0x23, 0x13, 0x08, 0x64, 0x62,
  0x36, 0x49, 0x56, 0x20, 0x50,
  0x00, 0x08, 0x07, 0x03, 0x00,
  0x00, 0x1C, 0x22, 0x41, 0x00,
  0x00, 0x41, 0x22, 0x1C, 0x00,
  0x2A, 0x1C, 0x7F, 0x1C, 0x2A,
  0x08, 0x08, 0x3E, 0x08, 0x08,
  0x00, 0x80, 0x70, 0x30, 0x00,
  0x08, 0x08, 0x08, 0x08, 0x08,
  0x00, 0x00, 0x60, 0x60, 0x00,
  0x20, 0x10, 0x08, 0x04, 0x02,
  0x3E, 0x51, 0x49, 0x45, 0x3E,
  0x00, 0x42, 0x7F, 0x40, 0x00,
  0x72, 0x49, 0x49, 0x49, 0x46,
  0x21, 0x41, 0x49, 0x4D, 0x33,
  0x18, 0x14, 0x12, 0x7F, 0x10,
  0x27, 0x45, 0x45, 0x45, 0x39,
  0x3C, 0x4A, 0x49, 0x49, 0x31,
  0x41, 0x21, 0x11, 0x09, 0x07,
  0x36, 0x49, 0x49, 0x49, 0x36,
  0x46, 0x49, 0x49, 0x29, 0x1E,
  0x00, 0x00, 0x14, 0x00, 0x00,
  0x00, 0x40, 0x34, 0x00, 0x00,
  0x00, 0x08, 0x14, 0x22, 0x41,
  0x14, 0x14, 0x14, 0x14, 0x14,
  0x00, 0x41, 0x22, 0x14, 0x08,
  0x02, 0x01, 0x59, 0x09, 0x06,
  0x3E, 0x41, 0x5D, 0x59, 0x4E,
  0x7C, 0x12, 0x11, 0x12, 0x7C,
  0x7F, 0x49, 0x49, 0x49, 0x36,
  0x3E, 0x41, 0x41, 0x41, 0x22,
  0x7F, 0x41, 0x41, 0x41, 0x3E,
  0x7F, 0x49, 0x49, 0x49, 0x41,
  0x7F, 0x09, 0x09, 0x09, 0x01,
  0x3E, 0x41, 0x41, 0x51, 0x73,
  0x7F, 0x08, 0x08, 0x08, 0x7F,
  0x00, 0x41, 0x7F, 0x41, 0x00,
  0x20, 0x40, 0x41, 0x3F, 0x01,
  0x7F, 0x08, 0x14, 0x22, 0x41,
  0x7F, 0x40, 0x40, 0x40, 0x40,
  0x7F, 0x02, 0x1C, 0x02, 0x7F,
  0x7F, 0x04, 0x08, 0x10, 0x7F,
  0x3E, 0x41, 0x41, 0x41, 0x3E,
  0x7F, 0x09, 0x09, 0x09, 0x06,
  0x3E, 0x41, 0x51, 0x21, 0x5E,
  0x7F, 0x09, 0x19, 0x29, 0x46,
  0x26, 0x49, 0x49, 0x49, 0x32,
  0x03, 0x01, 0x7F, 0x01, 0x03,
  0x3F, 0x40, 0x40, 0x40, 0x3F,
  0x1F, 0x20, 0x40, 0x20, 0x1F,
  0x3F, 0x40, 0x38, 0x40, 0x3F,
  0x63, 0x14, 0x08, 0x14, 0x63,
  0x03, 0x04, 0x78, 0x04, 0x03,
  0x61, 0x59, 0x49, 0x4D, 0x43,
  0x00, 0x7F, 0x41, 0x41, 0x41,
  0x02, 0x04, 0x08, 0x10, 0x20,
  0x00, 0x41, 0x41, 0x41, 0x7F,
  0x04, 0x02, 0x01, 0x02, 0x04,
  0x40, 0x40, 0x40, 0x40, 0x40,
  0x00, 0x03, 0x07, 0x08, 0x00,
  0x20, 0x54, 0x54, 0x78, 0x40,
  0x7F, 0x28, 0x44, 0x44, 0x38,
  0x38, 0x44, 0x44, 0x44, 0x28,
  0x38, 0x44, 0x44, 0x28, 0x7F,
  0x38, 0x54, 0x54, 0x54, 0x18,
  0x00, 0x08, 0x7E, 0x09, 0x02,
  0x18, 0xA4, 0xA4, 0x9C, 0x78,
  0x7F, 0x08, 0x04, 0x04, 0x78,
  0x00, 0x44, 0x7D, 0x40, 0x00,
  0x20, 0x40, 0x40, 0x3D, 0x00,
  0x7F, 0x10, 0x28, 0x44, 0x00,
  0x00, 0x41, 0x7F, 0x40, 0x00,
  0x7C, 0x04, 0x78, 0x04, 0x78,
  0x7C, 0x08, 0x04, 0x04, 0x78,
  0x38, 0x44, 0x44, 0x44, 0x38,
  0xFC, 0x18, 0x24, 0x24, 0x18,
  0x18, 0x24, 0x24, 0x18, 0xFC,
  0x7C, 0x08, 0x04, 0x04, 0x08,
  0x48, 0x54, 0x54, 0x54, 0x24,
  0x04, 0x04, 0x3F, 0x44, 0x24,
  0x3C, 0x40, 0x40, 0x20, 0x7C,
  0x1C, 0x20, 0x40, 0x20, 0x1C,
  0x3C, 0x40, 0x30, 0x40, 0x3C,
  0x44, 0x28, 0x10, 0x28, 0x44,
  0x4C, 0x90, 0x90, 0x90, 0x7C,
  0x44, 0x64, 0x54, 0x4C, 0x44,
  0x00, 0x08, 0x36, 0x41, 0x00,
  0x00, 0x00, 0x77, 0x00, 0x00,
  0x00, 0x41, 0x36, 0x08, 0x00,
  0x02, 0x01, 0x02, 0x04, 0x02,
  0x3C, 0x26, 0x23, 0x26, 0x3C,
  0x1E, 0xA1, 0xA1, 0x61, 0x12,
  0x3A, 0x40, 0x40, 0x20, 0x7A,
  0x38, 0x54, 0x54, 0x55, 0x59,
  0x21, 0x55, 0x55, 0x79, 0x41,
  0x21, 0x54, 0x54, 0x78, 0x41,
  0x21, 0x55, 0x54, 0x78, 0x40,
  0x20, 0x54, 0x55, 0x79, 0x40,
  0x0C, 0x1E, 0x52, 0x72, 0x12,
  0x39, 0x55, 0x55, 0x55, 0x59,
  0x39, 0x54, 0x54, 0x54, 0x59,
  0x39, 0x55, 0x54, 0x54, 0x58,
  0x00, 0x00, 0x45, 0x7C, 0x41,
  0x00, 0x02, 0x45, 0x7D, 0x42,
  0x00, 0x01, 0x45, 0x7C, 0x40,
  0xF0, 0x29, 0x24, 0x29, 0xF0,
  0xF0, 0x28, 0x25, 0x28, 0xF0,
  0x7C, 0x54, 0x55, 0x45, 0x00,
  0x20, 0x54, 0x54, 0x7C, 0x54,
  0x7C, 0x0A, 0x09, 0x7F, 0x49,
  0x32, 0x49, 0x49, 0x49, 0x32,
  0x32, 0x48, 0x48, 0x48, 0x32,
  0x32, 0x4A, 0x48, 0x48, 0x30,
  0x3A, 0x41, 0x41, 0x21, 0x7A,
  0x3A, 0x42, 0x40, 0x20, 0x78,
  0x00, 0x9D, 0xA0, 0xA0, 0x7D,
  0x39, 0x44, 0x44, 0x44, 0x39,
  0x3D, 0x40, 0x40, 0x40, 0x3D,
  0x3C, 0x24, 0xFF, 0x24, 0x24,
  0x48, 0x7E, 0x49, 0x43, 0x66,
  0x2B, 0x2F, 0xFC, 0x2F, 0x2B,
  0xFF, 0x09, 0x29, 0xF6, 0x20,
  0xC0, 0x88, 0x7E, 0x09, 0x03,
  0x20, 0x54, 0x54, 0x79, 0x41,
  0x00, 0x00, 0x44, 0x7D, 0x41,
  0x30, 0x48, 0x48, 0x4A, 0x32,
  0x38, 0x40, 0x40, 0x22, 0x7A,
  0x00, 0x7A, 0x0A, 0x0A, 0x72,
  0x7D, 0x0D, 0x19, 0x31, 0x7D,
  0x26, 0x29, 0x29, 0x2F, 0x28,
  0x26, 0x29, 0x29, 0x29, 0x26,
  0x30, 0x48, 0x4D, 0x40, 0x20,
  0x38, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x08, 0x08, 0x08, 0x38,
  0x2F, 0x10, 0xC8, 0xAC, 0xBA,
  0x2F, 0x10, 0x28, 0x34, 0xFA,
  0x00, 0x00, 0x7B, 0x00, 0x00,
  0x08, 0x14, 0x2A, 0x14, 0x22,
  0x22, 0x14, 0x2A, 0x14, 0x08,
  0xAA, 0x00, 0x55, 0x00, 0xAA,
  0xAA, 0x55, 0xAA, 0x55, 0xAA,
  0x00, 0x00, 0x00, 0xFF, 0x00,
  0x10, 0x10, 0x10, 0xFF, 0x00,
  0x14, 0x14, 0x14, 0xFF, 0x00,
  0x10, 0x10, 0xFF, 0x00, 0xFF,
  0x10, 0x10, 0xF0, 0x10, 0xF0,
  0x14, 0x14, 0x14, 0xFC, 0x00,
  0x14, 0x14, 0xF7, 0x00, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x14, 0x14, 0xF4, 0x04, 0xFC,
  0x14, 0x14, 0x17, 0x10, 0x1F,
  0x10, 0x10, 0x1F, 0x10, 0x1F,
  0x14, 0x14, 0x14, 0x1F, 0x00,
  0x10, 0x10, 0x10, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0x10,
  0x10, 0x10, 0x10, 0x1F, 0x10,
  0x10, 0x10, 0x10, 0xF0, 0x10,
  0x00, 0x00, 0x00, 0xFF, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0xFF, 0x10,
  0x00, 0x00, 0x00, 0xFF, 0x14,
  0x00, 0x00, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x1F, 0x10, 0x17,
  0x00, 0x00, 0xFC, 0x04, 0xF4,
  0x14, 0x14, 0x17, 0x10, 0x17,
  0x14, 0x14, 0xF4, 0x04, 0xF4,
  0x00, 0x00, 0xFF, 0x00, 0xF7,
  0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0xF7, 0x00, 0xF7,
  0x14, 0x14, 0x14, 0x17, 0x14,
  0x10, 0x10, 0x1F, 0x10, 0x1F,
  0x14, 0x14, 0x14, 0xF4, 0x14,
  0x10, 0x10, 0xF0, 0x10, 0xF0,
  0x00, 0x00, 0x1F, 0x10, 0x1F,
  0x00, 0x00, 0x00, 0x1F, 0x14,
  0x00, 0x00, 0x00, 0xFC, 0x14,
  0x00, 0x00, 0xF0, 0x10, 0xF0,
  0x10, 0x10, 0xFF, 0x10, 0xFF,
  0x14, 0x14, 0x14, 0xFF, 0x14,
  0x10, 0x10, 0x10, 0x1F, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x10,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF0, 0xF0, 0xF0, 0xF0, 0xF0,
  0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
  0x38, 0x44, 0x44, 0x38, 0x44,
  0x7C, 0x2A, 0x2A, 0x3E, 0x14,
  0x7E, 0x02, 0x02, 0x06, 0x06,
  0x02, 0x7E, 0x02, 0x7E, 0x02,
  0x63, 0x55, 0x49, 0x41, 0x63,
  0x38, 0x44, 0x44, 0x3C, 0x04,
  0x40, 0x7E, 0x20, 0x1E, 0x20,
  0x06, 0x02, 0x7E, 0x02, 0x02,
  0x99, 0xA5, 0xE7, 0xA5, 0x99,
  0x1C, 0x2A, 0x49, 0x2A, 0x1C,
  0x4C, 0x72, 0x01, 0x72, 0x4C,
  0x30, 0x4A, 0x4D, 0x4D, 0x30,
  0x30, 0x48, 0x78, 0x48, 0x30,
  0xBC, 0x62, 0x5A, 0x46, 0x3D,
  0x3E, 0x49, 0x49, 0x49, 0x00,
  0x7E, 0x01, 0x01, 0x01, 0x7E,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x44, 0x44, 0x5F, 0x44, 0x44,
  0x40, 0x51, 0x4A, 0x44, 0x40,
  0x40, 0x44, 0x4A, 0x51, 0x40,
  0x00, 0x00, 0xFF, 0x01, 0x03,
  0xE0, 0x80, 0xFF, 0x00, 0x00,
  0x08, 0x08, 0x6B, 0x6B, 0x08,
  0x36, 0x12, 0x36, 0x24, 0x36,
  0x06, 0x0F, 0x09, 0x0F, 0x06,
  0x00, 0x00, 0x18, 0x18, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x00,
  0x30, 0x40, 0xFF, 0x01, 0x01,
  0x00, 0x1F, 0x01, 0x01, 0x1E,
  0x00, 0x19, 0x1D, 0x17, 0x12,
  0x00, 0x3C, 0x3C, 0x3C, 0x3C,
  0x00, 0x00, 0x00, 0x00, 0x00,
};


/**
  * @}
  */


/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif
