/*********************************************************************************************************//**
 * @file    BMD58T280_HT32/src/XPT2046.h
 * @version V1.0.1
 * @date    2025-07-18
 * @brief   The header file of XPT2046 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __XPT2046_H
#define __XPT2046_H
#include "ht32.h"
#include "ht32_board_config.h"

#define TP_IRQ_STATE                     GPIO_ReadInBit(XPT2046_PEN_GPIO_PORT, XPT2046_PEN_GPIO_PIN)

#define aim_margin           40
#define circle_Radius        10

#define picX   20
#define picY   40
#define picW   32
#define picH   32
#define picYoffset   30
#define YellowYoffset   15


//-----------------------------------------------------------------------------
void XPT2046_Configuration(void);
u8 touch_read_xy(u16 *x, u16 *y);
void touch_scan(void);
u16 touch_read_x_or_y(u8 xy);
u16 touch_read_ad(u8 xy);
u8 touch_read_xy2(u16 *x,u16 *y);
void T_test(void);
void T_test2(void);
//-----------------------------------------------------------------------------
#endif

