 /************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

#include "delay.h"

#define STEP_DELAY_MS                    50

static vu32 fac_us;
static vu32 fac_ms;


void delay_init(void)
{
  /* configure systick */
  SYSTICK_ClockSourceConfig(SYSTICK_SRC_FCLK);
  fac_us = SystemCoreClock / (1000000U);
  fac_ms = fac_us * (1000U);
}

/*
	us
*/
void delay_us(u32 nus)
{
  u32 temp = 0;
  SysTick->LOAD = (u32)(nus * fac_us);         
  SysTick->VAL = 0x00;                              
  SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk ;        
  do
  {
    temp = SysTick->CTRL;                           
  }while((temp & 0x01) && !(temp & (1 << 16)));     

  SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;        
  SysTick->VAL = 0x00;                              
}

/*
	ms
*/
void delay_ms(u16 nms)
{
  u32 temp = 0;
  while(nms)
  {
    if(nms > STEP_DELAY_MS)
    {
      SysTick->LOAD = (u32)(STEP_DELAY_MS * fac_ms);
      nms -= STEP_DELAY_MS;
    }
    else
    {
      SysTick->LOAD = (u32)(nms * fac_ms);
      nms = 0;
    }
    SysTick->VAL = 0x00;
    SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk;
    do
    {
      temp = SysTick->CTRL;
    }while((temp & 0x01) && !(temp & (1 << 16)));

    SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;
    SysTick->VAL = 0x00;
  }
}

