/*********************************************************************************************************//**
 * @file    BMD58T280_HT32/example_display/main.c
 * @version V1.0.1
 * @date    2025-07-18
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "ht32_board_config.h"
#include "delay.h"
#include "USART.h"
#include "EBI.h"
#include "TFT_driver_ILI9341.h"
#include "XPT2046.h"
#include "BMLOGO50X49bmp.h"
#include "SPI.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/
/* Global variables ----------------------------------------------------------------------------------------*/
char* showStr[]={"       0","       1","       2","       3","       4","       5"};
u8 i=0;
/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/

/*********************************************************************************************************//**
  * @brief  Main program.
  * @retval None
  ***********************************************************************************************************/
int main(void)
{
  delay_init();
	
  USART_Configuration();
  
#if (LCD_MODE==LCD_EBI_MODE)
  EBI_Configuration();
#endif

  SPI1_Configuration();
	
  TFT_setRotation(0);    //Please note that TFT_setRotation needs to be set before the TFT_Configuration
	
  TFT_Configuration();
  XPT2046_Configuration();
  TFT_background(White);

  TFT_fill(White);
  TFT_stroke(Blue);
  
  TFT_text("  BestModules", 0,Line1);
	TFT_text("    example",   0,Line2);
	TFT_text("Painting board",0,Line3);

  TFT_drawPixels((85), (120), 50, 49, gImage_BMLOGO_50_X_49);
	
  for(i=6;i>0;i--){
  TFT_displayStringLine_Font2(Line8, showStr[i-1]);
    delay_ms(1000);
  }
	
  T_test();    //Example1: Painting(Return touch coordinates)

  //T_test2(); //Example2: Painting
  
  while (1)
  {
    
  }
}
