 /************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
//-----------------------------------------------------------------------------
#include "SPI.h"

//-----------------------------------------------------------------------------
void SPI1_Configuration(void)
{
  SPI_InitTypeDef SPI_InitStruct;
  CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};
  CKCUClock.Bit.SPI1   = 1;
  CKCUClock.Bit.AFIO   = 1;
  CKCUClock.Bit.PC     = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);

  //TPCS enable
  AFIO_GPxConfig(SPI_XPT2046_CS_GPIO_ID, SPI_XPT2046_CS_GPIO_PIN, AFIO_FUN_GPIO);
  TP_CS_HIGH;
  GPIO_DirectionConfig(SPI_XPT2046_CS_GPIO_PORT, SPI_XPT2046_CS_GPIO_PIN, GPIO_DIR_OUT);
  
#if (LCD_MODE==LCD_SPI_MODE)
  //LCDCS enable
  AFIO_GPxConfig(SPI_LCD_CS_GPIO_ID, SPI_LCD_CS_GPIO_PIN, AFIO_FUN_GPIO);
  LCD_CS_HIGH;
  GPIO_DirectionConfig(SPI_LCD_CS_GPIO_PORT, SPI_LCD_CS_GPIO_PIN, GPIO_DIR_OUT);  
#endif  

  AFIO_GPxConfig(SPI_MOSI_GPIO_ID, SPI_MOSI_AFIO_PIN, AFIO_FUN_SPI);  // Config AFIO mode
  AFIO_GPxConfig(SPI_MISO_GPIO_ID, SPI_MISO_AFIO_PIN, AFIO_FUN_SPI);  // Config AFIO mode
  AFIO_GPxConfig(SPI_SCK_GPIO_ID, SPI_SCK_AFIO_PIN, AFIO_FUN_SPI);  // Config AFIO mode

  SPI_InitStruct.SPI_Mode = SPI_MASTER;
  SPI_InitStruct.SPI_DataLength = SPI_DATALENGTH_8;
  SPI_InitStruct.SPI_SELMode = SPI_SEL_SOFTWARE;
  SPI_InitStruct.SPI_SELPolarity = SPI_SELPOLARITY_LOW;
  SPI_InitStruct.SPI_FirstBit = SPI_FIRSTBIT_MSB;
  SPI_InitStruct.SPI_CPOL = SPI_CPOL_LOW;
  SPI_InitStruct.SPI_CPHA = SPI_CPHA_FIRST;
  SPI_InitStruct.SPI_ClockPrescaler = 2;
  SPI_InitStruct.SPI_FIFO = SPI_FIFO_DISABLE;
  SPI_InitStruct.SPI_RxFIFOTriggerLevel = 4;
  SPI_InitStruct.SPI_TxFIFOTriggerLevel = 4;
  SPI_Init(HT_SPI1, &SPI_InitStruct);
  SPI_SELOutputCmd(HT_SPI1, ENABLE);
  SPI_Cmd(HT_SPI1, ENABLE);

}

//(XPT2046)
void SPI1_SwitchToLowSpeed(void) 
{
    SPI_Cmd(HT_SPI1, DISABLE);
	  {
    SPI_InitTypeDef SPI_InitStructure;
    SPI_StructInit(&SPI_InitStructure);
    SPI_InitStructure.SPI_Mode=SPI_MASTER;
    SPI_InitStructure.SPI_DataLength = SPI_DATALENGTH_8;  
    SPI_InitStructure.SPI_ClockPrescaler = 256; 
    SPI_Init(HT_SPI1, &SPI_InitStructure);
		}
    SPI_Cmd(HT_SPI1, ENABLE);
}

//(ILI9341)
void SPI1_SwitchToHighSpeed(void) 
{
    SPI_Cmd(HT_SPI1, DISABLE);
	  {
    SPI_InitTypeDef SPI_InitStructure;
    SPI_StructInit(&SPI_InitStructure);
    SPI_InitStructure.SPI_Mode=SPI_MASTER;
    SPI_InitStructure.SPI_DataLength = SPI_DATALENGTH_8;
    SPI_InitStructure.SPI_ClockPrescaler = 2;
    SPI_Init(HT_SPI1, &SPI_InitStructure);
		}
    SPI_Cmd(HT_SPI1, ENABLE);
}

//-----------------------------------------------------------------------------
u8 SPI1_MASTER_SendByte(u8 byte)
{
  while (SPI_GetFlagStatus(HT_SPI1, SPI_FLAG_TXE) == 0);
  SPI_SendData(HT_SPI1,  byte);
  while (SPI_GetFlagStatus(HT_SPI1, SPI_FLAG_RXBNE) == 0);
  return SPI_ReceiveData(HT_SPI1);
}

u8 SPI1_TP_ReadByte(void)
{
  return SPI1_MASTER_SendByte(0x00);;
}

void SPI1_TP_WriteByte(u8 byte)
{
  SPI1_MASTER_SendByte(byte);
}

//-----------------------------------------------------------------------------


