/*********************************************************************************************************//**
 * @file    BMD58T280_HT32/src/TFT_driver_ILI9341.h
 * @version V1.0.1
 * @date    2025-07-18
 * @brief   The header file of ILI9341 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __TFT_DRIVER_ILI9341_H
#define __TFT_DRIVER_ILI9341_H

#ifdef __cplusplus
 extern "C" {
#endif

//-----------------------------------------------------------------------------
#include "ht32.h"

#if (LCD_MODE==LCD_SPI_MODE)
   #define LCD_DC_HIGH                       GPIO_SetOutBits(LCD_SPI_DC_GPIO_PORT,LCD_SPI_DC_GPIO_PIN)
   #define LCD_DC_LOW                        GPIO_ClearOutBits(LCD_SPI_DC_GPIO_PORT,LCD_SPI_DC_GPIO_PIN)  
   
   #define LCD_BL_HIGH                       GPIO_SetOutBits(LCD_SPI_BL_GPIO_PORT,LCD_SPI_BL_GPIO_PIN)
   #define LCD_BL_LOW                        GPIO_ClearOutBits(LCD_SPI_BL_GPIO_PORT,LCD_SPI_BL_GPIO_PIN)     
   
#endif

//-----------------------------------------------------------------------------
// TFT color
#define White             0xFFFF
#define Black             0x0000
#define Grey              0xF7DE
#define Blue              0x001F
#define Blue2             0x051F
#define Red               0xF800
#define Magenta           0xF81F
#define Green             0x07E0
#define Cyan              0x7FFF
#define Yellow            0xFFE0

//-----------------------------------------------------------------------------
#define Line0          0
#define Line1          24
#define Line2          48
#define Line3          72
#define Line4          96
#define Line5          120
#define Line6          144
#define Line7          168
#define Line8          192
#define Line9          216

#define Horizontal     0x00
#define Vertical       0x01

/********** Users functions **********/
void    TFT_setRotation(u8 dir); //Similar Arduino Library
u8      TFT_getRotation(void);   //Similar Arduino Library
int16_t TFT_height(void);        //Similar Arduino Library
int16_t TFT_width(void);         //Similar Arduino Library

void TFT_background(u16 Color);  //Similar Arduino Library

void TFT_fill(u16 Color);        //Similar Arduino Library
void TFT_stroke(u16 Color);      //Similar Arduino Library

void TFT_drawPoint(u16 Xpos, u16 Ypos, u32 RGB_Set);
void TFT_point(u16 Xpos, u16 Ypos);  //Similar Arduino Library

void TFT_fillRect(u16 Xstart, u16 Ystart, u16 Width, u16 Height, u32 Color);
void TFT_drawRect(u32 X_Location, u32 Y_Location, u32 Width, u32 Height,u16 Color);
void TFT_rect(u16 Xstart, u16 Ystart, u16 Width, u16 Height);   //Similar Arduino Library

void TFT_fillCircle(u32 X_Location, u32 Y_Location, u32 Radius,u16 Color);
void TFT_drawCircle(u32 X_Location, u32 Y_Location, u32 Radius,u16 Color);  
void TFT_circle(u32 X_Location, u32 Y_Location, u32 Radius);    //Similar Arduino Library

void TFT_drawLine(u32 X_Location, u32 Y_Location, u32 Length, u32 Direction,u16 Color);
void TFT_line(u32 X_Start, u32 Y_Start, u32 X_End, u32 Y_End);  //Similar Arduino Library

void TFT_drawPixels(u8 X_Location, u16 Y_Location, u16 Width, u8 Height, uc8 *Pptr);               //Similar Arduino Library

void TFT_setAddrWindow(u16 Xstart, u16 Ystart, u16 Width, u16 Height);                             //Similar Arduino Library

void TFT_starterSet(u32 X_Location, u32 Y_Location);
void TFT_writeRAMWord(u32 RGB_Set);

/* Font Format:Font1(Similar Arduino Library)  */
void TFT_setTextSize(uint8_t s);                                                                   //Similar Arduino Library
void TFT_drawChar(int16_t x, int16_t y, unsigned char c,uint16_t color, uint16_t bg, uint8_t size);//Similar Arduino Library
void TFT_text(const char * text, int16_t x, int16_t y);                                            //Similar Arduino Library

/* Font Format:Font2  */
void TFT_drawChar_Font2(u32 X_Location, u32 Y_Location, u16 *Cptr);
void TFT_displayChar_Font2(u32 X_Location, u32 Y_Location, u32 Ascii);
void TFT_displayString_Font2(u32 X_Location, u32 Y_Location, char *Sptr);
void TFT_displayStringLine_Font2(u32 Line_Num, char *Sptr);

/********** Basic functions **********/
void TFT_Configuration(void);
void TFT_WriteReg(u32 TFT_Reg_Index, u32 TFT_Reg_Value);
void TFT_WriteRAMPrior(void);
void TFT_WriteRAM(u32 RGB_Set);
void TFT_WriteReg8(u8 Value);
void TFT_WriteRAM8(u8 Value);
void TFT_WriteRAM16(u16 Value);

/********** examples functions **********/
void TFT_HorizontalLineBorder(s32 X_Start, s32 X_End, s32 Y,u16 Color);
void TFT_SolidCircleDrawBorder(s32 X_Location, s32 Y_Location, u32 Radius,u16 Xstart,u16 Xend,u16 Ystart,u16 Yend,u16 Color);


#ifdef __cplusplus
}
#endif

#endif

