/*****************************************************************
  File:             BM22S4421-1.h
  Author:           BESTMODULES
  Description:      Define classes and required variables
  Version:          V1.0.1    -- 2023-12-04
******************************************************************/
#ifndef BM22S4421_1_H_
#define BM22S4421_1_H_

#include <Arduino.h>
#include <SoftwareSerial.h>

#define BAUDRATE 4800
#define CHECK_OK 0
#define CHECK_ERROR 1
#define TIMEOUT_ERROR 1
#define LOW_LEVEL 1
#define HIGH_LEVEL  2

class BM22S4421_1
{
public:
  BM22S4421_1(uint8_t statusPin, HardwareSerial *theSerial = &Serial);
  BM22S4421_1(uint8_t statusPin, uint8_t rxPin, uint8_t txPin);
  void begin();
  uint8_t getFWVer();
  uint8_t setSensingDistance(uint8_t value);
  uint8_t setOutMode(uint8_t mode);
  uint8_t setOutTime(uint8_t time);

private:
  uint8_t _statusPin, _rxPin, _txPin;
  void writeBytes(uint8_t wBuf[], uint8_t wLen = 5);
  uint8_t readBytes(uint8_t rBuf[], uint8_t rLen, uint16_t timeout = 15);
  HardwareSerial *_hardSerial = NULL;
  SoftwareSerial *_softSerial = NULL;
};

#endif
