/*************************************************
File:         BM22S4421-1_example.ino
Description:  Read the OUT pin level, 
              the level = 1(HIGH): turn on D13 LED;
              the level = 0(LOW): turn off D13 LED.
Note:
**************************************************/
#include "BM22S4421-1.h"

uint8_t FWVer;
BM22S4421_1 radar(4, 2, 3);    // statusPin, rxPin, txPin; Please comment out this line of code if you don't use SW Serial
// BM22S4421_1 radar(22, &Serial1); // statusPin, Hardware serial; Please comment out this line of code if you don't use HW Serial1
// BM22S4421_1 radar(25, &Serial2); // statusPin, Hardware serial; Please comment out this line of code if you don't use HW Serial2
void setup()
{
  radar.begin();        // Initialize module
  Serial.begin(9600); // Initialize Serial, baud rate 9600bps
  pinMode(13, OUTPUT);
  delay(1500); // Module power on Warm up
  FWVer = radar.getFWVer();
  Serial.print("FWVer: V");
  Serial.print(FWVer >> 4);
  Serial.print(".");
  Serial.println(FWVer & 0x0f);
  /*If you need to modify the sensing distance, please use this function.
    1:5m, 2:9m, 3:10m, 4:11m, 5:12m, 6:13m, 7:14m(default) */
  // radar.setSensingDistance(7);

  /*If you need to modify the OUT pin output mode, please use this function
    HIGH_LEVEL: Output high level when sensing an object(default)
    LOW_LEVEL: Output low level when sensing an object */
  // radar.setOutMode(HIGH_LEVEL);

  /*If you need to modify the OUT Pin output delay time, please use this function.
    1~250: Unit:second, deault 3 second*/
  // radar.setOutTime(3);
}
void loop()
{
  if (digitalRead(4) == HIGH)
  {
    digitalWrite(13, HIGH); // Object detected
  }
  else
  {
    digitalWrite(13, LOW); // No object detected
  }
}
