
#include "BH67F5250_60_70Sys_API.h"
#include "BH67F5250_60_70Sys_Config.h"
#include "common.h"

/**
 * @brief RAM初始化
 * @detail 將所有RAM初始為0
 *
 * @note 適用RAM大於256byte IP
 * @attention 注意
 * @warning 警告
 * @exception 异常
 */
static void fun_RamInit()
{
	_mp1h = 0;
	_mp1l = 0x80;
	while(_mp1h < 8)
	{
		for(_tblp = 0x00;_tblp < 128;_tblp++)
		{
			_iar1 = 0;
			_mp1l++;
		}
		_mp1l = 0x80;
		_mp1h++;
	}
}
/**
 * @brief 配置系統頻率
 * @detail 可選系統頻率 低速=LIRC/LXT  高速=HIRC_4M/HIRC_8M/HIRC_12M/HXT
 *
 * @note 注解
 * @attention 部分IC LXT功能 需要在 LXT2 Pin 加上拉10M到 VDD，詳細參考規格書 LXT 描述
 * @warning 若電路 HXT 晶振和 LXT 異常會造成程序在此死循環
 * @exception 异常
 */
void fun_SysClockInit()
{
    // *********系統時鐘設定********//
    #ifdef _HIRC_4M_
        _fhs   = 0;
        _hircc = 0x01;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_4M_
    #ifdef _HIRC_8M_
        _fhs   = 0;
        _hircc = 0x05;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_8M_
    #ifdef _HIRC_12M_
        _fhs   = 0;
        _hircc = 0x09;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_12M_
    #ifdef _HXT_10M_BELOW_
        _pas11 = 1;         // SET PA4 TO OSC1
        _pas10 = 1;
        _pas07 = 1;         // SET PA3 TO OSC2
        _pas06 = 1;
        _fhs  = 1;
        _hxtc = 0x05;       // HXTM = 1，HXT Frequency<10MHz,HXT Oscillator Enable
        while (!_hxtf);     // Wait HXT Oscillator Stable
    #endif // _HXT_10M_BELOW_
    #ifdef _HXT_10M_OVER_
        _pas11 = 1;         // SET PA4 TO OSC1
        _pas10 = 1;
        _pas07 = 1;         // SET PA3 TO OSC2
        _pas06 = 1;
        _fhs  = 1;
        _hxtc = 0x05;       // HXTM = 1，HXT Frequency>10MHz,HXT Oscillator Enable
        while (!_hxtf);     // Wait HXT Oscillator Stable
    #endif // _HXT_10M_OVER_
    #ifdef _LXT_
        _lxten = 1;
        _fss   = 1;
		_fsiden = 1;		// Enter Halt LXT Is Enable
		unsigned char i;
		for(i=0;i<10;i++)
		{
		#ifdef _HIRC_4M_
			GCC_DELAY(10);
		#endif // _HIRC_4M_
		#ifdef _HIRC_8M_
			GCC_DELAY(20);
		#endif // _HIRC_8M_
		#ifdef _HIRC_12M_
			GCC_DELAY(30);
		#endif // _HIRC_12M_
			_pas00 = 0; //pa0
			_pas01 = 0;

			_pas04 = 0; //pa2
			_pas05 = 0;

			_papu2 = 1;
			_papu0 = 1;

			_pas00 = 1; //XT1
			_pas01 = 1;

			_pas04 = 1;  //XT2
			_pas05 = 1;
		}
        while (!_lxtf);     // Wait LXT Oscillator Stable
    #endif // _LXT_
    #ifdef _LIRC_
        _fss   = 0;
        _lxten = 0;
		_fsiden = 1;		// Enter Halt LIRC Is Enable
    #endif // _LIRC_
}
/**
 * @brief GPIO初始化，未使用IO
 * @warning 需要根據實際硬件配置所有IO
 *
 * @note 所有未使用IO設置為輸出 Low
 * @attention 以下複用腳使用第一個功能
 */
void  fun_GPIOPowerOnInit()
{

}
/**
 * @brief 休眠GPIO配置，未使用 IO 輸出 Low
 *
 */
void  fun_GPIOPowerDownInit()
{

}
/**
 * @brief MCU 上電初始化
 *
 */
void fun_SysPowerOnInit()
{
	//IAP not need	to init
	//EEPROM not need to init
	fun_GPIOPowerOnInit();		// GPIO
	fun_SysClockInit();	// Sys Clock
	fun_RamInit();		// RAM
	SET_WDTTIME_125MS(); // WDT
	SET_LVR_2V1();		// LVR
	SET_LVD_2V2();		// LVD
	// STM  unused
	// PTM0 unused
	// PTM1 unused
	SET_PTMn_TIMER_xMS(2,2000);	// PTM2
	SET_PTMnA_ISR_ENABLE(2);
	SET_M_FUNCT_N_ENABLE(1);
	SET_PTMn_ENABLE(2);

	SET_TIMEBASE_8MS(0);	// Timebase0
	SET_TIMEBASE_ENABLE(0);
	SET_TIMEBASE_1000MS(1);// Timebase1
	SET_TIMEBASE_ENABLE(1);
	// SIM unused
	// SPIA
	// UART
	// ADC
	// BGM
}

/**
 * @brief 關閉各個模塊進入 HALT 模式
 *
 * @note 若功耗異常，可在線 debug 使程序停留在 HALT 指令下
 * 查看每項 register 確認GPIO及各項功能是否正常關閉
 */
void fun_PowerDownInit()
{
	SET_WDT_DISABLE();
	SET_LVD_DISABLE();		// LVD
	fun_GPIOPowerDownInit();// GPIO
	SET_PTMn_DISABLE(2);	// PTM2
	SET_TIMEBASE_DISABLE(0);	// Timebase0
	SET_TIMEBASE_DISABLE(1); // Timebase1
}

//@------------外部中斷0入口函數--------------@
DEFINE_ISR(INT0_ISR, 0x004)
{

}
//@------------外部中斷1入口函數--------------@
DEFINE_ISR(INT1_ISR, 0x008)
{

}
//@-------MuFunction0 中斷入口函數------------@
// STM0 & PTM0 共用
DEFINE_ISR(MuFunction0_ISR, 0x010)
{
	_ptm0af = 0;
}
//@-------MuFunction1 中斷入口函數-----------@
// PTM1 & PTM2 共用
DEFINE_ISR(MuFunction1_ISR, 0x014)
{
	_ptm2af = 0;
}
//@-------MuFunction2 中斷入口函數-----------@
// LVD & EEPROM 共用
DEFINE_ISR(MuFunction2_ISP, 0x018)
{
    
}
//@----------Timebase0 中斷入口函數-----------@
DEFINE_ISR(Timebase0_ISR, 0x01C)
{
    USIM_Data.RxTimeOut++;
}
//@----------Timebase1 中斷入口函數-----------@
DEFINE_ISR(Timebase1_ISR, 0x020)
{

}
/*
// @-----------USIM 中斷入口函數--------------@
DEFINE_ISR(USIM_ISR, 0x024)
{

}
// @-------------SPIA 中斷入口函數--------------@
DEFINE_ISR(SPIA_ISR, 0x028)
{

}
// @------------ADC 中斷入口函數---------------@
DEFINE_ISR(ADC_ISR, 0x00C)
{

}
*/