
#include "common.h"

void fun_WriteMcuRegister(unsigned int WriteAddress, unsigned char WriteData);
unsigned char fun_ReadMcuRegister(unsigned int ReadAddress);

void main()
{
	//ДǷ늏λ߷rµďλ
	//늏λ늏λʼ֮WDTʼ
	if (_to == 0 || _pdf ==0)
	{

		//늏λʼ
		fun_SysPowerOnInit();
		fun_USIM_PowerOn();
		fun_ADCInit();
	}
	else
	{
		//WDTλʼ

	}
	//ѭh
	while(1)
	{
		GCC_CLRWDT();
		
		if (ADCSourceData.flag.b.IsReady)
		{
			ADCSourceData.flag.b.IsReady = 0;
			USIM_Data.TxBuf[0] = 0xA4;	// ADC Data Command
			USIM_Data.TxBuf[1] = 0x00;	// ADC Data Chanel Reserved
			USIM_Data.TxBuf[2] = ADCSourceData.data.byte.ByteHigh;
			USIM_Data.TxBuf[3] = ADCSourceData.data.byte.ByteMid;
			USIM_Data.TxBuf[4] = ADCSourceData.data.byte.ByteLow;
			USIM_Data.TxBuf[5] = USIM_Data.TxBuf[0] + USIM_Data.TxBuf[1] + USIM_Data.TxBuf[2] + USIM_Data.TxBuf[3] + USIM_Data.TxBuf[4];
			fun_UartStartTx(5);
		}
        fun_UartTimeOutReset();
		if (USIM_Data.flag.b.RxIsOK)
		{
			USIM_Data.flag.b.RxIsOK = 0;
			unsigned char checkSum;
			unsigned int address, data;
			checkSum = USIM_Data.RxBuf[0] + USIM_Data.RxBuf[1] + USIM_Data.RxBuf[2] + USIM_Data.RxBuf[3] + USIM_Data.RxBuf[4];
			if (checkSum == USIM_Data.RxBuf[5])
			{
				switch (USIM_Data.RxBuf[0])
				{
				case 0xA0:	// Read Register Command
					address = (USIM_Data.RxBuf[1] << 8) + USIM_Data.RxBuf[2];
					USIM_Data.TxBuf[0] = 0xA0;	// Read Register Command
					USIM_Data.TxBuf[1] = USIM_Data.RxBuf[1];	// Register Address high
					USIM_Data.TxBuf[2] = USIM_Data.RxBuf[2];	// Register Address low
					USIM_Data.TxBuf[3] = 0x00;	// Register Data high
					USIM_Data.TxBuf[4] = fun_ReadMcuRegister(address);
					USIM_Data.TxBuf[5] = USIM_Data.TxBuf[0] + USIM_Data.TxBuf[1] + USIM_Data.TxBuf[2] + USIM_Data.TxBuf[3] + USIM_Data.TxBuf[4];
					fun_UartStartTx(5);
					break;
				case 0xA1:	// Write Register Command
					address = (USIM_Data.RxBuf[1] << 8) + USIM_Data.RxBuf[2];
					data    = (USIM_Data.RxBuf[3] << 8) + USIM_Data.RxBuf[4];
					fun_WriteMcuRegister(address, data);
					USIM_Data.TxBuf[0] = 0xA1;	// Write Register Command
					USIM_Data.TxBuf[1] = USIM_Data.RxBuf[1];	// Write Address high
					USIM_Data.TxBuf[2] = USIM_Data.RxBuf[2];	// Write Address low
					USIM_Data.TxBuf[3] = 0x00;	// Write Data high
					USIM_Data.TxBuf[4] = 0x00;	// Write Data Low
					USIM_Data.TxBuf[5] = USIM_Data.TxBuf[0] + USIM_Data.TxBuf[1] + USIM_Data.TxBuf[2] + USIM_Data.TxBuf[3] + USIM_Data.TxBuf[4];
					fun_UartStartTx(5);
					break;
				case 0xA2:	// ADC Start
					fun_ADCStart();
					USIM_Data.TxBuf[0] = 0xA2;	// ADC Start Command
					USIM_Data.TxBuf[1] = 0x00;
					USIM_Data.TxBuf[2] = 0x00;
					USIM_Data.TxBuf[3] = 0x00;
					USIM_Data.TxBuf[4] = 0x00;
					USIM_Data.TxBuf[5] = USIM_Data.TxBuf[0] + USIM_Data.TxBuf[1] + USIM_Data.TxBuf[2] + USIM_Data.TxBuf[3] + USIM_Data.TxBuf[4];
					fun_UartStartTx(5);
					break;
				case 0xA3:	// ADC Stop
					fun_ADCStop();
					USIM_Data.TxBuf[0] = 0xA3;	// ADC Stop Command
					USIM_Data.TxBuf[1] = 0x00;
					USIM_Data.TxBuf[2] = 0x00;
					USIM_Data.TxBuf[3] = 0x00;
					USIM_Data.TxBuf[4] = 0x00;
					USIM_Data.TxBuf[5] = USIM_Data.TxBuf[0] + USIM_Data.TxBuf[1] + USIM_Data.TxBuf[2] + USIM_Data.TxBuf[3] + USIM_Data.TxBuf[4];
					fun_UartStartTx(5);
					break;
				default:
					break;
				}
			}
		}
	}
}

/**
 * @brief write Register
 *
 * @param WriteAddress
 * @param WriteData
 */
void fun_WriteMcuRegister(unsigned int WriteAddress, unsigned char WriteData)
{
	_mp1h = WriteAddress>>8;
	_mp1l = WriteAddress & 0x00ff;
	_iar1 = WriteData;
}
/**
 * @brief read Register
 *
 * @param ReadAddress
 * @return unsigned char
 */
unsigned char fun_ReadMcuRegister(unsigned int ReadAddress)
{
	unsigned char readData;
	_mp1h = ReadAddress>>8;
	_mp1l = ReadAddress & 0x00ff;
	readData = _iar1;
	return readData;
}