#ifndef SYS_INIT_CONFIG_H
#define SYS_INIT_CONFIG_H

#include "BH67F5250.h"
#define SYS_CLOCK_FREQ  8000000
#define _HIRC_8M_   //!< 系統頻率設置,設置後會自動設置系統頻率 _HIRC_4M_/_HIRC_8M_/_HIRC_12M_/_HXT_10M_OVER_
#define _LIRC_       //!< 系統低頻選擇,設置後會自動設置 _LIRC_ / _LXT_
/**
 * @brief WDT overflow 時間設置
 * @note WDT clock Source fs =fsub  WDT time =  2^18/fsub
 * example:(max time 周期最长2^18，Source fs = 32000)
 *
 */
#define SET_WDT_DISABLE()		    { _wdtc = 0xA8;}
#define SET_WDTTIME_8MS()		    { _wdtc = 0x50;}
#define SET_WDTTIME_32MS()		    { _wdtc = 0x51;}
#define SET_WDTTIME_125MS()		    { _wdtc = 0x52;}
#define SET_WDTTIME_500MS()		    { _wdtc = 0x53;}
#define SET_WDTTIME_1000MS()		{ _wdtc = 0x54;}
#define SET_WDTTIME_2000MS()		{ _wdtc = 0x55;}
#define SET_WDTTIME_4000MS()		{ _wdtc = 0x56;}
#define SET_WDTTIME_8000MS()		{ _wdtc = 0x57;}_
/**
 * @brief 若電壓滿足以下定義的低電壓復位值且保持時間大於 tLVR，則 MCU 復位，此時復位後暫存器內容不變
 * 若寫入以下四個定義的復位電壓值外也將導致 MCU 在 tSRESET 時間後復位，此時復位後暫存器回復為上電默認值2.1V
 *
 */
#define  SET_LVR_2V1()			    { _lvrc = 0x55;}
#define  SET_LVR_2V55()			    { _lvrc = 0x33;}
#define  SET_LVR_3V15()			    { _lvrc = 0x99;}
#define  SET_LVR_3V8()			    { _lvrc = 0xAA;}

#define SET_LVD_2V0()			{ _lvdc = 0x00; }
#define SET_LVD_2V2()			{ _lvdc = 0x01; }
#define SET_LVD_2V4()			{ _lvdc = 0x02; }
#define SET_LVD_2V7()			{ _lvdc = 0x03; }
#define SET_LVD_3V0()			{ _lvdc = 0x04; }
#define SET_LVD_3V3()			{ _lvdc = 0x05; }
#define SET_LVD_3V6()			{ _lvdc = 0x06; }
#define SET_LVD_4V0()			{ _lvdc = 0x07; }
#define SET_LVD_ENABLE()		{ _lvden =1;}
#define SET_LVD_DISABLE()		{ _lvden =0;}

// STM
#define	SET_STMA_ISR_ENABLE()		{ _stmaf = 0; _stmae =1;}
#define	SET_STMA_ISR_DISABLE()		{ _stmae = 0;}
#define SET_STMP_ISR_ENABLE()		{ _stmpf = 0; _stmpe =1;}
#define SET_STMP_ISR_DISABLE()		{ _stmpe = 0;}
// PTMn（N=0/1/2）
#define	SET_PTMnA_ISR_ENABLE(n)		{ _ptm##n##af = 0; _ptm##n##ae =1;}
#define	SET_PTMnA_ISR_DISABLE(n)	{ _ptm##n##ae = 0;}
#define SET_PTMnP_ISR_ENABLE(n)		{ _ptm##n##pf = 0; _ptm##n##pe =1;}
#define SET_PTMnP_ISR_DISABLE(n)	{ _ptm##n##pe = 0;}
#define SET_PTMn_DISABLE(n)         { _pt##n##on = 0;}
#define SET_PTMn_ENABLE(n)          { _pt##n##on = 1;}

#if SYS_CLOCK_FREQ == 4000000
    #define SET_STM_TIMER_xMS(x)     { _stmc0 = 0x20; _stmc1 = 0xC1; _stmal = (x/4)%256;_stmah = (x/4)/256;}
    #define SET_PTMn_TIMER_xMS(n,x)  { _ptm##n##c0 = 0x20; _ptm##n##c1 = 0xC1; _ptm##n##al = (x/4)%256;_ptm##n##ah = (x/4)/256;}
#endif
#if SYS_CLOCK_FREQ == 8000000
    #define SET_STM_TIMER_xMS(x)     { _stmc0 = 0x20; _stmc1 = 0xC1; _stmal = (x/2)%256;_stmah = (x/2)/256;}
    #define SET_PTMn_TIMER_xMS(n,x)  { _ptm##n##c0 = 0x20; _ptm##n##c1 = 0xC1; _ptm##n##al = (x/2)%256;_ptm##n##ah = (x/2)/256;}
#endif
#if SYS_CLOCK_FREQ == 12000000
    #define SET_STM_TIMER_xMS(x)     { _stmc0 = 0x30; _stmc1 = 0xC1; _stmal = (x/16)%256;_stmah = (x/16)/256;}
    #define SET_PTMn_TIMER_xMS(n,x)  { _ptm##n##c0 = 0x30; _ptm##n##c1 = 0xC1; _ptm##n##al = (x/16)%256;_ptm##n##ah = (x/16)/256;}
#endif
/**
 * @brief 復合終端使能和除能
 *
 * @note n=0/1/2
 */
#define SET_M_FUNCT_N_ENABLE(n)     { _mf##n##f = 0; _mf##n##e = 1;}
#define SET_M_FUNCT_N_DSIABLE(n)    { _mf##n##e = 0;}
/**
 * @brief timebase 週期設置
 * @attention 默認使用fs =fsub, LIRC/LXT
 * @warning n=0/1
 */
#define SET_TIMEBASE_8MS(n)		    { _pscr = 0x03; _tb##n##c = 0x00;}
#define SET_TIMEBASE_16MS(n)		{ _pscr = 0x03; _tb##n##c = 0x01;}
#define SET_TIMEBASE_32MS(n)		{ _pscr = 0x03; _tb##n##c = 0x02;}
#define SET_TIMEBASE_62MS(n)		{ _pscr = 0x03; _tb##n##c = 0x03;}
#define SET_TIMEBASE_124MS(n)	    { _pscr = 0x03; _tb##n##c = 0x04;}
#define SET_TIMEBASE_250MS(n)	    { _pscr = 0x03; _tb##n##c = 0x05;}
#define SET_TIMEBASE_500MS(n)	    { _pscr = 0x03; _tb##n##c = 0x06;}
#define SET_TIMEBASE_1000MS(n)	    { _pscr = 0x03; _tb##n##c = 0x07;}
#define SET_TIMEBASE_ENABLE(n)	    { _tb##n##f = 0x00; _tb##n##e = 0x01; _tb##n##on = 1;}
#define SET_TIMEBASE_DISABLE(n)	    { _tb##n##on = 0;}

#endif
