#ifndef DELTA_SIGMA_ADC_API_H
#define DELTA_SIGMA_ADC_API_H


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                  對外參數                                            @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
typedef struct
{
	union
	{
		struct
		{
            unsigned char ByteRes;		// R ADC 預留位
            unsigned char ByteLow;		// R ADC 原始數據低位
            unsigned char ByteMid;		// R ADC 原始數據中位
            unsigned char ByteHigh;		// R ADC 原始數據高位
		}byte;
		long ADCData;
	}data;
	unsigned int SamplingCnt; // R ADC 採集次數計數
	union {
		struct
		{
			unsigned char IsReady : 1; // R 有一筆原始ADC數據
		} b;
		unsigned char byte;
	} flag;
} ADCSource_t;

extern volatile ADCSource_t ADCSourceData;
void fun_ADCStop();
void fun_ADCStart();
void fun_ADCInit();

#endif