#ifndef _USIM_CONFIG_H_
#define _USIM_CONFIG_H_

// #include "USIM_API.h"
#include "BH67F5250.h"
// 只能SPI/IIC/UART三選一
// #define USIM_MODE_SPI
// #define USIM_MODE_IIC
#define USIM_MODE_UART
#define SYS_CLOCK_FREQ 8000000 //!< 4000000/8000000/12000000,依據系統頻率自動適配UART配置 Note 此值不修改系統頻率
#define USIM_VECTOR 0x24       //!< Interrupt Vector
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                SPI  基本設置                                         @
//                            只能SPI/IIC/UART三選一                                    @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//!< IO Pin share 設置
//!< TX PB3/PC4
//!< RX PA7/PC5
#define SET_USIM_UART_PIN()   { _pas17 = 1; _pas16 = 1; _pcs11 = 1; _pcs10 =0;}  // RX-PA7  TX-PC4
//!< 0-Master Mode Clock=fsys/4    1-Master Mode Clock=fsys/16
//!< 2-Master Mode Clock=fsys/64   3-Master Mode Clock=fsub
//!< 4-Master Mode Clock=PTM2 CCRP match frequency/2
//!< 5-Slave Mode
#define USIM_SPI_MODE           5

//!< 0-base High capture rising   1-base High capture falling
//!< 2-base Low  capture falling  3-base Low  capture rising
#define USIM_SPI_CLOCK_EDGE     0

#define USIM_SPI_DATA_MLS       0   //!< 0-LSB first  1-MSB first
#define USIM_SPI_CSEN_PIN       0   //!< 0-Disable 1-Enable
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                IIC  基本設置                                        @
//                            只能SPI/IIC/UART三選一                                   @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#define USIM_IIC_ADDRESS 0xA0      //!< I2C slave address
#define USIM_IIC_DEBOUNCE_TIME 0    //!< 0-No debounce   1- 2 system clock debounce     2/3-4 system clock debounce
#define USIM_IIC_ADDRESS_WAKE_UP 1 //!< I2C Address Match Wake-up control
#define USIM_IIC_TIMEOUT 1         //!< 0-Disable 1-Enable I2C Time-out control
#define USIM_IIC_TIMEOUT_PERIOD 64 //!< IIC time-out time is equal to (USIM_IIC_TIMEOUT_PERIOD+1)×(32/fSUB)
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// ====================================================================================@
//                                UART  基本設置                                       @
//                            只能SPI/IIC/UART三選一                                   @
// ====================================================================================@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//!< UART format
#define USIM_UART_DATA_BIT          0   //!< 0-8bit 1-9bit
#define USIM_UART_DATA_PARITY       0   //!< 0/1-None 2-Even parity  3-Odd parity
#define USIM_UART_STOP_BIT          0   //!< 0-1bit 1-2bit

#define USIM_UART_TX 1           //!< 0-Disable 1-Enable UART Transmitter enabled control
#define USIM_UART_RX 1           //!< 0-Disable 1-Enable UART Receiver enabled control
#define USIM_UART_ADDRESS 0      //!< 0-Disable 1-Enable Address detect function enable control
#define USIM_UART_WAKEUP 1       //!< 0-Disable 1-Enable RX pin wake-up UART function enable control
#define USIM_UART_RX_ISR 1       //!< 0-Disable 1-Enable Receiver interrupt enable control
#define USIM_UART_TX_ISR 1       //!< 0-Disable 1-Enable Transmitter Idle interrupt enable control
#define USIM_UART_TX_empty_ISR 1 //!< 0-Disable 1-Enable Transmitter Empty interrupt enable control


#define SET_UART_Format_D8_NONE_S1()		{ _ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D7_EVEN_S1()		{ _ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D7_ODD_S1()		    { _ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)1bit-Stop
#define SET_UART_Format_D9_NONE_S1()		{ _ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D8_EVEN_S1()		{ _ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)1bit-Stop
#define SET_UART_Format_D8_ODD_S1()		    { _ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)1bit-Stop
#define SET_UART_Format_D8_NONE_S2()		{ _ucr1 = 0x00; }// 傳輸8bit = (8bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D7_EVEN_S2()		{ _ucr1 = 0x20; }// 傳輸8bit = (7bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D7_ODD_S2()		    { _ucr1 = 0x30; }// 傳輸8bit = (7bit-Data  Odd -Parity  None-Add)2bit-Stop
#define SET_UART_Format_D9_NONE_S2()		{ _ucr1 = 0x40; }// 傳輸9bit = (9bit-Data  None-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D8_EVEN_S2()		{ _ucr1 = 0x60; }// 傳輸9bit = (8bit-Data  Even-Parity  None-Add)2bit-Stop
#define SET_UART_Format_D8_ODD_S2()		    { _ucr1 = 0x70; }// 傳輸9bit = (8bit-Data  Odd-Parity   None-Add)2bit-Stop

#define SET_UART_WAKEUP(x)				    { _wake  = x;}
#define SET_UART_ADDRESS(x)				    { _adden = x;}
#define SET_UART_RECEIVER_ISR(x)			{ _rie   = x;} // OERR(溢出)/RXIF(有有效數據)置位時可置中斷標誌位
#define SET_UART_TRANSMITTER_ISR(x)	        { _tiie = x;} // TIDLE(無數據傳輸)置位，可置中斷標誌位
#define SET_UART_TRANSMITTER_EMPTY_ISR(x)	{ _teie = x;} // TXIF(數據已加載到移位暫存器，TXR為空)置位時，可置中斷標誌位


#if SYS_CLOCK_FREQ == 4000000
    #define SET_UART_BAUDRATE_300()			    { _brgh = 0; _brg = 207;}
    #define SET_UART_BAUDRATE_1200()			{ _brgh = 1; _brg = 207;}
    #define SET_UART_BAUDRATE_2400()			{ _brgh = 1; _brg = 103;}
    #define SET_UART_BAUDRATE_4800()			{ _brgh = 1; _brg =  51;}
    #define SET_UART_BAUDRATE_9600()			{ _brgh = 1; _brg =  25;}
    #define SET_UART_BAUDRATE_19200()		    { _brgh = 1; _brg =  12;}
    #define SET_UART_BAUDRATE_250000()		    { _brgh = 1; _brg =   0;}
#endif
#if SYS_CLOCK_FREQ == 8000000
    #define SET_UART_BAUDRATE_1200()			{ _brgh = 0; _brg = 103;}
    #define SET_UART_BAUDRATE_2400()			{ _brgh = 1; _brg = 207;}
    #define SET_UART_BAUDRATE_4800()			{ _brgh = 1; _brg = 103;}
    #define SET_UART_BAUDRATE_9600()			{ _brgh = 1; _brg =  51;}
    #define SET_UART_BAUDRATE_19200()		    { _brgh = 1; _brg =  25;}
    #define SET_UART_BAUDRATE_38400()		    { _brgh = 1; _brg =  12;}
    #define SET_UART_BAUDRATE_250000()		    { _brgh = 1; _brg =   1;}
#endif
#if SYS_CLOCK_FREQ == 12000000
    #define SET_UART_BAUDRATE_1200()			{ _brgh = 0; _brg = 155;}
    #define SET_UART_BAUDRATE_2400()			{ _brgh = 0; _brg =  77;}
    #define SET_UART_BAUDRATE_4800()			{ _brgh = 1; _brg = 155;}
    #define SET_UART_BAUDRATE_9600()			{ _brgh = 1; _brg =  77;}
    #define SET_UART_BAUDRATE_19200()		    { _brgh = 1; _brg =  38;}
    #define SET_UART_BAUDRATE_57600()		    { _brgh = 1; _brg =  12;}
    #define SET_UART_BAUDRATE_250000()		    { _brgh = 1; _brg =   2;}
#endif

//!< 以下定義無實際意義,只是為了匹配不同MCU之間CFG的命名
#define _ucr1 _uucr1
#define _rie _urie
#define _teie _uteie
#define _tiie _utiie
#define _adden _uadden
#define _brgh _ubrgh
#define _brg _ubrg
#define _txif _utxif
#define _uarten _uren
#define _usr _uusr
#define _txr_rxr _utxr_rxr


#define ON	1
#define OFF	0
#define ENABLE 1
#define DISABLE 0
#endif
