 /************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
//Build by HT32init V1.09.20.506Beta
//-----------------------------------------------------------------------------
#ifndef __I2C0_H
#define __I2C0_H

//-----------------------------------------------------------------------------
#include "ht32.h"

//-----------------------------------------------------------------------------
typedef enum
{
  I2C0_UNFINISHED = 0,
  I2C0_FINISHED,
  I2C0_NACK,
  I2C0_TIMEOUT,
  I2C0_BUSERR,
} I2C0_RET_STATUS;

//-----------------------------------------------------------------------------
typedef struct 
{
  u8 *ptx_buffer;
  u16 tx_len;
  u16 tx_index;
  volatile I2C0_RET_STATUS tx_state;
  
  u8 *prx_buffer;
  u16 rx_len;
  u16 rx_index;
  volatile I2C0_RET_STATUS rx_state;
} I2C0_TypeDef;


//-----------------------------------------------------------------------------
#define I2C0_SCL_GPIO           B  //GPIO PORT
#define I2C0_SCL_PIN            0  //GPIO PIN
#define I2C0_SDA_GPIO           B  //GPIO PORT
#define I2C0_SDA_PIN            1  //GPIO PIN
    
#define I2C0_SCL_CLK            STRCAT2(P,         I2C0_SCL_GPIO)
#define I2C0_SCL_GPIO_ID        STRCAT2(GPIO_P,    I2C0_SCL_GPIO)
#define I2C0_SCL_GPIO_PORT      STRCAT2(HT_GPIO,   I2C0_SCL_GPIO)
#define I2C0_SCL_AFIO_PIN       STRCAT2(AFIO_PIN_, I2C0_SCL_PIN)
#define I2C0_SDA_CLK            STRCAT2(P,         I2C0_SDA_GPIO)
#define I2C0_SDA_GPIO_ID        STRCAT2(GPIO_P,    I2C0_SDA_GPIO)
#define I2C0_SDA_GPIO_PORT      STRCAT2(HT_GPIO,   I2C0_SDA_GPIO)
#define I2C0_SDA_AFIO_PIN       STRCAT2(AFIO_PIN_, I2C0_SDA_PIN)
    
#define I2C0_ADDRESS            1      /* don't care  for master*/
#define I2C0_SPEED              100000

#define ENABLE_I2C0_TIMEOUT
#define I2C0_TIMEOUT_COUNTER    (u32)(1000000/I2C0_SPEED) + 5   //ms


//#define TWO_BYTE_REG_ADDRESS  //1 byte address or 2 byte address
#define ENABLE_INTERNAL_PULLUP

//-----------------------------------------------------------------------------
void I2C0_Configuration(void);
void I2C0_initial(void);
void I2C0_write(u8 dev_addr, u8 *dat, u16 len);
void I2C0_read(u8 dev_addr, u16 reg_addr, u8 *dat, u16 len);
void I2C0_read_directly(u8 dev_addr, u8 *dat, u16 len);
void I2C0_write_waiting(void);
void I2C0_read_waiting(void);
void I2C0_check_lock(void);
void I2C0_unlock(void);
void I2C0_test(void);

//-----------------------------------------------------------------------------

#endif

