 /************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
//Build by HT32init V1.09.20.506Beta
//-----------------------------------------------------------------------------
#include "ht32.h"
#include "GPIO.h"
#include "BFTM0.h"
#include "I2C0.h"
#include "Drv_24BitADC.h"
#include "EXTI.h"


long displayADCData;
//-----------------------------------------------------------------------------
int main(void)
{
  GPIO_Configuration();
	EXTI_Configuration();
  BFTM0_Configuration();
  I2C0_Configuration();

  while (1)
  {
    if(HT_CKCU->APBCCR1 & (1 << 4))
      WDT_Restart();

		// 上電初始化ADC並開啟ADC轉換
    Drv_24BitADC_Init();
    Drv_24BitADC_Start();
    while (1)
    {
			// 等待中断标志，有下降沿可以读取ADC数据
			Drv_24BitADC_ReadADCData();
			if (ADCSourceData.flag.b.IsReady)
			{
				// user code
				// 读取ADC数据
				ADCSourceData.flag.b.IsReady = 0;
				displayADCData = ADCSourceData.data.ADCData;
			}
    }

    //I2C0_test();   //Can be removed

  }
}
