#include "Drv_24BitADC.h"
#include "I2C0.h"



#define IIC_ADDRESS_24BitADC 0x68        // IIC Slave Address
ADCSource_t ADCSourceData;
unsigned char array24BitADC[2];
unsigned char RegData;




void I2C0_write(u8 dev_addr, u8 *dat, u16 len);
void I2C0_read(u8 dev_addr, u16 reg_addr, u8 *dat, u16 len);

void Drv_24BitADC_ReadADCData(void)
{
	if (ADCSourceData.flag.b.IsCheck)
	{
		ADCSourceData.flag.b.IsCheck = 0;
		I2C0_read(IIC_ADDRESS_24BitADC, ADCR1, &RegData, 1);
		I2C0_read_waiting();

		if (RegData && 0x02 == 0x02)	// EOC == 1?
		{
			ADCSourceData.SamplingCnt++;
			if (ADCSourceData.SamplingCnt > 3)
			{
				array24BitADC[0] = ADCR1;
				array24BitADC[1] = RegData | 0x04;
				I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);// ADCDL = 1 Lock Data for read
				I2C0_write_waiting();

				ADCSourceData.data.byte.ByteRes = 0x00;
				I2C0_read(IIC_ADDRESS_24BitADC, ADRL, &ADCSourceData.data.byte.ByteLow, 1);
				I2C0_read_waiting();
				I2C0_read(IIC_ADDRESS_24BitADC, ADRM, &ADCSourceData.data.byte.ByteMid, 1);
				I2C0_read_waiting();
				I2C0_read(IIC_ADDRESS_24BitADC, ADRH, &ADCSourceData.data.byte.ByteHigh, 1);
				I2C0_read_waiting();

				array24BitADC[0] = ADCR1;
				array24BitADC[1] = RegData & 0xFB;
				I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);// ADCDL = 0 Unlock Data for ADC Convert
				I2C0_write_waiting();
				ADCSourceData.data.ADCData = ADCSourceData.data.ADCData / 256;
				ADCSourceData.flag.b.IsReady = 1;
			}
			array24BitADC[0] = ADCR1;
			array24BitADC[1] = RegData & 0xFd;
			I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);// eoc = 0
			I2C0_write_waiting();
		}
	}
}

void Drv_24BitADC_Init(void)
{
	array24BitADC[0] = HIRCC;
	array24BitADC[1] = 0x01;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();
	do
	{
		I2C0_read(IIC_ADDRESS_24BitADC, HIRCC, &RegData, 1);
		I2C0_read_waiting();
	} while (RegData != 0x03);

	array24BitADC[0] = SIMC0;
	array24BitADC[1] = 0x00;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = SIMTOC;
	array24BitADC[1] = 0x82;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = PWRC;
	array24BitADC[1] = (VCMEN << 7) + FADCK;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = PGAC0;
	array24BitADC[1] = ((VGS << 5) + (AGS << 3) + PGS);
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = PGAC1;
	array24BitADC[1] = ((INIS << 6) + (INX << 4) + (DCSET << 1));
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = PGACS;
	array24BitADC[1] = ((CHSN << 3) + CHSP);
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = ADCR0;
	array24BitADC[1] = ((ADOR << 1) + VREFS);
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = ADCR1;
	array24BitADC[1] = ((FLMS << 5) + (VRBUF << 3));
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = ADCS;
	array24BitADC[1] = ADCSN;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	array24BitADC[0] = ADCTE;
	array24BitADC[1] = 0xE7;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();
}

void Drv_24BitADC_Start(void)
{
	I2C0_read(IIC_ADDRESS_24BitADC, ADCR0, &RegData, 1);	// ADRST = 0 ADSLP = 0  ADOFF=0 (ADC power on and enter normal mode)
	I2C0_read_waiting();

	array24BitADC[0] = ADCR0;
	array24BitADC[1] = RegData&0x1F;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	I2C0_read(IIC_ADDRESS_24BitADC, ADCR0, &RegData, 1);	// ADRST = 0 ADSLP = 0  ADOFF=0 (ADC power on and enter normal mode)
	I2C0_read_waiting();

	array24BitADC[0] = ADCR0;
	array24BitADC[1] = RegData|0x80;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);	// ADRST = 1
	I2C0_write_waiting();

	array24BitADC[1] = RegData&0x7F;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);	// ADRST = 0
	I2C0_write_waiting();

	ADCSourceData.SamplingCnt = 0;
	ADCSourceData.flag.b.IsReady = 0;
	ADCSourceData.flag.b.IsCheck = 0;
}


void Drv_24BitADC_Stop(void)
{
	array24BitADC[0] = PWRC;
	array24BitADC[1] = 0x00;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();

	I2C0_read(IIC_ADDRESS_24BitADC, ADCR0, &RegData, 1);	// ADOFF = 1(ADC enter power off)
	I2C0_read_waiting();
	array24BitADC[0] = ADCR0;
	array24BitADC[1] = RegData|0x20;
	I2C0_write(IIC_ADDRESS_24BitADC, array24BitADC, 2);
	I2C0_write_waiting();
}
