 /************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
//Build by HT32init V1.09.20.506Beta
//-----------------------------------------------------------------------------
#include "I2C0.h"

//-----------------------------------------------------------------------------
I2C0_TypeDef struct_i2c0;
vu16 i2c0_timeout_ct;

//-----------------------------------------------------------------------------
static void clk_delay(u16 ct)
{
  while(ct--);
}

//-----------------------------------------------------------------------------
static void I2C0_TargetAddressConfig(HT_I2C_TypeDef* I2Cx, u16 I2C_Address, u32 I2C_Direction)
{
  if (I2C_Direction != I2C_MASTER_WRITE)
  {
    I2Cx->TAR = I2C_Address | I2C_MASTER_READ;
  }
   else
  {
    I2Cx->TAR = I2C_Address | I2C_MASTER_WRITE;
  }
  i2c0_timeout_ct = 0;
}

//-----------------------------------------------------------------------------
void I2C0_Configuration(void)
{
  u16 delay_ct;
  
  CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};
  CKCUClock.Bit.I2C0         = 1;
  CKCUClock.Bit.AFIO         = 1;
  CKCUClock.Bit.I2C0_SCL_CLK = 1;
  CKCUClock.Bit.I2C0_SDA_CLK = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
  
#ifdef ENABLE_INTERNAL_PULLUP
  GPIO_PullResistorConfig(I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN, GPIO_PR_UP);  //pull up
  GPIO_PullResistorConfig(I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN, GPIO_PR_UP);  //pull up
#endif
  GPIO_DirectionConfig   (I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN, GPIO_DIR_IN);
  GPIO_InputConfig       (I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN, ENABLE);
  GPIO_DirectionConfig   (I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN, GPIO_DIR_IN);
  GPIO_InputConfig       (I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN, ENABLE);
  for(delay_ct=0; delay_ct<256; delay_ct++);

  I2C0_check_lock();
  
  I2C0_initial();
}
  
//-----------------------------------------------------------------------------
void I2C0_initial(void)
{
  I2C_InitTypeDef  I2C_InitStruct;
  RSTCU_PeripReset_TypeDef RSTCUReset = {{0}};
  RSTCUReset.Bit.I2C0 = 1;
  RSTCU_PeripReset(RSTCUReset, ENABLE);

  /* I2C configuration */
  I2C_InitStruct.I2C_GeneralCall = I2C_GENERALCALL_DISABLE;
  I2C_InitStruct.I2C_AddressingMode = I2C_ADDRESSING_7BIT;
  I2C_InitStruct.I2C_Acknowledge = I2C_ACK_DISABLE;
  I2C_InitStruct.I2C_OwnAddress = I2C0_ADDRESS;
  I2C_InitStruct.I2C_Speed = I2C0_SPEED;  
  I2C_InitStruct.I2C_SpeedOffset = 0;  
  I2C_Init(HT_I2C0, &I2C_InitStruct);
  I2C_Cmd(HT_I2C0, ENABLE);
//  I2C_SequentialFilterConfig(HT_I2C0, SEQ_FILTER_2_PCLK);  

#ifdef ENABLE_I2C0_TIMEOUT
  I2C_SetTimeOutPrescaler(HT_I2C0, 7<<16);  //f(PCLK)/128
  if(I2C0_TIMEOUT_COUNTER > 174)
    I2C_SetTimeOutValue(HT_I2C0, 65535);
  else
    I2C_SetTimeOutValue(HT_I2C0, I2C0_TIMEOUT_COUNTER*375);
  I2C_TimeOutCmd(HT_I2C0, ENABLE);
  I2C_IntConfig(HT_I2C0, I2C_INT_STA | I2C_INT_ADRS | I2C_INT_RXNACK | I2C_INT_BUSERR | I2C_INT_TOUT | I2C_INT_RXDNE | I2C_INT_TXDE, ENABLE);
#else
  I2C_IntConfig(HT_I2C0, I2C_INT_STA | I2C_INT_ADRS | I2C_INT_RXNACK | I2C_INT_BUSERR | I2C_INT_RXDNE | I2C_INT_TXDE, ENABLE);
#endif

  //NVIC_SetPriority(I2C0_IRQn, 1);
  NVIC_EnableIRQ(I2C0_IRQn);
}

//-----------------------------------------------------------------------------
void I2C0_IRQHandler(void)
{
  u32 status = I2C_ReadRegister(HT_I2C0, I2C_REGISTER_SR);
  if(status & I2C_FLAG_MASTER)    //master mode
  {
    if(status & I2C_FLAG_STA)
    {
      i2c0_timeout_ct = 0;
    }
    if(status & I2C_FLAG_TXNRX)   //tx mode
    {
      if(status & I2C_FLAG_ADRS)  //Master Transmitter
      {
        I2C_SendData(HT_I2C0, struct_i2c0.ptx_buffer[struct_i2c0.tx_index++]);
        i2c0_timeout_ct = 0;
      }
      else if(status & I2C_FLAG_TXDE)
      {
        if (struct_i2c0.tx_index < struct_i2c0.tx_len)
          I2C_SendData(HT_I2C0, struct_i2c0.ptx_buffer[struct_i2c0.tx_index++]);  //Send the remainder data to I2C Slave
        else
        {
          I2C_GenerateSTOP(HT_I2C0);
          struct_i2c0.tx_state = I2C0_FINISHED;
        }
        i2c0_timeout_ct = 0;
      }
    }
    else  //rx mode
    {
      if(status & I2C_FLAG_ADRS)    //Master Receiver
      {
        if(struct_i2c0.rx_len <= 1)
          I2C_AckCmd(HT_I2C0, DISABLE);
        else
          I2C_AckCmd(HT_I2C0, ENABLE);
        i2c0_timeout_ct = 0;
      }
      else if(status & I2C_FLAG_RXDNE)
      {
        struct_i2c0.prx_buffer[struct_i2c0.rx_index++] = I2C_ReceiveData(HT_I2C0);
        if (struct_i2c0.rx_index == struct_i2c0.rx_len - 1)
        {
          I2C_AckCmd(HT_I2C0, DISABLE); //Disable I2C Master ACK 
        }
        if (struct_i2c0.rx_index == struct_i2c0.rx_len)
        {
          I2C_GenerateSTOP(HT_I2C0);    //Generate STOP
          struct_i2c0.rx_state = I2C0_FINISHED;
        }
        i2c0_timeout_ct = 0;
      }
    }
    if(status & (I2C_FLAG_BUSERR|I2C_FLAG_ARBLOS))
    {
      I2C_ClearFlag(HT_I2C0, I2C_FLAG_BUSERR|I2C_FLAG_ARBLOS);
      struct_i2c0.tx_state = I2C0_BUSERR;
      struct_i2c0.rx_state = I2C0_BUSERR;
    }
    if(status & I2C_FLAG_TOUTF)
    {
      I2C_ClearFlag(HT_I2C0, I2C_FLAG_TOUTF);
      struct_i2c0.tx_state = I2C0_TIMEOUT;
      struct_i2c0.rx_state = I2C0_TIMEOUT;
    }
    if(status & I2C_FLAG_RXNACK) 
    {
      I2C_ClearFlag(HT_I2C0, I2C_FLAG_RXNACK);
      I2C_GenerateSTOP(HT_I2C0);
      
      struct_i2c0.tx_state = I2C0_NACK;
      if(!struct_i2c0.rx_state)
        struct_i2c0.rx_state = I2C0_NACK;
    }
  }
  else
  {
    I2C_ClearFlag(HT_I2C0, status & 0x0f00);
  }

  status = I2C_ReadRegister(HT_I2C0, I2C_REGISTER_SR);
  if(status & I2C_FLAG_RXDNE)
    I2C_ReceiveData(HT_I2C0);
  if(status & I2C_FLAG_TXDE)
    I2C_SendData(HT_I2C0, 0x00); //clear TXDE
}

//-----------------------------------------------------------------------------
void I2C0_write(u8 dev_addr, u8 *dat, u16 len)
{
  struct_i2c0.ptx_buffer = dat;
  struct_i2c0.tx_len = len ? len : 1;
  struct_i2c0.tx_index = 0;
  struct_i2c0.tx_state = I2C0_UNFINISHED;
  I2C0_check_lock();
  I2C0_TargetAddressConfig(HT_I2C0, dev_addr, I2C_MASTER_WRITE);
}

//-----------------------------------------------------------------------------
void I2C0_read(u8 dev_addr, u16 reg_addr, u8 *dat, u16 len)
{
  u8 addr_buf[2];
  
  #ifdef TWO_BYTE_REG_ADDRESS
    addr_buf[0] = (reg_addr>>8)&0xff;
    addr_buf[1] = reg_addr&0xff;
    I2C0_write(dev_addr, addr_buf, 2); 
  #else
    addr_buf[0] = reg_addr&0xff;
    I2C0_write(dev_addr, addr_buf, 1); 
  #endif
  
  while(struct_i2c0.tx_state == I2C0_UNFINISHED)
  {
    if(i2c0_timeout_ct > I2C0_TIMEOUT_COUNTER)
    {
      I2C0_initial();
      break;
    }
  }

  if(struct_i2c0.tx_state == I2C0_FINISHED)
  {
    struct_i2c0.prx_buffer = dat;
    struct_i2c0.rx_len = len ? len : 1;;
    struct_i2c0.rx_index = 0;
    struct_i2c0.rx_state = I2C0_UNFINISHED;
    I2C0_check_lock();
      
    I2C0_TargetAddressConfig(HT_I2C0, dev_addr, I2C_MASTER_READ);
  }
  else
  {
    struct_i2c0.rx_state = I2C0_NACK;
  }
}

//-----------------------------------------------------------------------------
// @brief:  Slave device maybe do not need to write address at first
//-----------------------------------------------------------------------------
void I2C0_read_directly(u8 dev_addr, u8 *dat, u16 len)
{
  struct_i2c0.prx_buffer = dat;
  struct_i2c0.rx_len = len ? len : 1;;
  struct_i2c0.rx_index = 0;
  struct_i2c0.rx_state = I2C0_UNFINISHED;
  I2C0_check_lock();
 
  I2C0_TargetAddressConfig(HT_I2C0, dev_addr, I2C_MASTER_READ);
}

//-----------------------------------------------------------------------------
void I2C0_write_waiting(void)
{
  while(struct_i2c0.tx_state == I2C0_UNFINISHED)
  {
    if(i2c0_timeout_ct > I2C0_TIMEOUT_COUNTER)
    {
      I2C0_initial();
      break;
    }
  }
}

//-----------------------------------------------------------------------------
void I2C0_read_waiting(void)
{
  while(struct_i2c0.rx_state == I2C0_UNFINISHED)
  {
    if(i2c0_timeout_ct > I2C0_TIMEOUT_COUNTER)
    {
      I2C0_initial();
      break;
    }
  }
}

//-----------------------------------------------------------------------------
void I2C0_check_lock(void)
{
  u32 ct;
  for(ct=0; ct<100; ct++) //waiting for stop end
  {
    if(!(HT_I2C0->CR & 0x02))
      break;
    else
      clk_delay(100);
  }
  AFIO_GPxConfig(I2C0_SCL_GPIO_ID, I2C0_SCL_AFIO_PIN, AFIO_FUN_DEFAULT);
  AFIO_GPxConfig(I2C0_SDA_GPIO_ID, I2C0_SDA_AFIO_PIN, AFIO_FUN_DEFAULT);
  if(GPIO_ReadInBit(I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN) == RESET)
    I2C0_unlock();
  AFIO_GPxConfig(I2C0_SCL_GPIO_ID, I2C0_SCL_AFIO_PIN, AFIO_FUN_I2C);
  AFIO_GPxConfig(I2C0_SDA_GPIO_ID, I2C0_SDA_AFIO_PIN, AFIO_FUN_I2C);
}

//-----------------------------------------------------------------------------
// @brief   If slave has locked SDA, need unlock at first
//-----------------------------------------------------------------------------
void I2C0_unlock(void)
{
  u8 i;
  /* I2C configuration */
  GPIO_OpenDrainConfig(I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN, ENABLE);
  GPIO_SetOutBits     (I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN);
  GPIO_DirectionConfig(I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN, GPIO_DIR_OUT);

  GPIO_OpenDrainConfig(I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN, ENABLE);
  GPIO_SetOutBits     (I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN);
  GPIO_DirectionConfig(I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN, GPIO_DIR_OUT);

  GPIO_ClearOutBits   (I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN);
  clk_delay(50);
  for(i=0; i<9; i++)
  {
    GPIO_SetOutBits   (I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN);
    clk_delay(50);
    GPIO_ClearOutBits (I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN);
    clk_delay(50);
  }
  GPIO_ClearOutBits   (I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN);
  clk_delay(50);
  GPIO_SetOutBits     (I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN);
  clk_delay(50);
  GPIO_SetOutBits     (I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN);

  GPIO_DirectionConfig(I2C0_SCL_GPIO_PORT, I2C0_SCL_AFIO_PIN, GPIO_DIR_IN);
  GPIO_DirectionConfig(I2C0_SDA_GPIO_PORT, I2C0_SDA_AFIO_PIN, GPIO_DIR_IN);
}


//-----------------------------------------------------------------------------
#define TARGET_DEV_ADDR 0x50
//static  u8 read_addr = 0x00;
void I2C0_test(void)
{
  u8 i,test_array[4];
  for(i=0; i<4; i++)
  {
    test_array[i] = i;
  }
  I2C0_write(TARGET_DEV_ADDR, test_array, 4);    //write data test:device addr + register addr + data
  I2C0_write_waiting();

//  I2C0_write(TARGET_DEV_ADDR, &read_addr, 1); //The first read way: write address at first,then ...
//  I2C0_write_waiting();
  I2C0_read_directly(TARGET_DEV_ADDR, test_array, 4); //then read directly
  I2C0_read_waiting();                         //can process other task while waiting

//  I2C0_read(TARGET_DEV_ADDR, read_addr, test_array, 4); //The second read way: write reg address and read data back, as same as operate EEPROM
//  I2C0_read_waiting();
}







