#include "HT66F0195.h"
#define PWMDuty_Base  50       //PWM Duty up or down 5%
//#define PWMDuty_Max   1000     //PWM Duty 100%
#define PWMDuty_Max   970     //PWM Duty 97%
#define PWMDuty_Min   0       //PWM Duty 0%

bit direc_flag;            //direc_flag=0:PWM Duty up; direc_flag=1:PWM Duty down;					  
unsigned int PWM_COUNT;    //PWM Count
unsigned int PWM_Duty;     //PWM Duty 


//////////function/////////////
void ISR_PTM();
void PTM_init();


//---------------------------------
// main program
//---------------------------------
void main()
{
	PWM_COUNT =0;
	PWM_Duty = 0;         //PWM duty=0% 
    direc_flag = 0;       //PWM Duty up 
    
   	_wdtc = 0x53;          //enable wdtc
    _smod=0x01;            //chose HIRC as Fsys,HIRC=8M
    while(!(_smod&0x04));  //wait until HIRC ready
    
    PTM_init();           //PTM init
	while(1)
    {
    	_clrwdt();		  //clear wdtc
    }
  
}

//---------------------------------
// PTM Initial procedure
//---------------------------------
void PTM_init()
{
    _pac &=0x7f;    //set pa7 as output mode
    _acerl=0;       //disable pa7 as A/D port,set as tp1
    _slcdc2=0;		//disable pa7 as SSEG8 port,set as tp1
    _tmpc=0x02;	    //enable pa7 as tp1
    _ptmc0=0x20;    //f=FH/16,, TM1=Off state
    _ptmc1=0xa8;    //PWM_Mode, Active high, Non-invert,counter clear when comparator P match        
 	_ptmrpl=0xe8;   //PWM Period=500Hz,PWM Period=(FH/16)/(CCRP)=(8M/16)/1000
 	_ptmrph=0x03; 
    _ptmal=0;
    _ptmah=0;       //PWM duty=0%
    
    _mf1e=1; 	    // Multifunction 1 interrupt enable
    _ptmpe=1;       // PTM comparator P interrupt enable
//  _ptmae=1;       // PTM comparator A interrupt enable
   
	_ptmpf=0;       // clear PTM comparator P interrupt flag
    _ptmaf=0;       // clear PTM comparator A interrupt flag
    _mf1f=0;        // clear Multifunction 1 interrupt flag
    _emi=1;         //interrupt mask enable
   
    _pton=1;        //Let PTM start to run
}


//-----------------------------------
// PWM Interrupt Service Routine
//-----------------------------------
void __attribute((interrupt(0x10))) ISR_PTM(void)
{   
	if(_ptmpf==1)   //PWM Period
	{
    	_ptmpf=0;
   	    PWM_COUNT++; 
    }
  	
    if(_ptmaf==1)   //PWM duty	
    {
	    _ptmaf=0;
    }	
				
    if((PWM_COUNT == 80) && (direc_flag == 0))             //direc_flag=0,PWM duty up;
    {                              
    	PWM_COUNT = 0;
        PWM_Duty = PWM_Duty + PWMDuty_Base;                //PWM duty up 5%
        if(PWM_Duty >= PWMDuty_Max) PWM_Duty = PWMDuty_Max;
    	if(PWM_Duty == PWMDuty_Max) 
        {
        	direc_flag = 1;                                //if PWM duty=100%Athen PWM duty down
       		GCC_DELAY(1000);
       		GCC_DELAY(1000);
       		
        }
        _ptmal= (PWM_Duty & 0xff);    
   		_ptmah= (PWM_Duty & 0xff00) >> 8;      
    }
    if((PWM_COUNT == 80) && (direc_flag == 1))             //direc_flag=0,PWM duty down;
    {                             
        PWM_COUNT = 0;
        if(PWM_Duty > PWMDuty_Base) PWM_Duty = PWM_Duty - PWMDuty_Base;  //PWM duty down 5%
        else PWM_Duty = PWMDuty_Min;
        if(PWM_Duty == PWMDuty_Min) 
        {
        	direc_flag = 0;                                //if PWM duty=0%Athen PWM duty up
           GCC_DELAY(1000);
           GCC_DELAY(1000);
        }
        _ptmal= (PWM_Duty & 0xff);    
   		_ptmah= (PWM_Duty & 0xff00) >> 8;      
    } 
}

